# Generated by Django 3.2.8 on 2021-10-11 19:56

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("polaris", "0012_auto_20210918_2053"),
    ]

    operations = [
        migrations.CreateModel(
            name="DeliveryMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("type", models.TextField(choices=[("buy", "buy"), ("sell", "sell")])),
                ("name", models.TextField()),
                ("description", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="ExchangePair",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("buy_asset", models.TextField()),
                ("sell_asset", models.TextField()),
            ],
        ),
        migrations.AddField(
            model_name="asset",
            name="sep38_enabled",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="transaction",
            name="fee_asset",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="asset",
            name="deposit_fee_fixed",
            field=models.DecimalField(
                blank=True, decimal_places=7, max_digits=30, null=True
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="deposit_fee_percent",
            field=models.DecimalField(
                blank=True,
                decimal_places=7,
                max_digits=30,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="send_fee_fixed",
            field=models.DecimalField(
                blank=True, decimal_places=7, max_digits=30, null=True
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="send_fee_percent",
            field=models.DecimalField(
                blank=True,
                decimal_places=7,
                max_digits=30,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="withdrawal_fee_fixed",
            field=models.DecimalField(
                blank=True, decimal_places=7, max_digits=30, null=True
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="withdrawal_fee_percent",
            field=models.DecimalField(
                blank=True,
                decimal_places=7,
                max_digits=30,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="kind",
            field=models.CharField(
                choices=[
                    ("deposit", "deposit"),
                    ("withdrawal", "withdrawal"),
                    ("send", "send"),
                    ("deposit-exchange", "deposit-exchange"),
                    ("withdrawal-exchange", "withdrawal-exchange"),
                ],
                default="deposit",
                max_length=20,
            ),
        ),
        migrations.CreateModel(
            name="Quote",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                ("stellar_account", models.TextField()),
                ("account_memo", models.PositiveIntegerField(blank=True, null=True)),
                ("muxed_account", models.TextField(blank=True, null=True)),
                (
                    "type",
                    models.TextField(
                        choices=[("firm", "firm"), ("indicative", "indicative")]
                    ),
                ),
                ("sell_asset", models.TextField()),
                ("buy_asset", models.TextField()),
                ("sell_amount", models.DecimalField(decimal_places=7, max_digits=30)),
                (
                    "buy_amount",
                    models.DecimalField(
                        blank=True, decimal_places=7, max_digits=30, null=True
                    ),
                ),
                (
                    "price",
                    models.DecimalField(
                        blank=True, decimal_places=7, max_digits=30, null=True
                    ),
                ),
                ("expires_at", models.DateTimeField(blank=True, null=True)),
                ("country_code", models.TextField(blank=True, null=True)),
                ("requested_expire_after", models.DateTimeField(blank=True, null=True)),
                (
                    "buy_delivery_method",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="polaris.deliverymethod",
                    ),
                ),
                (
                    "sell_delivery_method",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="polaris.deliverymethod",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="OffChainAsset",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("scheme", models.TextField()),
                ("identifier", models.TextField()),
                ("significant_decimals", models.PositiveIntegerField(default=2)),
                ("country_codes", models.TextField(blank=True, null=True)),
                (
                    "delivery_methods",
                    models.ManyToManyField(to="polaris.DeliveryMethod"),
                ),
                ("symbol", models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.AddConstraint(
            model_name="exchangepair",
            constraint=models.UniqueConstraint(
                fields=("buy_asset", "sell_asset"), name="exchangepair_unique_index"
            ),
        ),
        migrations.AddConstraint(
            model_name="deliverymethod",
            constraint=models.UniqueConstraint(
                fields=("name", "type"), name="deliverymethod_unique_index"
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="quote",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="polaris.quote",
            ),
        ),
        migrations.AddConstraint(
            model_name="offchainasset",
            constraint=models.UniqueConstraint(
                fields=("scheme", "identifier"), name="offchain_unique_index"
            ),
        ),
    ]
