# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EnergyCharging(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'charging_mode': 'str',
        'charging_rate': 'int',
        'next_delayed_time': 'str',
        'plugged': 'bool',
        'remaining_time': 'str',
        'status': 'ChargingStatusEnum'
    }

    attribute_map = {
        'charging_mode': 'chargingMode',
        'charging_rate': 'chargingRate',
        'next_delayed_time': 'nextDelayedTime',
        'plugged': 'plugged',
        'remaining_time': 'remainingTime',
        'status': 'status'
    }

    def __init__(self, charging_mode=None, charging_rate=None, next_delayed_time=None, plugged=None, remaining_time=None, status=None):  # noqa: E501
        """EnergyCharging - a model defined in Swagger"""  # noqa: E501

        self._charging_mode = None
        self._charging_rate = None
        self._next_delayed_time = None
        self._plugged = None
        self._remaining_time = None
        self._status = None
        self.discriminator = None

        if charging_mode is not None:
            self.charging_mode = charging_mode
        if charging_rate is not None:
            self.charging_rate = charging_rate
        if next_delayed_time is not None:
            self.next_delayed_time = next_delayed_time
        if plugged is not None:
            self.plugged = plugged
        if remaining_time is not None:
            self.remaining_time = remaining_time
        if status is not None:
            self.status = status

    @property
    def charging_mode(self):
        """Gets the charging_mode of this EnergyCharging.  # noqa: E501

        The charging mode; Slow, Quick and No(not charging).  # noqa: E501

        :return: The charging_mode of this EnergyCharging.  # noqa: E501
        :rtype: str
        """
        return self._charging_mode

    @charging_mode.setter
    def charging_mode(self, charging_mode):
        """Sets the charging_mode of this EnergyCharging.

        The charging mode; Slow, Quick and No(not charging).  # noqa: E501

        :param charging_mode: The charging_mode of this EnergyCharging.  # noqa: E501
        :type: str
        """
        allowed_values = ["No", "Slow", "Quick"]  # noqa: E501
        if charging_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `charging_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(charging_mode, allowed_values)
            )

        self._charging_mode = charging_mode

    @property
    def charging_rate(self):
        """Gets the charging_rate of this EnergyCharging.  # noqa: E501

        Charging speed (expressed in gained batteryLife per hour -> KM/H).  # noqa: E501

        :return: The charging_rate of this EnergyCharging.  # noqa: E501
        :rtype: int
        """
        return self._charging_rate

    @charging_rate.setter
    def charging_rate(self, charging_rate):
        """Sets the charging_rate of this EnergyCharging.

        Charging speed (expressed in gained batteryLife per hour -> KM/H).  # noqa: E501

        :param charging_rate: The charging_rate of this EnergyCharging.  # noqa: E501
        :type: int
        """
        if charging_rate is not None and charging_rate > 500:  # noqa: E501
            raise ValueError("Invalid value for `charging_rate`, must be a value less than or equal to `500`")  # noqa: E501
        if charging_rate is not None and charging_rate < 0:  # noqa: E501
            raise ValueError("Invalid value for `charging_rate`, must be a value greater than or equal to `0`")  # noqa: E501

        self._charging_rate = charging_rate

    @property
    def next_delayed_time(self):
        """Gets the next_delayed_time of this EnergyCharging.  # noqa: E501

        timestamp ( as defined in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)) of the next battery charging.  # noqa: E501

        :return: The next_delayed_time of this EnergyCharging.  # noqa: E501
        :rtype: str
        """
        return self._next_delayed_time

    @next_delayed_time.setter
    def next_delayed_time(self, next_delayed_time):
        """Sets the next_delayed_time of this EnergyCharging.

        timestamp ( as defined in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)) of the next battery charging.  # noqa: E501

        :param next_delayed_time: The next_delayed_time of this EnergyCharging.  # noqa: E501
        :type: str
        """

        self._next_delayed_time = next_delayed_time

    @property
    def plugged(self):
        """Gets the plugged of this EnergyCharging.  # noqa: E501


        :return: The plugged of this EnergyCharging.  # noqa: E501
        :rtype: bool
        """
        return self._plugged

    @plugged.setter
    def plugged(self, plugged):
        """Sets the plugged of this EnergyCharging.


        :param plugged: The plugged of this EnergyCharging.  # noqa: E501
        :type: bool
        """

        self._plugged = plugged

    @property
    def remaining_time(self):
        """Gets the remaining_time of this EnergyCharging.  # noqa: E501

        remaning time before the battery is fully charged. This duraction is expressed using [ISO8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) format.  # noqa: E501

        :return: The remaining_time of this EnergyCharging.  # noqa: E501
        :rtype: str
        """
        return self._remaining_time

    @remaining_time.setter
    def remaining_time(self, remaining_time):
        """Sets the remaining_time of this EnergyCharging.

        remaning time before the battery is fully charged. This duraction is expressed using [ISO8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) format.  # noqa: E501

        :param remaining_time: The remaining_time of this EnergyCharging.  # noqa: E501
        :type: str
        """

        self._remaining_time = remaining_time

    @property
    def status(self):
        """Gets the status of this EnergyCharging.  # noqa: E501


        :return: The status of this EnergyCharging.  # noqa: E501
        :rtype: ChargingStatusEnum
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this EnergyCharging.


        :param status: The status of this EnergyCharging.  # noqa: E501
        :type: ChargingStatusEnum
        """

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EnergyCharging, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EnergyCharging):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
