""" It's often the case that you want to evaluate various metrics of a reconstructed object throughout iterations of a reconstruction algorithm. For example, you may want to look at the variance of radioactivity distribution in the liver as a function of iteration number in the OSEM algorithm. This is what callbacks can be used for. A callback is simply a function that takes in an object and returns some sort of metric. Callbacks are optional input to reconstruction algorithms; the ``run`` method of a callback is called after each subiteration of an iterative reconstruction algorithm. All user-defined callbacks should inherit from the base class ``CallBack``. A subclass of this class could be used to compute noise-bias curves provided the ``__init__`` method was redefined to take in some ground truth, and the run method was redefined to compare the obj to the ground truth.
"""
from .callback import CallBack