from tqix import *
from tqix.qtool import dotx
import numpy as np
from numpy import sqrt, pi,exp

__all__ = ['_sic_']
# use for inner povm.py

def _sic_(d):
    if d == 2:
       return _sic_2()
    elif d == 3:
       return _sic_3()
    elif d == 4:
       return _sic_4()
    else:
       return _sic_d(d)

def _sic_2():
    u = obasis(2,0)
    d = obasis(2,1)
    p1 = u
    p2 = 1/sqrt(3.)*u + sqrt(2/3.)*d
    p3 = 1/sqrt(3.)*u + sqrt(2/3.)*exp(1j*2*pi/3.)*d
    p4 = 1/sqrt(3.)*u + sqrt(2/3.)*exp(1j*4*pi/3.)*d
    p = [p1,p2,p3,p4]
    pp = []
    for i in p:
        pp.append(dotx(i,daggx(i)))
    return pp

def _sic_3():
    b0 = obasis(3,0)
    b1 = obasis(3,1)
    b2 = obasis(3,2)
    p1 = b0
    p2 = 0.5*b0 + 1j*sqrt(3.)/2.*b1
    p3 = 0.5*b0 - 1j*sqrt(3.)/2.*b1
    p4 = 0.5*b0 + 0.5*b1 + 1/sqrt(2.)*b2
    p5 = 0.5*b0 + 0.5*b1 + exp(2j*pi/3.)/sqrt(2.)*b2
    p6 = 0.5*b0 + 0.5*b1 + exp(-2j*pi/3.)/sqrt(2.)*b2
    p7 = 0.5*b0 - 0.5*b1 + 1/sqrt(2.)*b2
    p8 = 0.5*b0 - 0.5*b1 + exp(2j*pi/3.)/sqrt(2.)*b2
    p9 = 0.5*b0 - 0.5*b1 + exp(-2j*pi/3.)/sqrt(2.)*b2
    p = [p1,p2,p3,p4,p5,p6,p7,p8,p9]
    pp = []
    for i in p:
        pp.append(dotx(i,daggx(i)))
    return pp

def _sic_4():
    b0 = obasis(4,0)
    b1 = obasis(4,1)
    b2 = obasis(4,2)
    b3 = obasis(4,3)
    c5 = sqrt(5.)
    mcc5 = 1.0/c5
    ct110 = sqrt(-110.+50.*c5)
    ct290 = sqrt(-290.+130.*c5)
    c5t2c5 = sqrt(5.-2.*c5)

    p1 = b0
    p2 = mcc5*b0 + 2.0*mcc5*b1
    p3 = mcc5*b0 + 2.0/(5.+sqrt(5.))*b1 + sqrt(0.5+0.5*mcc5)*b2
    p4 = mcc5*b0 + 2.0/(5.+sqrt(5.))*b1 + \
         sqrt(2.5-5.5*mcc5)*b2 + sqrt(6.0/c5-2.)*b3

    t5c4c5 = -5.+4.*c5
    mt4c5 = 10.-4.*c5
    ct10 = sqrt(-10.+10.*c5)

    sq1 = sqrt(t5c4c5-2.*ct110)+1j*c5t2c5
    sq2 = sqrt(mt4c5-ct290)-1j*sqrt(2.*c5+ct10)
    p5 = mcc5*b0 + (1j/2.-0.5/c5)*b1 + 0.5/c5*sq1*b2 + 0.5/c5*sq2*b3

    sq3 = -sqrt(t5c4c5+2.*ct110)+1j*c5t2c5
    sq4 = sqrt(mt4c5+ct290)+1j*sqrt(2.*c5-ct10)
    p6 = mcc5*b0 + (1j/2.-0.5/c5)*b1 + 0.5/c5*sq3*b2 + 0.5/c5*sq4*b3
    p7 = conjx(p6)
    p8 = conjx(p5)

    mc2c10 = 1./(2.*sqrt(10.))
    btc5 = 3.-c5
    c5tc5 = sqrt(5.-c5)
    nc3c5 = 5.+3.*c5
    nb1 = btc5 + 1j*ct10
    nb2 = -c5tc5 -1j*sqrt(nc3c5+4.*ct110)
    nb3 = sqrt(2.*c5-ct10)-1j*sqrt(mt4c5+ct290)
    p9 = mcc5*b0 + 1./(4.*c5)*nb1*b1 + mc2c10*nb2*b2 + 0.5/c5*nb3*b3
    nb2 = -c5tc5 +1j*sqrt(nc3c5-4.*ct110)
    nb3 = -sqrt(2.*c5+ct10)+1j*sqrt(mt4c5-ct290)
    p10 = mcc5*b0 + 1./(4.*c5)*nb1*b1 + mc2c10*nb2*b2 + 0.5/c5*nb3*b3

    p11 = conjx(p9)
    p12 = conjx(p10)

    t5c3c5 = -5.+3.*c5
    ncc5 = 5.+c5
    ct58 = sqrt(-58.+26.*c5)

    nb1 = -2.-ct10+1j*(c5tc5)**2
    nb2 = sqrt(t5c3c5+2.*ct290)+1j*sqrt(ncc5-4.*ct290)
    nb3 = -sqrt(mt4c5-ct290)+1j*sqrt(2.*c5-5.*ct58)
    p13 = mcc5*b0 + 1./(4.*c5)*nb1*b1 + mc2c10*nb2*b2 + 0.5/c5*nb3*b3

    nb1 = -2.+ct10+1j*c5tc5**2
    nb2 = sqrt(t5c3c5-2.*ct290)-1j*sqrt(ncc5+4.*ct290)###
    nb3 = -sqrt(mt4c5+ct290)+1j*sqrt(2.*c5+5.*ct58)
    p14 = mcc5*b0 + 1./(4.*c5)*nb1*b1 + mc2c10*nb2*b2 + 0.5/c5*nb3*b3

    p15 = conjx(p14)
    p16 = conjx(p13)

    p = [p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,\
         p12,p13,p14,p15,p16]
    pp = []
    for i in p:
        pp.append(dotx(i,daggx(i)))
    return pp

def _sic_d(d):
    """
    construct sic povm for d ≥ 5
    a set of povm elements can be calculated by
    acting the Displacement operateros on
    the fiducial vectors
    """
    pov = []
    for i in _Dd_(d):
       dat = dotx(i,_f_vectors_(d))
       pov.append(dotx(dat,daggx(dat)))
    return pov

def _Dd_(d):
    # a set of d^2 displacement opertators
    # PRX 5, 041006 (2015)
 
    data = []
    for j in range (d):
        for k in range (d):
            data.append(_Djkd_(j,k,d))
    return data 

def _Djkd_(j,k,d):
    # a displacement opertator Djk
    # PRX 5, 041006 (2015)
  
    w = np.exp(2*np.pi*1j/float(d))
    data = 0.0
    for m in range (d):
        data += w**(j*k/2.)*w**(j*m)*\
               dotx(obasis(d,(k+m) % d),daggx(obasis(d,m)))
    return data

def _f_vectors_(d):
    # we provide fiducial vector for d ≥ 5
    #
    if d == 5:
       f = qx([[ 0.39104489-0.j],
               [-0.28486558-0.64712933j],
               [-0.23188385-0.19820391j],
               [ 0.13193858-0.109396j  ],
               [ 0.43096744+0.19747406j]])
       return f
    elif d == 6:
       f = qx([[ 0.52444689+0.j        ],
               [ 0.02592905-0.61818565j],
               [-0.12806168-0.10727625j],
               [-0.36018286-0.33500264j],
               [ 0.08976711-0.00266531j],
               [ 0.1805875 -0.17772481j]])
       return f
    elif d == 7:
       f = qx([[ 0.34160749+0.j        ],
               [ 0.55148564-0.34867715j],
               [-0.1164858 -0.2616662j ],
               [-0.07531291-0.27525818j],
               [-0.07325738-0.10603759j],
               [-0.34887243+0.23627221j],
               [-0.27916462-0.14844156j]])
       return f
    if d == 8:
       f = qx([[ 0.36108524+0.j        ],
               [ 0.42272801-0.02169919j],
               [-0.21494921-0.26444028j],
               [-0.03273858-0.16728341j],
               [ 0.05815999-0.18856908j],
               [-0.13008704+0.01463644j],
               [-0.61534059-0.05066921j],
               [-0.11319057-0.3084785j ]])
       return f
    if d == 9:
       f = qx([[ 0.36097684+0.j        ],
               [ 0.13296368-0.55757758j],
               [-0.20715266-0.15593255j],
               [-0.13778046-0.09715989j],
               [-0.36138405+0.28954166j],
               [-0.12846138-0.12623821j],
               [-0.22319638+0.09715989j],
               [-0.02223126-0.01816073j],
               [ 0.04480041-0.36947792j]])
       return f
    if d == 10:
       f = qx([[ 0.22518227+0.j        ],
               [ 0.21281603-0.40237285j],
               [-0.21720279-0.18622981j],
               [-0.51186788-0.20193084j],
               [ 0.22442551+0.08934273j],
               [-0.0574411 +0.04360239j],
               [-0.37511846+0.00387373j],
               [ 0.23853606+0.24876881j],
               [-0.1245201 -0.04577802j],
               [-0.11833239-0.052799j  ]])
       return f
    if d == 11:
       f = qx([[ 0.45659209+0.j        ],
               [-0.01641208-0.22048381j],
               [ 0.08663986-0.05126716j],
               [ 0.32199913+0.03206752j],
               [ 0.17206638-0.44329419j],
               [ 0.13150829+0.24465588j],
               [-0.17785865-0.4323073j ],
               [ 0.13439353+0.17169549j],
               [ 0.2227257 -0.04041439j],
               [-0.0120387 -0.0674465j ],
               [-0.00815462+0.04962214j]])
       return f  
    if d == 12:
       f = qx([[ 0.26457457+0.j        ],
               [ 0.34478956-0.1746444j ],
               [-0.30162301-0.09770499j],
               [-0.53350146+0.00604523j],
               [-0.06054748+0.04079248j],
               [ 0.02707597-0.05715081j],
               [-0.15137441-0.12513084j],
               [-0.29608686+0.14338892j],
               [-0.12020206+0.02795442j],
               [ 0.03375694+0.24372824j],
               [-0.2706292 -0.24172387j],
               [ 0.17848367-0.00276544j]])
       return f
    if d == 13:
       f = qx([[ 0.21323419+0.j        ],
               [ 0.1017272 +0.30926245j],
               [-0.0632404 +0.08006456j],
               [-0.28106925-0.28664891j],
               [ 0.00654072-0.0574242j ],
               [ 0.11927843-0.08658394j],
               [ 0.09241652-0.24821028j],
               [-0.12009654-0.13351599j],
               [-0.25772076+0.05638477j],
               [ 0.0914815 +0.15408726j],
               [-0.17429715+0.47728028j],
               [-0.30403029-0.24387599j],
               [-0.19305095-0.02081999j]])
       return f
    if d == 14:
       f = qx([[ 0.41693455+0.j        ],
               [-0.09297526-0.36395543j],
               [-0.09828093+0.08439442j],
               [ 0.20912093-0.22114642j],
               [-0.21964847-0.21590125j],
               [-0.13545968-0.0881434j ],
               [-0.26740872-0.39482901j],
               [ 0.13756746-0.01636839j],
               [-0.08239322-0.16195447j],
               [ 0.09593128-0.00985803j],
               [ 0.16252039-0.20990422j],
               [-0.02890668+0.05055778j],
               [ 0.03363733+0.10772773j],
               [ 0.27312552-0.06748894j]])
       return f
    if d == 15:
       f = qx([[ 0.31981525+0.j        ],
               [ 0.00506886+0.26048766j],
               [ 0.03933726-0.03732005j],
               [-0.18553716+0.11096496j],
               [ 0.13138171+0.08159248j],
               [-0.07311315+0.05791765j],
               [-0.36317723-0.05959373j],
               [ 0.03933726-0.03732005j],
               [-0.34111032-0.17379746j],
               [ 0.07159749+0.09826725j],
               [-0.07311315+0.05791765j],
               [ 0.00506886+0.26048766j],
               [-0.43852001+0.09192051j],
               [-0.34111032-0.17379746j],
               [ 0.13138171+0.08159248j]])
       return f
    if d == 16:
       f = qx([[ 0.29971015+0.j        ],
               [-0.06262709+0.16305674j],
               [-0.46410724+0.0052863j ],
               [-0.11052247+0.14191425j],
               [ 0.14990819+0.10533763j],
               [ 0.10907745+0.14218391j],
               [ 0.00090983-0.07618303j],
               [ 0.10304568+0.03794629j],
               [-0.09985294-0.04454288j],
               [-0.32491832-0.05394183j],
               [-0.2261969 +0.13573196j],
               [-0.09834834-0.03497415j],
               [-0.04237216+0.37716037j],
               [-0.36373283+0.05598333j],
               [ 0.16235342-0.15715641j],
               [ 0.11996523+0.04990584j]])
       return f
    if d == 19:
       f = qx([[ 0.12753059+0.j        ],
               [ 0.1461065 +0.29509646j],
               [-0.25620229+0.00925266j],
               [ 0.11070218-0.21898501j],
               [-0.24503884-0.02682396j],
               [ 0.01661198+0.12225102j],
               [-0.14551585-0.02363505j],
               [ 0.00347683-0.10992839j],
               [-0.13249755-0.05019818j],
               [ 0.05799991-0.19467784j],
               [ 0.10203377-0.0286654j ],
               [-0.09715351+0.32498715j],
               [-0.07045118+0.19645468j],
               [-0.20939643+0.0473444j ],
               [ 0.24886203+0.08080376j],
               [ 0.28409085+0.37553498j],
               [ 0.09431   +0.01014281j],
               [ 0.10543768-0.1194657j ],
               [-0.14090667-0.13359541j]])
       return f
    if d == 24:
       f = qx([[ 0.27486864+0.j        ],
               [ 0.11539619-0.06668902j],
               [ 0.2284636 +0.18743993j],
               [ 0.00750665+0.17539516j],
               [ 0.0193765 +0.11304814j],
               [-0.07233043-0.09505336j],
               [ 0.2055606 +0.01666964j],
               [-0.11539619+0.06668902j],
               [-0.10581408+0.00976127j],
               [-0.02279416+0.11502209j],
               [ 0.09355627-0.04914263j],
               [ 0.07233043+0.09505336j],
               [ 0.27486864+0.j        ],
               [ 0.29306453+0.16113213j],
               [ 0.09278641-0.22827736j],
               [ 0.02279416-0.11502209j],
               [ 0.0193765 +0.11304814j],
               [ 0.0986049 -0.04273977j],
               [-0.09148747+0.1839405j ],
               [-0.29306453-0.16113213j],
               [-0.10581408+0.00976127j],
               [-0.00750665-0.17539516j],
               [ 0.39495084-0.00772943j],
               [-0.0986049 +0.04273977j]])
       return f
    if d == 28:
       f = qx([[ 0.25862049+0.j        ],
               [ 0.04471413-0.20924787j],
               [ 0.1785576 +0.07270012j],
               [-0.11009451-0.09735247j],
               [ 0.04157063-0.05666046j],
               [ 0.09237814+0.07049245j],
               [ 0.03455124-0.02588692j],
               [ 0.09246089-0.19962218j],
               [ 0.05522907+0.16439223j],
               [ 0.03983696-0.076171j  ],
               [ 0.23927534+0.02656892j],
               [-0.18022763-0.07835996j],
               [ 0.14074768-0.11376296j],
               [-0.1758889 -0.06380998j],
               [ 0.04861432-0.18582831j],
               [ 0.12934496-0.1565238j ],
               [-0.21777653-0.00550343j],
               [ 0.43085777-0.04137817j],
               [-0.10033378-0.07184314j],
               [-0.11152729-0.11989017j],
               [ 0.05447434+0.06185585j],
               [-0.04726972+0.17406591j],
               [-0.15010713+0.10965112j],
               [-0.16203728+0.0051858j ],
               [-0.02237872-0.03912978j],
               [ 0.22327988-0.13032343j],
               [ 0.17949397+0.01821411j],
               [-0.03869664+0.00049825j]])
       return f
    if d == 35:
       f = qx([[ 0.2727033 +0.j        ],
               [ 0.20553006+0.15306429j],
               [-0.03785382+0.24730961j],
               [-0.09163329-0.00403598j],
               [-0.03632456+0.13832868j],
               [-0.0380194 -0.05043363j],
               [-0.10001783+0.04710068j],
               [ 0.10860154-0.01366305j],
               [ 0.00292291+0.17222369j],
               [-0.17890765-0.03228937j],
               [-0.04945114+0.05860942j],
               [-0.03632456+0.13832868j],
               [ 0.01236282-0.18845941j],
               [-0.02865044+0.02365775j],
               [-0.06469901-0.00676218j],
               [-0.0639365 +0.08367489j],
               [-0.17890765-0.03228937j],
               [-0.09163329-0.00403598j],
               [-0.1250479 +0.03634482j],
               [ 0.00038526+0.10909739j],
               [ 0.23999709+0.28006233j],
               [-0.06469901-0.00676218j],
               [ 0.00292291+0.17222369j],
               [-0.03785382+0.24730961j],
               [ 0.13084772-0.04486979j],
               [ 0.16657807+0.1548166j ],
               [ 0.00038526+0.10909739j],
               [-0.02865044+0.02365775j],
               [ 0.10860154-0.01366305j],
               [ 0.20553006+0.15306429j],
               [-0.12290308-0.18748937j],
               [ 0.13084772-0.04486979j],
               [-0.1250479 +0.03634482j],
               [ 0.01236282-0.18845941j],
               [-0.10001783+0.04710068j]])
       return f
    if d == 48:
       f = qx([[ 0.19729621+0.j        ],
               [-0.14423159-0.03645428j],
               [-0.01665338+0.25835629j],
               [-0.02182776-0.1489741j ],
               [-0.03641437-0.08445922j],
               [-0.0837684 +0.03172566j],
               [ 0.00152717-0.04014537j],
               [ 0.10443764-0.11259439j],
               [ 0.09108665+0.0480566j ],
               [-0.04479509+0.22437074j],
               [ 0.01665338-0.25835629j],
               [ 0.09459641-0.1172187j ],
               [ 0.11223481+0.06936492j],
               [-0.08623681-0.06938236j],
               [-0.08039248+0.07049422j],
               [-0.00798067-0.01302957j],
               [-0.09108665-0.0480566j ],
               [-0.14423159-0.03645428j],
               [ 0.08848332+0.07517548j],
               [-0.06543741-0.10528169j],
               [ 0.03351956+0.18100256j],
               [ 0.16850554-0.08393747j],
               [ 0.08039248-0.07049422j],
               [ 0.10443764-0.11259439j],
               [-0.19729621+0.j        ],
               [ 0.15704159-0.10814105j],
               [ 0.04034326-0.05368909j],
               [ 0.08499181-0.04635667j],
               [-0.03351956-0.18100256j],
               [-0.08623681-0.06938236j],
               [-0.00152717+0.04014537j],
               [ 0.02829659-0.04067138j],
               [ 0.01887122-0.07702418j],
               [-0.04010056+0.08141687j],
               [-0.04034326+0.05368909j],
               [-0.06543741-0.10528169j],
               [-0.11223481-0.06936492j],
               [-0.0837684 +0.03172566j],
               [ 0.01667865+0.01926795j],
               [-0.23415253-0.03181582j],
               [-0.01887122+0.07702418j],
               [ 0.15704159-0.10814105j],
               [-0.08848332-0.07517548j],
               [ 0.09459641-0.1172187j ],
               [ 0.03641437+0.08445922j],
               [-0.25669048-0.18890125j],
               [-0.01667865-0.01926795j],
               [ 0.02829659-0.04067138j]])
       return f
    else:
       return 'not construct or exis yet'
