import * as acm from '@aws-cdk/aws-certificatemanager';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BaseFargateServiceProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly tasks: FargateTaskProps[];
    /**
     * @stability stable
     */
    readonly route53Ops?: Route53Options;
    /**
     * create a FARGATE_SPOT only cluster.
     *
     * @default false
     * @stability stable
     */
    readonly spot?: boolean;
    /**
     * Enable the fargate spot termination handler.
     *
     * @default true
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-capacity-providers.html#fargate-capacity-providers-termination
     * @stability stable
     */
    readonly spotTerminationHandler?: boolean;
    /**
     * Whether to enable ECS Exec support.
     *
     * @default false
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html
     * @stability stable
     */
    readonly enableExecuteCommand?: boolean;
    /**
     * The subnets to associate with the service.
     *
     * @default -
     * {
     * subnetType: ec2.SubnetType.PRIVATE,
     * }
     * @stability stable
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * Enable the ECS service circuit breaker.
     *
     * @default true
     * @see - https://aws.amazon.com/tw/blogs/containers/announcing-amazon-ecs-deployment-circuit-breaker/
     * @stability stable
     */
    readonly circuitBreaker?: boolean;
}
/**
 * The load balancer accessibility.
 *
 * @stability stable
 */
export interface LoadBalancerAccessibility {
    /**
     * The port of the listener.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * The ACM certificate for the HTTPS listener.
     *
     * @default - no certificate(HTTP only)
     * @stability stable
     */
    readonly certificate?: acm.ICertificate[];
}
/**
 * Task properties for the Fargate.
 *
 * @stability stable
 */
export interface FargateTaskProps {
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * The internal ELB listener.
     *
     * @default - no internal listener
     * @stability stable
     */
    readonly internal?: LoadBalancerAccessibility;
    /**
     * The external ELB listener.
     *
     * @default - no external listener
     * @stability stable
     */
    readonly external?: LoadBalancerAccessibility;
    /**
     * desired number of tasks for the service.
     *
     * @default 1
     * @stability stable
     */
    readonly desiredCount?: number;
    /**
     * service autoscaling policy.
     *
     * @default - { maxCapacity: 10, targetCpuUtilization: 50, requestsPerTarget: 1000 }
     * @stability stable
     */
    readonly scalingPolicy?: ServiceScalingPolicy;
    /**
     * Customized capacity provider strategy.
     *
     * @stability stable
     */
    readonly capacityProviderStrategy?: ecs.CapacityProviderStrategy[];
    /**
     * health check from elbv2 target group.
     *
     * @stability stable
     */
    readonly healthCheck?: elbv2.HealthCheck;
    /**
     * The target group protocol for NLB.
     *
     * For ALB, this option will be ignored and always set to HTTP.
     *
     * @default - TCP
     * @stability stable
     */
    readonly protocol?: elbv2.Protocol;
    /**
     * The protocol version to use.
     *
     * @stability stable
     */
    readonly protocolVersion?: elbv2.ApplicationProtocolVersion;
}
/**
 * @stability stable
 */
export interface ServiceScalingPolicy {
    /**
     * max capacity for the service autoscaling.
     *
     * @default 10
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * target cpu utilization.
     *
     * @default 50
     * @stability stable
     */
    readonly targetCpuUtilization?: number;
    /**
     * request per target.
     *
     * @default 1000
     * @stability stable
     */
    readonly requestPerTarget?: number;
}
/**
 * @stability stable
 */
export interface Route53Options {
    /**
     * Whether to configure the ALIAS for the LB.
     *
     * @default true
     * @stability stable
     */
    readonly enableLoadBalancerAlias?: boolean;
    /**
     * private zone name.
     *
     * @default svc.local
     * @stability stable
     */
    readonly zoneName?: string;
    /**
     * the external ELB record name.
     *
     * @default external
     * @stability stable
     */
    readonly externalElbRecordName?: string;
    /**
     * the internal ELB record name.
     *
     * @default internal
     * @stability stable
     */
    readonly internalElbRecordName?: string;
}
/**
 * @stability stable
 */
export declare abstract class BaseFargateService extends cdk.Construct {
    /**
     * The VPC.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The service(s) created from the task(s).
     *
     * @stability stable
     */
    readonly service: ecs.FargateService[];
    /**
     * @stability stable
     */
    protected zoneName: string;
    /**
     * @stability stable
     */
    protected hasExternalLoadBalancer: boolean;
    /**
     * @stability stable
     */
    protected hasInternalLoadBalancer: boolean;
    /**
     * @stability stable
     */
    protected vpcSubnets: ec2.SubnetSelection;
    /**
     * @stability stable
     */
    protected enableLoadBalancerAlias: boolean;
    private hasSpotCapacity;
    /**
     * determine if vpcSubnets are all public ones
     */
    private isPublicSubnets;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: BaseFargateServiceProps);
    private createSpotTerminationHandler;
    private validateSubnets;
}
