/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagListener;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayNodeElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayNodeListener;
import org.xml.sax.Attributes;

public class WayElementProcessor
extends EntityElementProcessor
implements TagListener,
WayNodeListener {
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NODE = "nd";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER = "user";
    private static final String ATTRIBUTE_NAME_USERID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private TagElementProcessor tagElementProcessor = new TagElementProcessor((BaseElementProcessor)this, this);
    private WayNodeElementProcessor wayNodeElementProcessor = new WayNodeElementProcessor((BaseElementProcessor)this, this);
    private Way way;

    public WayElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing) {
        super(parentProcessor, sink, enableDateParsing);
    }

    @Override
    public void begin(Attributes attributes) {
        long id = Long.parseLong(attributes.getValue(ATTRIBUTE_NAME_ID));
        String sversion = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (sversion == null) {
            throw new OsmosisRuntimeException("Way " + id + " does not have a version attribute as OSM 0.6 are required to have.  Is this a 0.5 file?");
        }
        int version = Integer.parseInt(sversion);
        TimestampContainer timestampContainer = this.createTimestampContainer(attributes.getValue(ATTRIBUTE_NAME_TIMESTAMP));
        String rawUserId = attributes.getValue(ATTRIBUTE_NAME_USERID);
        String rawUserName = attributes.getValue(ATTRIBUTE_NAME_USER);
        long changesetId = this.buildChangesetId(attributes.getValue(ATTRIBUTE_NAME_CHANGESET_ID));
        OsmUser user = this.buildUser(rawUserId, rawUserName);
        this.way = new Way(new CommonEntityData(id, version, timestampContainer, user, changesetId));
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_NODE.equals(qName)) {
            return this.wayNodeElementProcessor;
        }
        if (ELEMENT_NAME_TAG.equals(qName)) {
            return this.tagElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
        this.getSink().process((EntityContainer)new WayContainer(this.way));
    }

    @Override
    public void processTag(Tag tag) {
        this.way.getTags().add(tag);
    }

    @Override
    public void processWayNode(WayNode wayNode) {
        this.way.getWayNodes().add(wayNode);
    }
}

