/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.osmosis;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.map.writer.HDTileBasedDataProcessor;
import org.mapsforge.map.writer.MapFileWriter;
import org.mapsforge.map.writer.RAMTileBasedDataProcessor;
import org.mapsforge.map.writer.model.MapWriterConfiguration;
import org.mapsforge.map.writer.model.TileBasedDataProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class MapFileWriterTask
implements Sink {
    private static final Logger LOGGER = Logger.getLogger(MapFileWriterTask.class.getName());
    private final MapWriterConfiguration configuration;
    private TileBasedDataProcessor tileBasedGeoObjectStore;

    MapFileWriterTask(MapWriterConfiguration configuration) {
        this.configuration = configuration;
        Properties properties = new Properties();
        try {
            properties.load(MapFileWriterTask.class.getClassLoader().getResourceAsStream("mapsforge-map.properties"));
            configuration.setWriterVersion("mapsforge-map-writer-" + properties.getProperty("mapfile.writer.version"));
            int version = Integer.parseInt(properties.getProperty("mapfile.specification.version.min"));
            if (configuration.isTagValues()) {
                int n = version = version > 5 ? version : 5;
            }
            if (configuration.getPreferredLanguages() != null && configuration.getPreferredLanguages().size() > 1) {
                int n = version = version > 4 ? version : 4;
            }
            if (version > Integer.parseInt(properties.getProperty("mapfile.specification.version.max"))) {
                throw new RuntimeException("unsupported map file specification version: " + version);
            }
            configuration.setFileSpecificationVersion(version);
            LOGGER.info("mapfile-writer version: " + configuration.getWriterVersion());
            LOGGER.info("mapfile format specification version: " + configuration.getFileSpecificationVersion());
        }
        catch (IOException e) {
            throw new RuntimeException("could not find default properties", e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("map file specification version is not an integer", e);
        }
        if (this.configuration.getBboxConfiguration() != null) {
            this.tileBasedGeoObjectStore = "ram".equalsIgnoreCase(configuration.getDataProcessorType()) ? RAMTileBasedDataProcessor.newInstance(configuration) : HDTileBasedDataProcessor.newInstance(configuration);
        }
    }

    public final void close() {
        if (this.tileBasedGeoObjectStore != null) {
            this.tileBasedGeoObjectStore.close();
        }
    }

    public final void complete() {
        NumberFormat nfMegabyte = NumberFormat.getInstance();
        NumberFormat nfCounts = NumberFormat.getInstance();
        nfCounts.setGroupingUsed(true);
        nfMegabyte.setMaximumFractionDigits(2);
        LOGGER.info("completing read...");
        this.tileBasedGeoObjectStore.complete();
        LOGGER.info("start writing file...");
        try {
            if (this.configuration.getOutputFile().exists()) {
                LOGGER.info("overwriting file " + this.configuration.getOutputFile().getAbsolutePath());
                this.configuration.getOutputFile().delete();
            }
            MapFileWriter.writeFile(this.configuration, this.tileBasedGeoObjectStore);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "error while writing file", e);
        }
        LOGGER.info("finished...");
        LOGGER.fine("total processed nodes: " + nfCounts.format(this.tileBasedGeoObjectStore.getNodesNumber()));
        LOGGER.fine("total processed ways: " + nfCounts.format(this.tileBasedGeoObjectStore.getWaysNumber()));
        LOGGER.fine("total processed relations: " + nfCounts.format(this.tileBasedGeoObjectStore.getRelationsNumber()));
        LOGGER.info("estimated memory consumption: " + nfMegabyte.format((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / Math.pow(1024.0, 2.0)) + "MB");
    }

    public void initialize(Map<String, Object> metadata) {
    }

    public final void process(EntityContainer entityContainer) {
        Entity entity = entityContainer.getEntity();
        switch (entity.getType()) {
            case Bound: {
                Bound bound = (Bound)entity;
                if (this.configuration.getBboxConfiguration() == null) {
                    BoundingBox bbox = new BoundingBox(bound.getBottom(), bound.getLeft(), bound.getTop(), bound.getRight());
                    this.configuration.setBboxConfiguration(bbox);
                    this.configuration.validate();
                    this.tileBasedGeoObjectStore = "ram".equals(this.configuration.getDataProcessorType()) ? RAMTileBasedDataProcessor.newInstance(this.configuration) : HDTileBasedDataProcessor.newInstance(this.configuration);
                }
                LOGGER.info("start reading data...");
                break;
            }
            case Node: {
                if (this.tileBasedGeoObjectStore == null) {
                    LOGGER.severe("No valid bounding box found in input data.\nPlease provide valid bounding box via command line parameter 'bbox=minLat,minLon,maxLat,maxLon'.\nTile based data store not initialized. Aborting...");
                    throw new IllegalStateException("tile based data store not initialized, missing bounding box information in input data");
                }
                this.tileBasedGeoObjectStore.addNode((Node)entity);
                entity = null;
                break;
            }
            case Way: {
                this.tileBasedGeoObjectStore.addWay((Way)entity);
                entity = null;
                break;
            }
            case Relation: {
                Relation currentRelation = (Relation)entity;
                this.tileBasedGeoObjectStore.addRelation(currentRelation);
                entity = null;
            }
        }
    }
}

