/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import org.openstreetmap.osmosis.core.store.GenericObjectReader;
import org.openstreetmap.osmosis.core.store.GenericObjectWriter;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class DbFeature<T extends Storeable>
implements Storeable {
    private long entityId;
    private T feature;

    public DbFeature(long entityId, T feature) {
        this.entityId = entityId;
        this.feature = feature;
    }

    public DbFeature(StoreReader sr, StoreClassRegister scr) {
        this(sr.readLong(), new GenericObjectReader(sr, scr).readObject());
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeLong(this.entityId);
        new GenericObjectWriter(sw, scr).writeObject((Storeable)this.feature);
    }

    public long getEntityId() {
        return this.entityId;
    }

    public T getFeature() {
        return this.feature;
    }
}

