/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientChannelPipelineFactory;

public class SequenceClient {
    private InetSocketAddress serverAddress;
    private SequenceClientChannelPipelineFactory channelPipelineFactory;
    private boolean masterRunning;
    private ChannelFactory factory;
    private Channel channel;

    public SequenceClient(InetSocketAddress serverAddress, SequenceClientChannelPipelineFactory channelPipelineFactory) {
        this.serverAddress = serverAddress;
        this.channelPipelineFactory = channelPipelineFactory;
    }

    public void start() {
        if (this.masterRunning) {
            throw new OsmosisRuntimeException("The server has already been started");
        }
        this.masterRunning = true;
        this.factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ClientBootstrap bootstrap = new ClientBootstrap(this.factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.channelPipelineFactory);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        ChannelFuture future = bootstrap.connect((SocketAddress)this.serverAddress);
        this.channel = future.getChannel();
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            throw new OsmosisRuntimeException("Unable to launch sequence client.");
        }
    }

    public void stop() {
        if (this.masterRunning) {
            this.channel.close().awaitUninterruptibly();
            this.factory.releaseExternalResources();
            this.masterRunning = false;
        }
    }
}

