"use strict";
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserGroup = exports.UserGroupBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const aws_elasticache_1 = require("aws-cdk-lib/aws-elasticache");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const ELASTICACHE_USERGROUP_SYMBOL = Symbol.for('@aws-cdk/aws-elasticache.UserGroup');
/**
 * Base class for UserGroup constructs
 */
class UserGroupBase extends core_1.Resource {
    static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.UserGroupBase", version: "2.223.0-alpha.0" };
    /**
     * Add a user to this user group
     *
     * @param _user The user to add
     */
    addUser(_user) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_IUser(_user);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addUser);
            }
            throw error;
        }
        throw new core_1.UnscopedValidationError('Cannot add users to an imported UserGroup. Only UserGroups created in this stack can be modified.');
    }
}
exports.UserGroupBase = UserGroupBase;
/**
 * An ElastiCache UserGroup
 *
 * @resource AWS::ElastiCache::UserGroup
 */
let UserGroup = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = UserGroupBase;
    let _instanceExtraInitializers = [];
    let _addUser_decorators;
    var UserGroup = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            _addUser_decorators = [(0, metadata_resource_1.MethodMetadata)()];
            __esDecorate(this, null, _addUser_decorators, { kind: "method", name: "addUser", static: false, private: false, access: { has: obj => "addUser" in obj, get: obj => obj.addUser }, metadata: _metadata }, null, _instanceExtraInitializers);
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            UserGroup = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.UserGroup", version: "2.223.0-alpha.0" };
        /**
         * Uniquely identifies this class
         */
        static PROPERTY_INJECTION_ID = 'aws-cdk-lib.aws-elasticache.UserGroup';
        /**
         * Return whether the given object is a `UserGroup`
         */
        static isUserGroup(x) {
            return x !== null && typeof (x) === 'object' && ELASTICACHE_USERGROUP_SYMBOL in x;
        }
        /**
         * Import an existing user group by name
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param userGroupName The name of the existing user group
         */
        static fromUserGroupName(scope, id, userGroupName) {
            return UserGroup.fromUserGroupAttributes(scope, id, { userGroupName });
        }
        /**
         * Import an existing user group by ARN
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param userGroupArn The ARN of the existing user group
         */
        static fromUserGroupArn(scope, id, userGroupArn) {
            return UserGroup.fromUserGroupAttributes(scope, id, { userGroupArn });
        }
        /**
         * Import an existing user group using attributes
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param attrs A `UserGroupAttributes` object
         */
        static fromUserGroupAttributes(scope, id, attrs) {
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_UserGroupAttributes(attrs);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, this.fromUserGroupAttributes);
                }
                throw error;
            }
            let userGroupName;
            let userGroupArn;
            const stack = core_1.Stack.of(scope);
            if (attrs.userGroupArn && attrs.userGroupName) {
                throw new core_1.ValidationError('Only one of userGroupArn or userGroupName can be provided.', scope);
            }
            if (attrs.userGroupArn) {
                userGroupArn = attrs.userGroupArn;
                const extractedUserGroupName = stack.splitArn(attrs.userGroupArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
                if (!extractedUserGroupName) {
                    throw new core_1.ValidationError('Unable to extract user group name from ARN.', scope);
                }
                userGroupName = extractedUserGroupName;
            }
            else if (attrs.userGroupName) {
                userGroupName = attrs.userGroupName;
                userGroupArn = stack.formatArn({
                    service: 'elasticache',
                    resource: 'usergroup',
                    resourceName: attrs.userGroupName,
                });
            }
            else {
                throw new core_1.ValidationError('One of userGroupName or userGroupArn is required.', scope);
            }
            class Import extends UserGroupBase {
                engine;
                userGroupName;
                userGroupArn;
                get users() {
                    return attrs.users ? [...attrs.users] : undefined;
                }
                constructor(_userGroupArn, _userGroupName) {
                    super(scope, id);
                    this.userGroupArn = _userGroupArn;
                    this.userGroupName = _userGroupName;
                    this.engine = attrs.engine;
                }
            }
            return new Import(userGroupArn, userGroupName);
        }
        engine = __runInitializers(this, _instanceExtraInitializers);
        userGroupName;
        _users = [];
        /**
         * The ARN of the user group
         *
         * @attribute
         */
        userGroupArn;
        /**
         * The status of the user group
         * Can be 'creating', 'active', 'modifying', 'deleting'
         *
         * @attribute
         */
        userGroupStatus;
        resource;
        constructor(scope, id, props = {}) {
            super(scope, id, {});
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_UserGroupProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, UserGroup);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            this.engine = props.engine ?? common_1.UserEngine.VALKEY;
            this.userGroupName = props.userGroupName ?? core_1.Lazy.string({
                // Elasticache not allowing uppercase user group id
                produce: () => core_1.Names.uniqueId(this).toLocaleLowerCase(),
            });
            if (props.users) {
                this._users.push(...props.users);
            }
            this.resource = new aws_elasticache_1.CfnUserGroup(this, 'Resource', {
                engine: this.engine,
                userGroupId: this.userGroupName,
                userIds: core_1.Lazy.list({
                    produce: () => {
                        this.validateUsers();
                        return this._users.map(user => user.userId);
                    },
                }),
            });
            if (props.users) {
                props.users.forEach(user => this.addUserDependency(user));
            }
            this.userGroupArn = this.resource.attrArn;
            this.userGroupStatus = this.resource.attrStatus;
            Object.defineProperty(this, ELASTICACHE_USERGROUP_SYMBOL, { value: true });
        }
        /**
         * Add a CloudFormation dependency on the user resource to ensure proper creation order.
         */
        addUserDependency(user) {
            this.resource.node.addDependency(user);
        }
        /**
         * Array of users in the user group
         *
         * Do not push directly to this array.
         * Use addUser() instead to ensure proper validation and dependency management.
         */
        get users() {
            return this._users;
        }
        /**
         * Validates users in the user group for duplicate usernames and Redis-specific requirements.
         */
        validateUsers() {
            const userNames = this._users.map(user => user.userName);
            const duplicates = userNames.filter((name, index) => userNames.indexOf(name) !== index);
            if (duplicates.length > 0) {
                throw new core_1.ValidationError('User group cannot have users with the same user name.', this);
            }
            if (this.engine === common_1.UserEngine.REDIS) {
                this._users.forEach(user => {
                    if (user.engine !== common_1.UserEngine.REDIS) {
                        throw new core_1.ValidationError('Redis user group can only contain Redis users.', this);
                    }
                });
                const hasDefaultUser = this._users.some(user => user.userName === 'default');
                if (!hasDefaultUser) {
                    throw new core_1.ValidationError('Redis user groups need to contain a user with the user name "default".', this);
                }
            }
        }
        /**
         * Add a user to this user group
         *
         * @param user The user to add to the group
         */
        addUser(user) {
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_IUser(user);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, this.addUser);
                }
                throw error;
            }
            this._users.push(user);
            this.addUserDependency(user);
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return UserGroup = _classThis;
})();
exports.UserGroup = UserGroup;
//# sourceMappingURL=data:application/json;base64,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