"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessCache = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const aws_elasticache_1 = require("aws-cdk-lib/aws-elasticache");
const serverless_cache_base_1 = require("./serverless-cache-base");
const ec2 = require("aws-cdk-lib/aws-ec2");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const ELASTICACHE_SERVERLESSCACHE_SYMBOL = Symbol.for('@aws-cdk/aws-elasticache.ServerlessCache');
/**
 * Unit types for data storage usage limits
 */
var DataStorageUnit;
(function (DataStorageUnit) {
    /**
     * Gigabytes
     */
    DataStorageUnit["GIGABYTES"] = "GB";
})(DataStorageUnit || (DataStorageUnit = {}));
/**
 * Minimum data storage size in GB for ServerlessCache
 */
const DATA_STORAGE_MIN_GB = 1;
/**
 * Maximum data storage size in GB for ServerlessCache
 */
const DATA_STORAGE_MAX_GB = 5000;
/**
 * Minimum request rate limit in ECPUs per second for ServerlessCache
 */
const REQUEST_RATE_MIN_ECPU = 1000;
/**
 * Maximum request rate limit in ECPUs per second for ServerlessCache
 */
const REQUEST_RATE_MAX_ECPU = 15000000;
/**
 * A serverless ElastiCache cache
 *
 * @resource AWS::ElastiCache::ServerlessCache
 */
let ServerlessCache = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = serverless_cache_base_1.ServerlessCacheBase;
    var ServerlessCache = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ServerlessCache = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.ServerlessCache", version: "2.223.0-alpha.0" };
        /**
         * Uniquely identifies this class.
         */
        static PROPERTY_INJECTION_ID = 'aws-cdk-lib.aws-elasticache.ServerlessCache';
        /**
         * Return whether the given object is a `ServerlessCache`
         */
        static isServerlessCache(x) {
            return x !== null && typeof (x) === 'object' && ELASTICACHE_SERVERLESSCACHE_SYMBOL in x;
        }
        /**
         * Import an existing serverless cache by name
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param serverlessCacheName The name of the existing serverless cache
         */
        static fromServerlessCacheName(scope, id, serverlessCacheName) {
            return ServerlessCache.fromServerlessCacheAttributes(scope, id, { serverlessCacheName });
        }
        /**
         * Import an existing serverless cache by ARN
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param serverlessCacheArn The ARN of the existing serverless cache
         */
        static fromServerlessCacheArn(scope, id, serverlessCacheArn) {
            return ServerlessCache.fromServerlessCacheAttributes(scope, id, { serverlessCacheArn });
        }
        /**
         * Import an existing serverless cache using attributes
         *
         * @param scope The parent creating construct (usually `this`)
         * @param id The construct's name
         * @param attrs A `ServerlessCacheAttributes` object
         */
        static fromServerlessCacheAttributes(scope, id, attrs) {
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_ServerlessCacheAttributes(attrs);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, this.fromServerlessCacheAttributes);
                }
                throw error;
            }
            let name;
            let arn;
            const stack = core_1.Stack.of(scope);
            if (attrs.serverlessCacheArn && attrs.serverlessCacheName) {
                throw new core_1.ValidationError('Only one of serverlessCacheArn or serverlessCacheName can be provided.', scope);
            }
            if (attrs.serverlessCacheArn) {
                arn = attrs.serverlessCacheArn;
                const extractedServerlessCacheName = stack.splitArn(attrs.serverlessCacheArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
                if (!extractedServerlessCacheName) {
                    throw new core_1.ValidationError('Unable to extract serverless cache name from ARN.', scope);
                }
                name = extractedServerlessCacheName;
            }
            else if (attrs.serverlessCacheName) {
                name = attrs.serverlessCacheName;
                arn = stack.formatArn({
                    service: 'elasticache',
                    resource: 'serverlesscache',
                    resourceName: attrs.serverlessCacheName,
                });
            }
            else {
                throw new core_1.ValidationError('One of serverlessCacheName or serverlessCacheArn is required.', scope);
            }
            class Import extends serverless_cache_base_1.ServerlessCacheBase {
                engine = attrs.engine;
                serverlessCacheName;
                serverlessCacheArn;
                backupArnsToRestore = attrs.backupArnsToRestore;
                kmsKey = attrs.kmsKey;
                vpc = attrs.vpc;
                subnets = attrs.subnets;
                securityGroups = attrs.securityGroups;
                userGroup = attrs.userGroup;
                connections;
                constructor(serverlessCacheArn, serverlessCacheName) {
                    super(scope, id);
                    this.serverlessCacheArn = serverlessCacheArn;
                    this.serverlessCacheName = serverlessCacheName;
                    if (this.engine) {
                        let defaultPort;
                        switch (this.engine) {
                            case serverless_cache_base_1.CacheEngine.VALKEY_LATEST:
                            case serverless_cache_base_1.CacheEngine.VALKEY_7:
                            case serverless_cache_base_1.CacheEngine.VALKEY_8:
                            case serverless_cache_base_1.CacheEngine.REDIS_LATEST:
                            case serverless_cache_base_1.CacheEngine.REDIS_7:
                                // Document showing the default port
                                // https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/set-up.html#elasticache-install-grant-access-VPN
                                defaultPort = ec2.Port.tcp(6379);
                                break;
                            case serverless_cache_base_1.CacheEngine.MEMCACHED_LATEST:
                                // Document showing the default port
                                // https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/set-up.html#elasticache-install-grant-access-VPN
                                defaultPort = ec2.Port.tcp(11211);
                                break;
                            default:
                                throw new core_1.ValidationError(`Unsupported cache engine: ${this.engine}`, scope);
                        }
                        this.connections = new ec2.Connections({
                            securityGroups: this.securityGroups,
                            defaultPort: defaultPort,
                        });
                    }
                    else {
                        this.connections = new ec2.Connections({
                            securityGroups: this.securityGroups,
                        });
                    }
                }
            }
            return new Import(arn, name);
        }
        engine;
        serverlessCacheName;
        backupArnsToRestore;
        kmsKey;
        vpc;
        subnets;
        securityGroups;
        userGroup;
        /**
         * The ARN of the serverless cache
         *
         * @attribute
         */
        serverlessCacheArn;
        /**
         * The endpoint address of the serverless cache
         *
         * @attribute
         */
        serverlessCacheEndpointAddress;
        /**
         * The endpoint port of the serverless cache
         *
         * @attribute
         */
        serverlessCacheEndpointPort;
        /**
         * The reader endpoint address of the serverless cache
         *
         * @attribute
         */
        serverlessCacheReaderEndpointAddress;
        /**
         * The reader endpoint port of the serverless cache
         *
         * @attribute
         */
        serverlessCacheReaderEndpointPort;
        /**
         * The current status of the serverless cache
         * Can be 'CREATING', 'AVAILABLE', 'DELETING', 'CREATE-FAILED', 'MODIFYING'
         *
         * @attribute
         */
        serverlessCacheStatus;
        /**
         * Access to network connections
         */
        connections;
        constructor(scope, id, props) {
            super(scope, id, {});
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_ServerlessCacheProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, ServerlessCache);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            this.engine = props.engine ?? serverless_cache_base_1.CacheEngine.VALKEY_LATEST;
            this.serverlessCacheName = props.serverlessCacheName ?? core_1.Lazy.string({ produce: () => core_1.Names.uniqueId(this) });
            this.kmsKey = props.kmsKey;
            this.vpc = props.vpc;
            this.userGroup = props.userGroup;
            this.validateDescription(props.description);
            this.validateDataStorageLimits(props.cacheUsageLimits);
            this.validateRequestRateLimits(props.cacheUsageLimits);
            this.validateBackupSettings(props.backup);
            this.validateUserGroupCompatibility(this.engine, this.userGroup);
            const subnetConfig = this.configureSubnets(props);
            const subnetIds = subnetConfig.subnetIds;
            this.subnets = subnetConfig.subnets;
            const securityGroupConfig = this.configureSecurityGroups(props);
            const securityGroupIds = securityGroupConfig.securityGroupIds;
            this.securityGroups = securityGroupConfig.securityGroups;
            const [engine, version] = this.engine.split('_');
            const resource = new aws_elasticache_1.CfnServerlessCache(this, 'Resource', {
                engine: engine,
                majorEngineVersion: version,
                serverlessCacheName: this.serverlessCacheName,
                description: props.description,
                cacheUsageLimits: this.renderCacheUsageLimits(props.cacheUsageLimits),
                dailySnapshotTime: props.backup?.backupTime ? this.formatBackupTime(props.backup.backupTime) : undefined,
                snapshotRetentionLimit: props.backup?.backupRetentionLimit,
                finalSnapshotName: props.backup?.backupNameBeforeDeletion,
                snapshotArnsToRestore: props.backup?.backupArnsToRestore,
                kmsKeyId: props.kmsKey?.keyId,
                subnetIds: subnetIds,
                securityGroupIds: securityGroupIds,
                userGroupId: props.userGroup?.userGroupName,
            });
            if (props.userGroup) {
                const userGroupResource = props.userGroup.node.findChild('Resource');
                resource.addDependency(userGroupResource);
            }
            this.backupArnsToRestore = resource.snapshotArnsToRestore;
            this.serverlessCacheArn = resource.attrArn;
            this.serverlessCacheEndpointAddress = resource.attrEndpointAddress;
            this.serverlessCacheEndpointPort = resource.attrEndpointPort;
            this.serverlessCacheReaderEndpointAddress = resource.attrReaderEndpointAddress;
            this.serverlessCacheReaderEndpointPort = resource.attrReaderEndpointPort;
            this.serverlessCacheStatus = resource.attrStatus;
            this.connections = new ec2.Connections({
                securityGroups: this.securityGroups,
                defaultPort: ec2.Port.tcp(core_1.Lazy.number({ produce: () => parseInt(this.serverlessCacheEndpointPort) })),
            });
            Object.defineProperty(this, ELASTICACHE_SERVERLESSCACHE_SYMBOL, { value: true });
        }
        /**
         * Validate description meets AWS requirements
         *
         * @param description The description to validate
         */
        validateDescription(description) {
            if (!description || core_1.Token.isUnresolved(description))
                return;
            if (description.length > 255) {
                throw new core_1.ValidationError(`Description must not exceed 255 characters, currently has ${description.length}`, this);
            }
            if (description.includes('<') || description.includes('>')) {
                throw new core_1.ValidationError('Description must not contain < or > characters', this);
            }
        }
        /**
         * Validate data storage size limits
         *
         * @param limits The usage limits containing data storage settings
         */
        validateDataStorageLimits(limits) {
            if (!limits)
                return;
            if (limits.dataStorageMinimumSize && !limits.dataStorageMinimumSize.isUnresolved() &&
                (limits.dataStorageMinimumSize.toGibibytes() < DATA_STORAGE_MIN_GB || limits.dataStorageMinimumSize.toGibibytes() > DATA_STORAGE_MAX_GB)) {
                throw new core_1.ValidationError('Data storage minimum must be between 1 and 5000 GB.', this);
            }
            if (limits.dataStorageMaximumSize && !limits.dataStorageMaximumSize.isUnresolved() &&
                (limits.dataStorageMaximumSize.toGibibytes() < DATA_STORAGE_MIN_GB || limits.dataStorageMaximumSize.toGibibytes() > DATA_STORAGE_MAX_GB)) {
                throw new core_1.ValidationError('Data storage maximum must be between 1 and 5000 GB.', this);
            }
            if (limits.dataStorageMinimumSize && limits.dataStorageMaximumSize &&
                !limits.dataStorageMinimumSize.isUnresolved() && !limits.dataStorageMaximumSize.isUnresolved() &&
                limits.dataStorageMinimumSize.toGibibytes() > limits.dataStorageMaximumSize.toGibibytes()) {
                throw new core_1.ValidationError('Data storage minimum cannot be greater than maximum', this);
            }
        }
        /**
         * Validate request rate limits
         *
         * @param limits The usage limits containing request rate settings
         */
        validateRequestRateLimits(limits) {
            if (!limits)
                return;
            if (limits.requestRateLimitMinimum !== undefined && !core_1.Token.isUnresolved(limits.requestRateLimitMinimum) &&
                (limits.requestRateLimitMinimum < REQUEST_RATE_MIN_ECPU || limits.requestRateLimitMinimum > REQUEST_RATE_MAX_ECPU)) {
                throw new core_1.ValidationError('Request rate minimum must be between 1,000 and 15,000,000 ECPUs per second', this);
            }
            if (limits.requestRateLimitMaximum !== undefined && !core_1.Token.isUnresolved(limits.requestRateLimitMaximum) &&
                (limits.requestRateLimitMaximum < REQUEST_RATE_MIN_ECPU || limits.requestRateLimitMaximum > REQUEST_RATE_MAX_ECPU)) {
                throw new core_1.ValidationError('Request rate maximum must be between 1,000 and 15,000,000 ECPUs per second', this);
            }
            if (!core_1.Token.isUnresolved(limits.requestRateLimitMinimum) && !core_1.Token.isUnresolved(limits.requestRateLimitMaximum) &&
                limits.requestRateLimitMinimum !== undefined && limits.requestRateLimitMaximum !== undefined &&
                limits.requestRateLimitMinimum > limits.requestRateLimitMaximum) {
                throw new core_1.ValidationError('Request rate minimum cannot be greater than maximum', this);
            }
        }
        /**
         * Validate backup settings meet AWS requirements
         *
         * @param backup The backup settings to validate
         */
        validateBackupSettings(backup) {
            if (!core_1.Token.isUnresolved(backup?.backupRetentionLimit) && backup?.backupRetentionLimit !== undefined) {
                const limit = backup.backupRetentionLimit;
                if (limit < 1 || limit > 35) {
                    throw new core_1.ValidationError('Backup retention limit must be between 1 and 35 days', this);
                }
            }
            if (!core_1.Token.isUnresolved(backup?.backupNameBeforeDeletion) && backup?.backupNameBeforeDeletion !== undefined) {
                const name = backup.backupNameBeforeDeletion;
                if (!/^[a-zA-Z]/.test(name)) {
                    throw new core_1.ValidationError('Final backup name must begin with a letter', this);
                }
                if (!/^[a-zA-Z0-9-]+$/.test(name)) {
                    throw new core_1.ValidationError('Final backup name must contain only ASCII letters, digits, and hyphens', this);
                }
                if (name.endsWith('-')) {
                    throw new core_1.ValidationError('Final backup name must not end with a hyphen', this);
                }
                if (name.includes('--')) {
                    throw new core_1.ValidationError('Final backup name must not contain two consecutive hyphens', this);
                }
            }
        }
        /**
         * Validate user group compatibility with cache engine
         *
         * @param engine The cache engine
         * @param userGroup The user group to validate
         */
        validateUserGroupCompatibility(engine, userGroup) {
            if (!userGroup)
                return;
            if (engine === serverless_cache_base_1.CacheEngine.MEMCACHED_LATEST) {
                throw new core_1.ValidationError('User groups cannot be used with Memcached engines. Only Redis and Valkey engines support user groups.', this);
            }
            if (engine === serverless_cache_base_1.CacheEngine.REDIS_LATEST && userGroup.engine !== common_1.UserEngine.REDIS) {
                throw new core_1.ValidationError('Redis cache can only use Redis user groups.', this);
            }
        }
        /**
         * Render cache usage limits for CloudFormation
         *
         * @param limits The usage limits to render
         * @returns CloudFormation-compatible usage limits object or undefined
         */
        renderCacheUsageLimits(limits) {
            if (!limits)
                return undefined;
            const cacheUsageLimits = {};
            if (limits.dataStorageMinimumSize !== undefined || limits.dataStorageMaximumSize !== undefined) {
                cacheUsageLimits.dataStorage = {
                    unit: DataStorageUnit.GIGABYTES,
                    ...(limits.dataStorageMinimumSize !== undefined && { minimum: limits.dataStorageMinimumSize.toGibibytes() }),
                    ...(limits.dataStorageMaximumSize !== undefined && { maximum: limits.dataStorageMaximumSize.toGibibytes() }),
                };
            }
            if (limits.requestRateLimitMinimum !== undefined || limits.requestRateLimitMaximum !== undefined) {
                cacheUsageLimits.ecpuPerSecond = {
                    ...(limits.requestRateLimitMinimum !== undefined && { minimum: limits.requestRateLimitMinimum }),
                    ...(limits.requestRateLimitMaximum !== undefined && { maximum: limits.requestRateLimitMaximum }),
                };
            }
            return Object.keys(cacheUsageLimits).length > 0 ? cacheUsageLimits : undefined;
        }
        /**
         * Configure subnets for the cache
         *
         * @param props The ServerlessCache properties
         * @returns Object containing subnet IDs and subnet objects
         */
        configureSubnets(props) {
            let selectedSubnets;
            if (props.vpcSubnets) {
                selectedSubnets = props.vpc.selectSubnets(props.vpcSubnets);
            }
            else {
                selectedSubnets = props.vpc.selectSubnets({
                    subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS,
                });
            }
            return {
                subnetIds: selectedSubnets.subnetIds.length > 0 ? selectedSubnets.subnetIds : undefined,
                subnets: selectedSubnets.subnets.length > 0 ? selectedSubnets.subnets : undefined,
            };
        }
        /**
         * Configure security groups for the cache
         *
         * @param props The ServerlessCache properties
         * @returns Object containing security group IDs and security group objects
         */
        configureSecurityGroups(props) {
            if (props.securityGroups && props.securityGroups.length > 0) {
                return {
                    securityGroupIds: props.securityGroups.map(sg => sg.securityGroupId),
                    securityGroups: props.securityGroups,
                };
            }
            else {
                const newSecurityGroup = new ec2.SecurityGroup(this, 'SecurityGroup', {
                    description: `Security group for ${this.node.id} cache.`,
                    vpc: props.vpc,
                });
                return {
                    securityGroupIds: [newSecurityGroup.securityGroupId],
                    securityGroups: [newSecurityGroup],
                };
            }
        }
        /**
         * Format schedule to HH:MM format for daily backups
         *
         * @param schedule The schedule to format
         * @returns Time string in HH:MM format
         */
        formatBackupTime(schedule) {
            const WILD_CARD = '*';
            const [minuteExpression, hourExpression, dayExpression, monthExpression, weekDayExpression, yearExpression,] = schedule.expressionString.substr(5).slice(0, -1).split(' ');
            if (dayExpression != WILD_CARD || monthExpression != WILD_CARD || yearExpression != WILD_CARD || weekDayExpression != '?') {
                throw new core_1.ValidationError('For now, only daily backup time is available (supports just hour and minute). Day, month, year, and weekDay are not allowed', this);
            }
            const hour = hourExpression == WILD_CARD ? '0' : hourExpression;
            const minute = minuteExpression == WILD_CARD ? '0' : minuteExpression;
            return `${hour.padStart(2, '0')}:${minute.padStart(2, '0')}`;
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ServerlessCache = _classThis;
})();
exports.ServerlessCache = ServerlessCache;
//# sourceMappingURL=data:application/json;base64,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