"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PasswordUser = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const aws_elasticache_1 = require("aws-cdk-lib/aws-elasticache");
const user_base_1 = require("./user-base");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const ELASTICACHE_PASSWORDUSER_SYMBOL = Symbol.for('@aws-cdk/aws-elasticache.PasswordUser');
/**
 * Define an ElastiCache user with password authentication.
 *
 * @resource AWS::ElastiCache::User
 */
let PasswordUser = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = user_base_1.UserBase;
    var PasswordUser = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            PasswordUser = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.PasswordUser", version: "2.223.0-alpha.0" };
        /**
         * Uniquely identifies this class.
         */
        static PROPERTY_INJECTION_ID = 'aws-cdk-lib.aws-elasticache.PasswordUser';
        /**
         * Return whether the given object is a `PasswordUser`.
         */
        static isPasswordUser(x) {
            return x !== null && typeof (x) === 'object' && ELASTICACHE_PASSWORDUSER_SYMBOL in x;
        }
        /**
         * The engine for the user.
         */
        engine;
        /**
         * The user's ID.
         *
         * @attribute
         */
        userId;
        /**
         * The user's name.
         *
         * @attribute
         */
        userName;
        /**
         * The access string that defines the user's permissions.
         */
        accessString;
        /**
         * The user's ARN.
         *
         * @attribute
         */
        userArn;
        /**
         * The user's status.
         * Can be 'active', 'modifying', 'deleting'.
         *
         * @attribute
         */
        userStatus;
        resource;
        constructor(scope, id, props) {
            super(scope, id);
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_PasswordUserProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, PasswordUser);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            this.engine = props.engine ?? common_1.UserEngine.VALKEY;
            this.userId = props.userId;
            this.userName = props.userName ?? props.userId;
            this.accessString = props.accessControl.accessString;
            if (props.passwords.length < 1 || props.passwords.length > 2) {
                throw new core_1.ValidationError('Password authentication requires 1-2 passwords.', this);
            }
            this.resource = new aws_elasticache_1.CfnUser(this, 'Resource', {
                engine: this.engine,
                userId: props.userId,
                userName: this.userName,
                accessString: this.accessString,
                authenticationMode: {
                    Type: 'password',
                    Passwords: props.passwords.map(p => p.unsafeUnwrap()),
                },
                noPasswordRequired: false,
                passwords: undefined,
            });
            this.userArn = this.resource.attrArn;
            this.userStatus = this.resource.attrStatus;
            Object.defineProperty(this, ELASTICACHE_PASSWORDUSER_SYMBOL, { value: true });
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return PasswordUser = _classThis;
})();
exports.PasswordUser = PasswordUser;
//# sourceMappingURL=data:application/json;base64,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