"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoPasswordUser = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const aws_elasticache_1 = require("aws-cdk-lib/aws-elasticache");
const user_base_1 = require("./user-base");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const ELASTICACHE_NOPASSWORDUSER_SYMBOL = Symbol.for('@aws-cdk/aws-elasticache.NoPasswordUser');
/**
 * Define an ElastiCache user with no password authentication.
 *
 * @resource AWS::ElastiCache::User
 */
let NoPasswordUser = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = user_base_1.UserBase;
    var NoPasswordUser = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            NoPasswordUser = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.NoPasswordUser", version: "2.223.0-alpha.0" };
        /**
         * Uniquely identifies this class.
         */
        static PROPERTY_INJECTION_ID = 'aws-cdk-lib.aws-elasticache.NoPasswordUser';
        /**
         * Return whether the given object is a `NoPasswordUser`.
         */
        static isNoPasswordUser(x) {
            return x !== null && typeof (x) === 'object' && ELASTICACHE_NOPASSWORDUSER_SYMBOL in x;
        }
        /**
         * The engine for the user.
         */
        engine;
        /**
         * The user's ID.
         *
         * @attribute
         */
        userId;
        /**
         * The user's name.
         *
         * @attribute
         */
        userName;
        /**
         * The access string that defines the user's permissions.
         */
        accessString;
        /**
         * The user's ARN.
         *
         * @attribute
         */
        userArn;
        /**
         * The user's status.
         * Can be 'active', 'modifying', 'deleting'.
         *
         * @attribute
         */
        userStatus;
        resource;
        constructor(scope, id, props) {
            super(scope, id);
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_NoPasswordUserProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, NoPasswordUser);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            this.engine = props.engine ?? common_1.UserEngine.REDIS;
            this.userId = props.userId;
            this.userName = props.userName ?? props.userId;
            this.accessString = props.accessControl.accessString;
            if (this.engine === common_1.UserEngine.VALKEY) {
                throw new core_1.ValidationError('Valkey engine does not support no-password authentication.', this);
            }
            this.resource = new aws_elasticache_1.CfnUser(this, 'Resource', {
                engine: this.engine,
                userId: props.userId,
                userName: this.userName,
                accessString: this.accessString,
                authenticationMode: {
                    Type: 'no-password-required',
                },
                noPasswordRequired: true,
                passwords: undefined,
            });
            this.userArn = this.resource.attrArn;
            this.userStatus = this.resource.attrStatus;
            Object.defineProperty(this, ELASTICACHE_NOPASSWORDUSER_SYMBOL, { value: true });
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return NoPasswordUser = _classThis;
})();
exports.NoPasswordUser = NoPasswordUser;
//# sourceMappingURL=data:application/json;base64,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