import { Construct } from 'constructs';
import { UserEngine } from './common';
import { UserBase, UserBaseProps } from './user-base';
/**
 * Properties for defining an ElastiCache user with no password authentication.
 */
export interface NoPasswordUserProps extends UserBaseProps {
    /**
     * The name of the user.
     *
     * @default - Same as userId.
     */
    readonly userName?: string;
}
/**
 * Define an ElastiCache user with no password authentication.
 *
 * @resource AWS::ElastiCache::User
 */
export declare class NoPasswordUser extends UserBase {
    /**
     * Uniquely identifies this class.
     */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Return whether the given object is a `NoPasswordUser`.
     */
    static isNoPasswordUser(x: any): x is NoPasswordUser;
    /**
     * The engine for the user.
     */
    readonly engine?: UserEngine;
    /**
     * The user's ID.
     *
     * @attribute
     */
    readonly userId: string;
    /**
     * The user's name.
     *
     * @attribute
     */
    readonly userName?: string;
    /**
     * The access string that defines the user's permissions.
     */
    readonly accessString: string;
    /**
     * The user's ARN.
     *
     * @attribute
     */
    readonly userArn: string;
    /**
     * The user's status.
     * Can be 'active', 'modifying', 'deleting'.
     *
     * @attribute
     */
    readonly userStatus: string;
    private readonly resource;
    constructor(scope: Construct, id: string, props: NoPasswordUserProps);
}
