"use strict";
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamUser = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const aws_elasticache_1 = require("aws-cdk-lib/aws-elasticache");
const user_base_1 = require("./user-base");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
const ELASTICACHE_IAMUSER_SYMBOL = Symbol.for('@aws-cdk/aws-elasticache.IamUser');
/**
 * Define an ElastiCache user with IAM authentication.
 *
 * @resource AWS::ElastiCache::User
 */
let IamUser = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = user_base_1.UserBase;
    let _instanceExtraInitializers = [];
    let _grantConnect_decorators;
    let _grant_decorators;
    var IamUser = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            _grantConnect_decorators = [(0, metadata_resource_1.MethodMetadata)()];
            _grant_decorators = [(0, metadata_resource_1.MethodMetadata)()];
            __esDecorate(this, null, _grantConnect_decorators, { kind: "method", name: "grantConnect", static: false, private: false, access: { has: obj => "grantConnect" in obj, get: obj => obj.grantConnect }, metadata: _metadata }, null, _instanceExtraInitializers);
            __esDecorate(this, null, _grant_decorators, { kind: "method", name: "grant", static: false, private: false, access: { has: obj => "grant" in obj, get: obj => obj.grant }, metadata: _metadata }, null, _instanceExtraInitializers);
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            IamUser = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-elasticache-alpha.IamUser", version: "2.223.0-alpha.0" };
        /**
         * Uniquely identifies this class.
         */
        static PROPERTY_INJECTION_ID = 'aws-cdk-lib.aws-elasticache.IamUser';
        /**
         * Return whether the given object is an `IamUser`.
         */
        static isIamUser(x) {
            return x !== null && typeof (x) === 'object' && ELASTICACHE_IAMUSER_SYMBOL in x;
        }
        /**
         * The engine for the user.
         */
        engine = __runInitializers(this, _instanceExtraInitializers);
        /**
         * The user's ID.
         *
         * @attribute
         */
        userId;
        /**
         * The user's name.
         * For IAM authentication userName must be equal to userId.
         *
         * @attribute
         */
        userName;
        /**
         * The access string that defines the user's permissions.
         */
        accessString;
        /**
         * The user's ARN.
         *
         * @attribute
         */
        userArn;
        /**
         * The user's status.
         * Can be 'active', 'modifying', 'deleting'.
         *
         * @attribute
         */
        userStatus;
        resource;
        constructor(scope, id, props) {
            super(scope, id);
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_elasticache_alpha_IamUserProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, IamUser);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            this.engine = props.engine ?? common_1.UserEngine.VALKEY;
            this.userId = props.userId;
            this.userName = props.userName ?? props.userId;
            this.accessString = props.accessControl.accessString;
            if (this.userName !== this.userId) {
                throw new core_1.ValidationError('For IAM authentication, userName must be equal to userId.', this);
            }
            this.resource = new aws_elasticache_1.CfnUser(this, 'Resource', {
                engine: this.engine,
                userId: props.userId,
                userName: this.userName,
                accessString: this.accessString,
                authenticationMode: {
                    Type: 'iam',
                },
                noPasswordRequired: false,
                passwords: undefined,
            });
            this.userArn = this.resource.attrArn;
            this.userStatus = this.resource.attrStatus;
            Object.defineProperty(this, ELASTICACHE_IAMUSER_SYMBOL, { value: true });
        }
        /**
         * Grant connect permissions to the given IAM identity.
         *
         * @param grantee The IAM identity to grant permissions to.
         */
        grantConnect(grantee) {
            return this.grant(grantee, 'elasticache:Connect');
        }
        /**
         * Grant the given identity custom permissions.
         *
         * @param grantee The IAM identity to grant permissions to.
         * @param actions The actions to grant.
         */
        grant(grantee, ...actions) {
            return iam.Grant.addToPrincipal({
                grantee,
                actions,
                resourceArns: [this.userArn],
            });
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return IamUser = _classThis;
})();
exports.IamUser = IamUser;
//# sourceMappingURL=data:application/json;base64,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