import { Construct } from 'constructs';
import { UserEngine } from './common';
import { UserBase, UserBaseProps } from './user-base';
import * as iam from 'aws-cdk-lib/aws-iam';
/**
 * Properties for defining an ElastiCache user with IAM authentication.
 */
export interface IamUserProps extends UserBaseProps {
    /**
     * The name of the user.
     *
     * @default - Same as userId.
     */
    readonly userName?: string;
}
/**
 * Define an ElastiCache user with IAM authentication.
 *
 * @resource AWS::ElastiCache::User
 */
export declare class IamUser extends UserBase {
    /**
     * Uniquely identifies this class.
     */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Return whether the given object is an `IamUser`.
     */
    static isIamUser(x: any): x is IamUser;
    /**
     * The engine for the user.
     */
    readonly engine?: UserEngine;
    /**
     * The user's ID.
     *
     * @attribute
     */
    readonly userId: string;
    /**
     * The user's name.
     * For IAM authentication userName must be equal to userId.
     *
     * @attribute
     */
    readonly userName?: string;
    /**
     * The access string that defines the user's permissions.
     */
    readonly accessString: string;
    /**
     * The user's ARN.
     *
     * @attribute
     */
    readonly userArn: string;
    /**
     * The user's status.
     * Can be 'active', 'modifying', 'deleting'.
     *
     * @attribute
     */
    readonly userStatus: string;
    private readonly resource;
    constructor(scope: Construct, id: string, props: IamUserProps);
    /**
     * Grant connect permissions to the given IAM identity.
     *
     * @param grantee The IAM identity to grant permissions to.
     */
    grantConnect(grantee: iam.IGrantable): iam.Grant;
    /**
     * Grant the given identity custom permissions.
     *
     * @param grantee The IAM identity to grant permissions to.
     * @param actions The actions to grant.
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
