# Generated by Django 2.1.7 on 2019-03-27 07:03

import bitfield.models
import django.utils.timezone
from django.db import migrations, models

import isc_common.fields.code_field
import isc_common.fields.name_field
import isc_common.fields.related


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('ckk', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Document_attrs',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('section', isc_common.fields.code_field.CodeField(blank=True, null=True, verbose_name='Раздел')),
                ('subsection', isc_common.fields.code_field.CodeField(blank=True, null=True, verbose_name='Подраздел')),
                ('value_str', models.TextField(blank=True, null=True, verbose_name='Значение атрибута')),
                ('props', bitfield.models.BitField((('relevant', 'Актуальность'),), blank=True, default=None, null=True)),
                ('attr_type', isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, to='ckk.Attr_type', verbose_name='Тип атрибута')),
            ],
            options={
                'verbose_name': 'Аттрибуты докуменнта',
            },
        ),
        migrations.CreateModel(
            name='Documents',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('file_document', models.TextField(verbose_name='Полный путь к файлу')),
                ('file_size', models.PositiveIntegerField(verbose_name='Размер файла')),
                ('file_modification_time', models.DateTimeField(blank=True, null=True, verbose_name='Дата время поcледнего модификации документа')),
                ('file_access_time', models.DateTimeField(blank=True, null=True, verbose_name='Дата время поcледнего доступа к документу')),
                ('file_change_time', models.DateTimeField(blank=True, null=True, verbose_name='Дата время изменнения документа')),
                ('props', bitfield.models.BitField((('relevant', 'Актуальность'), ('beenItemed', 'Был внесен в состав изделий')), default=1)),
                ('attr_type', isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, to='ckk.Attr_type', verbose_name='Тип документа')),
            ],
            options={
                'verbose_name': 'Конструкторские документы',
            },
        ),
        migrations.CreateModel(
            name='Documents_thumb',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('format', isc_common.fields.name_field.NameField(verbose_name='Формат файла')),
                ('mime_type', isc_common.fields.name_field.NameField(blank=True, default=None, null=True, verbose_name='MIME тип файла файла')),
                ('size', models.BigIntegerField(default=0, verbose_name='Размер фала')),
                ('real_name', models.TextField(blank=True, default=None, null=True, verbose_name='Первоначальное имя файла')),
                ('key', models.BinaryField(blank=True, max_length=200, null=True)),
                ('attfile', models.FileField(blank=True, default=None, max_length=255, null=True, upload_to='', verbose_name='Файл')),
                ('file_store', models.CharField(blank=True, max_length=255, null=True, verbose_name='Каталог хранения файла')),
                ('path', models.TextField(unique=True)),
                ('document', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='kd.Documents', verbose_name='КД')),
            ],
            options={
                'verbose_name': 'JPEG варианты документов уменьшенная копия',
            },
        ),
        migrations.CreateModel(
            name='Documents_thumb10',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('format', isc_common.fields.name_field.NameField(verbose_name='Формат файла')),
                ('mime_type', isc_common.fields.name_field.NameField(blank=True, default=None, null=True, verbose_name='MIME тип файла файла')),
                ('size', models.BigIntegerField(default=0, verbose_name='Размер фала')),
                ('real_name', models.TextField(blank=True, default=None, null=True, verbose_name='Первоначальное имя файла')),
                ('key', models.BinaryField(blank=True, max_length=200, null=True)),
                ('attfile', models.FileField(blank=True, default=None, max_length=255, null=True, upload_to='', verbose_name='Файл')),
                ('file_store', models.CharField(blank=True, max_length=255, null=True, verbose_name='Каталог хранения файла')),
                ('path', models.TextField(unique=True)),
                ('document', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='kd.Documents', verbose_name='КД')),
            ],
            options={
                'verbose_name': 'JPEG варианты документов',
            },
        ),
        migrations.CreateModel(
            name='Pathes',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('path', models.TextField(verbose_name='Путь')),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='kd.Pathes')),
            ],
            options={
                'verbose_name': 'Пути нахождения документов',
            },
        ),
        migrations.AddField(
            model_name='documents',
            name='path',
            field=isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, to='kd.Pathes', verbose_name='Путь к документу'),
        ),
        migrations.AddField(
            model_name='document_attrs',
            name='document',
            field=isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, to='kd.Documents', verbose_name='Документ'),
        ),
        migrations.CreateModel(
            name='Cdw',
            fields=[
            ],
            options={
                'verbose_name': 'Чертеж',
                'proxy': True,
                'indexes': [],
            },
            bases=('kd.document_attrs',),
        ),
        migrations.CreateModel(
            name='Spw',
            fields=[
            ],
            options={
                'verbose_name': 'Спецификация',
                'proxy': True,
                'indexes': [],
            },
            bases=('kd.document_attrs',),
        ),
        migrations.AlterUniqueTogether(
            name='document_attrs',
            unique_together={('document', 'attr_type', 'section', 'subsection')},
        ),
    ]
