from __future__ import absolute_import
from unittest import TestCase
from . import make_mask_ellipse
from ..circlair_mask.main import make_mask_circle
import numpy as np
from numpy.testing import assert_array_equal
import cv2

class TestMakeMaskEllipse(TestCase):
    def test_MMESmall_small_radii(self):
        size = (8, 4)
        x = 3
        y = 1
        r1 = 3
        r2 = 1

        self.assertRaises(ValueError, make_mask_ellipse, size, x, y, r1, r2)

    def test_MMESmall_even_radii_length(self):
        size = (13, 11)
        x = 6
        y = 4
        r1 = 6
        r2 = 4

        expected = np.array([
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
            [1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]])

        mask = make_mask_ellipse(size, x, y, r1, r2)
        assert_array_equal(mask, expected)

    def test_MMESmall_odd_radii_length(self):
        size = (13, 11)
        x = 6
        y = 4
        r1 = 5
        r2 = 3

        expected = np.array([
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]])

        mask = make_mask_ellipse(size, x, y, r1, r2)
        assert_array_equal(mask, expected)

    def test_MMESmall_combined(self):
        size = (16, 17)
        x = 9
        y = 9
        rx = 3
        ry = 6

        expected = np.array([[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 1., 1., 1., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]])

        mask = make_mask_ellipse(size, x, y, rx, ry)
        assert_array_equal(expected, mask)

    def test_mask_ellipse_no_rotation_16X16(self):
        expected = np.array([[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0.],
                             [0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0.],
                             [0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                             [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]])

        size = (16, 16)
        x = 9
        y = 9
        r1 = 5
        r2 = 3
        mask = make_mask_ellipse(size, x, y, r1, r2)
        assert_array_equal(mask, expected)

    def test_make_mask_small_radii(self):
        expected_array = np.array([[0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0.],
                                   [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                                   [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
                                   [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
                                   [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
                                   ])
        size = (15, 15)
        x = 6
        y = 5
        r1 = 5
        r2 = 3

        mask = make_mask_ellipse(size, x, y, r1, r2)
        assert_array_equal(expected_array, mask)

    def test_15x15_5(self):
        expected = np.array([
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0.],
            [0., 0., 0., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 1., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
            [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]])

        size = (15, 15)
        x = 6
        y = 6
        r1 = 5
        r2 = 5

        mask = make_mask_ellipse(size, x, y, r1, r2)
        assert_array_equal(mask, expected)

    def test_compare_circle_with_ellipse(self):
        size = (101, 101)
        x = 50
        y = 50
        r1 = 25
        r2 = 25

        mask_ell = make_mask_ellipse(size, x, y, r1, r2)
        mask_cir = make_mask_circle(size, r1*2)
        assert_array_equal(mask_cir, mask_ell)

    def test_MMEBig_expected(self):
        size = (700, 700)
        x = 300
        y = 300
        rx = 250
        ry = 150

        mask = make_mask_ellipse(size, x, y, rx, ry)

        # X minimum
        self.assertEqual(False, mask[300][48])
        self.assertEqual(True, mask[300][52])

        # X Maximum
        self.assertEqual(True, mask[300][548])
        self.assertEqual(False, mask[300][552])
        
        # Y minimum
        self.assertEqual(False, mask[148][300])
        self.assertEqual(True, mask[152][300])

        # Y maximum
        self.assertEqual(True, mask[448][300])
        self.assertEqual(False, mask[452][300])



    def test_MMEBig_expected_odd_size(self):
        size = (10000, 10001)
        x = 5000
        y = 2467
        rx = 3200
        ry = 1692

        mask = make_mask_ellipse(size, x, y, rx, ry)
        self.assertEqual(True, mask[2467][5000])
        self.assertEqual(True, mask[3000][5000])

        # X minimum
        self.assertEqual(False, mask[2467][1798])
        self.assertEqual(True, mask[2467][1801])

        # X Maximum
        self.assertEqual(True, mask[2467][8198])
        self.assertEqual(False, mask[2467][8201])
        
        # Y minimum
        self.assertEqual(False, mask[773][5000])
        self.assertEqual(True, mask[777][5000])

        # Y maximum
        self.assertEqual(True, mask[4157][5000])
        self.assertEqual(False, mask[4161][5000])

