import oss2

from conf import conf
import os 

endpoint = os.environ.get('BATCH_COMPUTE_OSS_HOST')

auth = oss2.Auth(conf['access_key_id'], conf['access_key_secret'])

def download_file(oss_path, filename):

    (bucket, key) = parse_oss_path(oss_path)

    bucket_tool = oss2.Bucket(auth, endpoint, bucket)

    bucket_tool.get_object_to_file(key, filename)

def upload_file(filename, oss_path):

    (bucket, key) = parse_oss_path(oss_path)

    bucket_tool = oss2.Bucket(auth, endpoint, bucket)

    bucket_tool.put_object_from_file(key,filename)

def put_data(data, oss_path):

    (bucket, key) = parse_oss_path(oss_path)

    bucket_tool = oss2.Bucket(auth, endpoint, bucket)

    bucket_tool.put_object(key, data)

def parse_oss_path(oss_path):

    s = oss_path[len('oss://'):]

    [bucket, key] = s.split('/',1)

    return (bucket,key)