java job project
-----------------------

## 1. 工程介绍

这是一个 BatchCompute 作业工程, 同时也是个maven工程, 用来创建 AliCloud BatchCompute 作业.

工程目录结构:

```
 |-- src/             # 作业逻辑代码目录
      |-- main
           |-- java 
                |-- com.aliyun.batchcompute.job.logcount
                     |-- pojo       # pojo类
                     |-- util       # util类
                     |-- Count.java   # 任务 count 入口的源文件
                     |-- Merge.java   # 任务 merge 入口的源文件
                     |-- Split.java   # 任务 split 入口的源文件
 |-- target           # build 之后会出现, 里面有可执行的 jar 包, 为任务程序入口
 |-- project.json     # 工程描述文件, 描述打包路径等
 |-- job.json         # 作业描述文件, 描述作业中的任务, 以及DAG顺序.
 |-- Readme.md        # 新手必读
```

您可以使用以下命令查看作业描述详情:

```bash
bcs p st 
```



## 2. 编辑作业代码


### (1) 配置 job.json 

使用命令添加 auto cluster.

```bash
bcs p update -c img=m-28s58a5qq:type=ecs.s3.large
```

当然, 您也可以手动修改 job.json.


### (2) 编辑

推荐导入Eclipse 或者 IDEA 编辑.


### (3) 本地调试(适用于Docker模式运行的任务):

本地调试需要有Docker环境, 如果没有安装Docker请到官网查看教程, 这里不再赘述.

* 注意: 如果是Mac和Windows环境, 安装docker后, 需要双击 boot2docker 或者 Docker quickstart terminal 进入docker命令行环境

使用下面的命令调试:
```bash
bcs debug -h  #查看debug命令的帮助
```


## 3. build 工程

```bash
bcs p build
```

这个命令会执行以下2个操作:


* (1) 先运行 project.json 文件的 build_script 字段中的命令.

* (2) 按照 project.json 文件的 tar_src 字段指定的文件打包到 worker.tar.gz. (最终需要在project根目录生成 worker.tar.gz)


## 4. 提交作业

```bash
bcs submit
```

这个命令会做 3 步操作:

#### (1). 校验 job.json 的各个字段正确性.

#### (2). 上传 worker.tar.gz 到oss

具体地址为 job.json 中的配置的PackagePath 

#### (3). 按照 job.json 提交作业.

最后你可以 通过以下命令查看作业状态:

```bash
bcs job <job-id>  
```


