# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['silex', 'silex.fn', 'silex.testing', 'silex.utils']

package_data = \
{'': ['*']}

install_requires = \
['pyspark>=3']

setup_kwargs = {
    'name': 'spark-silex',
    'version': '0.1.0',
    'description': 'Silex adds more sparks to your project!',
    'long_description': '# Silex\n\nAdd more 🔥 to [Apache Spark](https://spark.apache.org/)!\n\n[![Python](https://img.shields.io/badge/Python3.8-Python?style=for-the-badge&logo=Python)](https://www.python.org/downloads/release/python-380/)\n[![Manager: Poetry](https://img.shields.io/badge/Manager-Poetry-blue?style=for-the-badge)](https://python-poetry.org/)\n[![Test: BDD](https://img.shields.io/badge/Test-BDD-critical?style=for-the-badge)](https://github.com/behave/behave)\n[![Test: Doctest](https://img.shields.io/badge/Test-Doctest-success?style=for-the-badge)](https://docs.python.org/3/library/doctest.html)\n\n[![Code style: Black](https://img.shields.io/badge/Codestyle-Black-black?style=for-the-badge)](https://github.com/psf/black)\n[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=for-the-badge&labelColor=ef8336)](https://pycqa.github.io/isort/)\n[![Linter: Flake8](https://img.shields.io/badge/Linter-Flake8-black?style=for-the-badge)](https://github.com/PyCQA/flake8)\n[![try/except style: tryceratops](https://img.shields.io/badge/try%2Fexcept%20style-tryceratops%20%F0%9F%A6%96%E2%9C%A8-black?style=for-the-badge)](https://github.com/guilatrova/tryceratops)\n\n[![Typing: MyPy](https://img.shields.io/badge/Typing-MyPy-blue?style=for-the-badge)](https://github.com/python/mypy)\n[![Security: Bandit](https://img.shields.io/badge/Security-Bandit-critical?style=for-the-badge)](https://github.com/PyCQA/bandit)\n\n\n[![Git: Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&style=for-the-badge&logoColor=white)](https://pre-commit.com/)\n[![Git: Conventional](https://img.shields.io/badge/Git-conventional-ff69b4?style=for-the-badge)](https://www.conventionalcommits.org)\n[![Version: Semantic](https://img.shields.io/badge/Version-Semantic-black?style=for-the-badge)](https://semver.org/)\n\n![Apache Spark](https://img.shields.io/static/v1?style=for-the-badge&message=Apache+Spark+%20+3&color=E25A1C&logo=Apache+Spark&logoColor=FFFFFF&label=)\n\n## TLDR\n\nSilex is a Data Engineering library to extend PySpark.\n\nYou don\'t need another class, just use PySpark as usual and you have new functions to your DataFrames!\n\n```python\nimport silex\nfrom pyspark.sql import DataFrame\n\n# extends your DataFrame with silex functions!\n# if for some reason you don\'t want to do that, check \'Without extending Dataframes\' README section below\nsilex.extend_dataframes()\n\ndf: DataFrame = ...  # your regular Spark DataFrame\ndf: DataFrame = df.drop_col_if_na()  # new function! and still a regular Spark Dataframe!\n# scroll for more information!\n```\n\n### Available functions\n\n```python\n# assertions (raises an Exception if not met /!\\)\ndef expect_column(self, col: str) -> DataFrame: ...\ndef expect_columns(self, cols: Union[str, List[str]]) -> DataFrame: ...\n\ndef expect_distinct_values_equal_set(self, cols: Union[str, List[str]], values: Collection[Any]) -> DataFrame: ...\ndef expect_distinct_values_in_set(self, cols: Union[str, List[str]], values: Collection[Any]) -> DataFrame: ...\n\ndef expect_min_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> DataFrame: ...\ndef expect_avg_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> DataFrame: ...\ndef expect_max_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> DataFrame: ...\n\ndef expect_unique_id(self, cols: Union[str, List[str]]) -> DataFrame: ...\n\n# boolean checks\ndef has_column(self, col: str) -> bool: ...\ndef has_columns(self, cols: Union[str, List[str]]) -> bool: ...\n\ndef has_distinct_values_equal_set(self, cols: Union[str, List[str]], values: Collection[Any]) -> bool: ...\ndef has_distinct_values_in_set(self, cols: Union[str, List[str]], values: Collection[Any]) -> bool: ...\n\ndef has_min_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> bool: ...\ndef has_avg_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> bool: ...\ndef has_max_value_between(self, cols: Union[str, List[str]], min: Any, max: Any) -> bool: ...\n\ndef has_unique_id(self, cols: Union[str, List[str]]) -> bool: ...\n\n# dates\ndef with_date_column(self, col: str, fmt: str, new_col: Optional[str] = None) -> DataFrame: ...\n\n# drop\ndef drop_col_if_na(self, max: int) -> DataFrame: ...\ndef drop_col_if_not_distinct(self, min: int) -> DataFrame: ...\n\n# filters\ndef filter_on_range(self, col: str, from_: Any, to: Any, ...) -> DataFrame: ...\n\n# joins\ndef join_closest_date(self, other: DataFrame, ...) -> DataFrame: ...\n```\n\n## Getting started\n\n### Pre-requisites\n\n- Python 3.8 or above\n- Spark 3 or above\n\n### Installation\n\n```shell\npip install < # TODO >\n```\n\n### Usage\n\n#### By extending DataFrames! ⚡\n\n```python\nimport silex\nfrom pyspark.sql import DataFrame, SparkSession\n\n# extends your DataFrame with silex functions!\n# if for some reason you don\'t want to do that, check next example\nsilex.extend_dataframes()\n\nspark = SparkSession.builder.getOrCreate()\n\ndata = [\n    (0, "2022-01-01", "a", 1.0),\n    (1, "2022-02-01", "b", 2.0),\n    (2, "2022-03-01", "c", 3.0),\n]\ndf: DataFrame = spark.createDataFrame(data, schema=["id", "date", "text", "value"])\n\ndf.show()\n# +---+----------+----+-----+\n# | id|      date|text|value|\n# +---+----------+----+-----+\n# |  0|2022-01-01|   a|  1.0|\n# |  1|2022-02-01|   b|  2.0|\n# |  2|2022-03-01|   c|  3.0|\n# +---+----------+----+-----+\n\ndf.printSchema()\n# root\n#  |-- id: long (nullable = true)\n#  |-- date: string (nullable = true)\n#  |-- text: string (nullable = true)\n#  |-- value: double (nullable = true)\n\ndf = df.with_date_column(col="date", fmt="yyyy-MM-dd")\n\ndf.show()\n# +---+----------+----+-----+\n# | id|      date|text|value|\n# +---+----------+----+-----+\n# |  0|2022-01-01|   a|  1.0|\n# |  1|2022-02-01|   b|  2.0|\n# |  2|2022-03-01|   c|  3.0|\n# +---+----------+----+-----+\n\ndf.printSchema()\n# root\n#  |-- id: long (nullable = true)\n#  |-- date: date (nullable = true)\n#  |-- text: string (nullable = true)\n#  |-- value: double (nullable = true)\n```\n\n#### Without extending Dataframes 🌧️\n\n```python\nfrom silex.fn.date import with_date_column\nfrom pyspark.sql import DataFrame, SparkSession\n\nspark = SparkSession.builder.getOrCreate()\n\ndata = [\n    (0, "2022-01-01", "a", 1.0),\n    (1, "2022-02-01", "b", 2.0),\n    (2, "2022-03-01", "c", 3.0),\n]\ndf: DataFrame = spark.createDataFrame(data, schema=["id", "date", "text", "value"])\n\ndf.show()\n# +---+----------+----+-----+\n# | id|      date|text|value|\n# +---+----------+----+-----+\n# |  0|2022-01-01|   a|  1.0|\n# |  1|2022-02-01|   b|  2.0|\n# |  2|2022-03-01|   c|  3.0|\n# +---+----------+----+-----+\n\ndf.printSchema()\n# root\n#  |-- id: long (nullable = true)\n#  |-- date: string (nullable = true)\n#  |-- text: string (nullable = true)\n#  |-- value: double (nullable = true)\n\ndf = with_date_column(df=df, col="date", fmt="yyyy-MM-dd")\n\ndf.show()\n# +---+----------+----+-----+\n# | id|      date|text|value|\n# +---+----------+----+-----+\n# |  0|2022-01-01|   a|  1.0|\n# |  1|2022-02-01|   b|  2.0|\n# |  2|2022-03-01|   c|  3.0|\n# +---+----------+----+-----+\n\ndf.printSchema()\n# root\n#  |-- id: long (nullable = true)\n#  |-- date: date (nullable = true)\n#  |-- text: string (nullable = true)\n#  |-- value: double (nullable = true)\n```\n\n## Contributing\n\n```shell\n# install poetry and python 3.8, using pyenv for instance\n\ncd silex\npoetry env use path/to/python3.8  # e.g. ~/.pyenv/versions/3.8.12/bin/python\npoetry shell\npoetry install\npre-commit install\n\nmake help\n# or open Makefile to learn about available commands for development\n```\n',
    'author': 'RickCi',
    'author_email': 'rci-git@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4',
}


setup(**setup_kwargs)
