# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['mft2es']
install_requires = \
['elasticsearch>=7.7.1,<8.0.0',
 'mft>=0.5.3,<0.6.0',
 'orjson>=3.6.0,<4.0.0',
 'tqdm>=4.46.1,<5.0.0',
 'urllib3>=1.26.5,<2.0.0']

entry_points = \
{'console_scripts': ['mft2es = mft2es.views.Mft2esView:entry_point',
                     'mft2json = mft2es.views.Mft2jsonView:entry_point']}

setup_kwargs = {
    'name': 'mft2es',
    'version': '1.3.2',
    'description': 'A library for fast import of Windows Master File Table($MFT) into Elasticsearch.',
    'long_description': '# mft2es\n\n[![MIT License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)\n[![PyPI version](https://badge.fury.io/py/mft2es.svg)](https://badge.fury.io/py/mft2es)\n[![Python Versions](https://img.shields.io/pypi/pyversions/mft2es.svg)](https://pypi.org/project/mft2es/)\n[![DockerHub Status](https://shields.io/docker/cloud/build/sumeshi/mft2es)](https://hub.docker.com/r/sumeshi/mft2es)\n\n![mft2es logo](https://gist.githubusercontent.com/sumeshi/c2f430d352ae763273faadf9616a29e5/raw/681a72cc27829497283409e19a78808c1297c2db/mft2es.svg)\n\nFast import of Windows Master File Table(\\$MFT) into Elasticsearch.\n\nmft2es uses Rust library [pymft-rs](https://github.com/omerbenamram/pymft-rs).\n\n## Usage\n\n```bash\n$ mft2es /path/to/your/$MFT\n```\n\nor\n\n```python\nfrom mft2es import mft2es\n\nif __name__ == \'__main__\':\n  filepath = \'/path/to/your/$MFT\'\n  mft2es(filepath)\n```\n\n### Args\n\nmft2es supports multiple file input, all arguments are determined as file paths.\n\n```bash\n$ mft2es foo/MFT bar/MFT\n```\n\nor\n\n```bash\n$ tree .\nmftfiles/\n  ├── MFT\n  └── subdirectory/\n    ├── MFT\n    └── subsubdirectory/\n      ├── MFT\n      └── $MFT\n\n$ mft2es /mftfiles/ # The Path is recursively expanded to all MFT, and $MFT.\n```\n\n### Options\n\n```\n--version, -v\n\n--help, -h\n\n--quiet, -q\n  Flag to suppress standard output\n  (default: False)\n\n--multiprocess, -m:\n  Flag to run multiprocessing (fast!)\n  (default: False)\n\n--size:\n  Size of the chunk to be processed for each process\n  (default: 500)\n\n--host:\n  ElasticSearch host address\n  (default: localhost)\n\n--port:\n  ElasticSearch port number\n  (default: 9200)\n\n--index:\n  Index name\n  (default: mft2es)\n\n--scheme:\n  Scheme to use (http, or https)\n  (default: http)\n\n--pipeline\n  Elasticsearch Ingest Pipeline to use\n  (default: )\n\n--login:\n  The login to use if Elastic Security is enable\n  (default: )\n\n--pwd:\n  The password linked to the login provided\n  (default: )\n```\n\n### Examples\n\nWhen using from the commandline interface:\n\n```\n$ mft2es /path/to/your/$MFT --host=localhost --port=9200 --index=foobar --size=500\n```\n\nWhen using from the python-script:\n\n```py\nif __name__ == \'__main__\':\n    mft2es(\'/path/to/your/$MFT\', host=localhost, port=9200, index=\'foobar\', size=500)\n```\n\nWith the Amazon Elasticsearch Serivce (ES):\n\n```\n$ mft2es /path/to/your/$MFT --host=example.us-east-1.es.amazonaws.com --port=443 --scheme=https --index=foobar\n```\n\nWith credentials for Elastic Security:\n\n```\n$ mft2es /path/to/your/$MFT --host=localhost --port=9200 --index=foobar --login=elastic --pwd=******\n```\n\nNote: The current version does not verify the certificate.\n\n## Appendix\n\n### Mft2json\n\nExtra feature. :sushi: :sushi: :sushi:\n\nConvert from Windows MFT to json file.\n\n```bash\n$ mft2json /path/to/your/$MFT -o /path/to/output/target.json\n```\n\nor\n\n```python\nfrom mft2json import mft2json\n\nif __name__ == \'__main__\':\n  filepath = \'/path/to/your/$MFT\'\n  result: List[dict] = mft2json(filepath)\n```\n\n\n## Output Format\n\nThe structures is not well optimized for searchable with Elasticsearch. I\'m waiting for your PR!!\n\n```json\n[\n  {\n    "header": {\n      "signature": [\n        70,\n        73,\n        76,\n        69\n      ],\n      "usa_offset": 48,\n      "usa_size": 3,\n      "metadata_transaction_journal": 172848302,\n      "sequence": 1,\n      "hard_link_count": 1,\n      "first_attribute_record_offset": 56,\n      "flags": "ALLOCATED",\n      "used_entry_size": 416,\n      "total_entry_size": 1024,\n      "base_reference": {\n        "entry": 0,\n        "sequence": 0\n      },\n      "first_attribute_id": 6,\n      "record_number": 0\n    },\n    "attributes": {\n      "StandardInformation": {\n        "header": {\n          "type_code": "StandardInformation",\n          "record_length": 96,\n          "form_code": 0,\n          "residential_header": {\n            "index_flag": 0\n          },\n          "name_size": 0,\n          "name_offset": null,\n          "data_flags": "(empty)",\n          "instance": 0,\n          "name": ""\n        },\n        "data": {\n          "created": "2019-03-11T16:42:33.593750Z",\n          "modified": "2019-03-11T16:42:33.593750Z",\n          "mft_modified": "2019-03-11T16:42:33.593750Z",\n          "accessed": "2019-03-11T16:42:33.593750Z",\n          "file_flags": "FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM",\n          "max_version": 0,\n          "version": 0,\n          "class_id": 0,\n          "owner_id": 0,\n          "security_id": 256,\n          "quota": 0,\n          "usn": 0\n        }\n      },\n      "FileName": {\n        "header": {\n          "type_code": "FileName",\n          "record_length": 104,\n          "form_code": 0,\n          "residential_header": {\n            "index_flag": 1\n          },\n          "name_size": 0,\n          "name_offset": null,\n          "data_flags": "(empty)",\n          "instance": 3,\n          "name": ""\n        },\n        "data": {\n          "parent": {\n            "entry": 5,\n            "sequence": 5\n          },\n          "created": "2019-03-11T16:42:33.593750Z",\n          "modified": "2019-03-11T16:42:33.593750Z",\n          "mft_modified": "2019-03-11T16:42:33.593750Z",\n          "accessed": "2019-03-11T16:42:33.593750Z",\n          "logical_size": 16384,\n          "physical_size": 16384,\n          "flags": "FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM",\n          "reparse_value": 0,\n          "name_length": 4,\n          "namespace": "Win32AndDos",\n          "name": "$MFT",\n          "path": "$MFT"\n        }\n      },\n      "DATA": {\n        "header": {\n          "type_code": "DATA",\n          "record_length": 72,\n          "form_code": 1,\n          "residential_header": {\n            "vnc_first": 0,\n            "vnc_last": "0x198f",\n            "unit_compression_size": 0,\n            "allocated_length": 62390272,\n            "file_size": 62390272,\n            "valid_data_length": 62390272,\n            "total_allocated": null\n          },\n          "name_size": 0,\n          "name_offset": null,\n          "data_flags": "(empty)",\n          "instance": 1,\n          "name": ""\n        },\n        "data": null\n      },\n      "BITMAP": {\n        "header": {\n          "type_code": "BITMAP",\n          "record_length": 80,\n          "form_code": 1,\n          "residential_header": {\n            "vnc_first": 0,\n            "vnc_last": 0,\n            "unit_compression_size": 0,\n            "allocated_length": 12288,\n            "file_size": 8200,\n            "valid_data_length": 8200,\n            "total_allocated": null\n          },\n          "name_size": 0,\n          "name_offset": null,\n          "data_flags": "(empty)",\n          "instance": 5,\n          "name": ""\n        },\n        "data": null\n      }\n    }\n  }\n  ...\n]\n````\n\n## Installation\n\n### via PyPI\n```\n$ pip install mft2es\n```\n\n### via DockerHub\n```\n$ docker pull sumeshi/mft2es:latest\n```\n\n## Run with Docker\nhttps://hub.docker.com/r/sumeshi/mft2es\n\n\n## mft2es\n```bash\n# "host.docker.internal" is only available in mac and windows environments.\n# For linux, use the --add-host option.\n$ docker run -t --rm -v $(pwd):/app/work sumeshi/mft2es:latest mft2es /app/work/\\$MFT --host=host.docker.internal\n```\n\n## mft2json\n```bash\n$ docker run -t --rm -v $(pwd):/app/work sumeshi/mft2es:latest mft2json /app/work/\\$MFT /app/work/out.json\n```\n\nDo not use the "latest" image if at all possible.  \nThe "latest" image is not a released version, but is built from the contents of the master branch.\n\n## Contributing\n\n[CONTRIBUTING](https://github.com/sumeshi/mft2es/blob/master/CONTRIBUTING.md)\n\nThe source code for mft2es is hosted at GitHub, and you may download, fork, and review it from this repository(https://github.com/sumeshi/mft2es).\nPlease report issues and feature requests. :sushi: :sushi: :sushi:\n\n## License\n\nmft2es is released under the [MIT](https://github.com/sumeshi/mft2es/blob/master/LICENSE) License.\n\nPowered by [pymft-rs](https://github.com/omerbenamram/pymft-rs).\n',
    'author': 'sumeshi',
    'author_email': 'j15322sn@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sumeshi/mft2es',
    'package_dir': package_dir,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
