# itkwasm-dicom

[![PyPI version](https://badge.fury.io/py/itkwasm-dicom.svg)](https://badge.fury.io/py/itkwasm-dicom)

Read files and images related to DICOM file format.

[🕮 **Documentation** 📚](https://itk-wasm-dicom-python-docs.on.fleek.co/)


## Installation

```sh
pip install itkwasm-dicom
```

## Acknowledgments

`itkwasm-dicom` stands on the shoulders of the following giants:

- [ITK](https://docs.itk.org/)
- [GDCM](https://sourceforge.net/projects/gdcm/)
- [DCMTK](https://dicom.offis.de/dcmtk.php.en)
- [DCMQI](https://github.com/QIICR/dcmqi)

The versions of libraries are the following:

- [ITK](https://github.com/InsightSoftwareConsortium/ITK-Wasm/blob/main/itk_wasm_env.bash#L18-L19)
- [GDCM (vendored in
  ITK)](https://github.com/InsightSoftwareConsortium/ITK-Wasm/blob/main/itk_wasm_env.bash#L18-L19)
- [DCMTK](https://github.com/InsightSoftwareConsortium/ITK-Wasm/blob/main/itk_wasm_env.bash#L15-L16)
- [DCMQI](https://github.com/InsightSoftwareConsortium/ITK-Wasm/blob/main/packages/dicom/dcmtk/CMakeLists.txt#L16-L17)

Development of this library was supported by [NCI Imaging Data Commons](https://imaging.datacommons.cancer.gov/), and has been funded in whole or in part with Federal funds from the National Cancer Institute, National Institutes of Health, under Task Order No. HHSN26110071 under Contract No. HHSN261201500003l.
