import { StateMachineFragment, State, IChainable, INextable } from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Interface for creating a SemaphoreGenerator
 */
export interface SemaphoreGeneratorProps {
    /**
     * Optionally set the DynamoDB table to have a specific read/write capacity with PROVISIONED billing.
     * @default PAY_PER_REQUEST
     */
    readonly tableReadWriteCapacity?: TableReadWriteCapacity;
}
/**
 * Read and write capacity for a PROVISIONED billing DynamoDB table.
 */
export interface TableReadWriteCapacity {
    readonly readCapacity: number;
    readonly writeCapacity: number;
}
export interface IChainNextable extends IChainable, INextable {
}
/**
 * Sets up up the DynamoDB table that stores the State Machine semaphores.
 * Call `generateSemaphoredJob` to generate semaphored jobs.
 */
export declare class SemaphoreGenerator extends Construct {
    /**
     * The DynamoDB table used to store semaphores.
     */
    private semaphoreTable;
    /**
     * The names and associated concurrency limits and number of uses of the sempahores.
     */
    private semaphoreTracker;
    constructor(scope: Construct, id: string, props?: SemaphoreGeneratorProps);
    /**
     * Generates a semaphore for a StepFunction job (or chained set of jobs) to limit parallelism across executions.
     * @param lockName The name of the semaphore.
     * @param limit The maximum number of concurrent executions for the given lock.
     * @param job The job (or chained jobs) to be semaphored.
     * @param nextState The State to go to after the semaphored job completes.
     * @param reuseLock Explicility allow the reuse of a named lock from a previously generated job. Throws an error if a different `limit` is specified. Default: false.
     * @param comments Adds detailed comments to lock related states. Significantly increases CloudFormation template size. Default: false.
     * @returns A StateMachineFragment that can chained to other states in the State Machine.
     */
    generateSemaphoredJob(lockName: string, limit: number, job: IChainNextable, nextState: State, reuseLock?: boolean, comments?: boolean): StateMachineFragment;
}
