import * as codecommit from '@aws-cdk/aws-codecommit';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) A Cloud9 Environment.
 *
 * @experimental
 */
export interface IEc2Environment extends cdk.IResource {
    /**
     * (experimental) The name of the EnvironmentEc2.
     *
     * @experimental
     * @attribute environmentEc2Name
     */
    readonly ec2EnvironmentName: string;
    /**
     * (experimental) The arn of the EnvironmentEc2.
     *
     * @experimental
     * @attribute environmentE2Arn
     */
    readonly ec2EnvironmentArn: string;
}
/**
 * (experimental) Properties for Ec2Environment.
 *
 * @experimental
 */
export interface Ec2EnvironmentProps {
    /**
     * (experimental) The type of instance to connect to the environment.
     *
     * @default - t2.micro
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) The subnetSelection of the VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     *
     * @default - all public subnets of the VPC are selected.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * (experimental) The VPC that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Name of the environment.
     *
     * @default - automatically generated name
     * @experimental
     */
    readonly ec2EnvironmentName?: string;
    /**
     * (experimental) Description of the environment.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The AWS CodeCommit repository to be cloned.
     *
     * @default - do not clone any repository
     * @experimental
     */
    readonly clonedRepositories?: CloneRepository[];
}
/**
 * (experimental) A Cloud9 Environment with Amazon EC2.
 *
 * @experimental
 * @resource AWS::Cloud9::EnvironmentEC2
 */
export declare class Ec2Environment extends cdk.Resource implements IEc2Environment {
    /**
     * (experimental) import from EnvironmentEc2Name.
     *
     * @experimental
     */
    static fromEc2EnvironmentName(scope: Construct, id: string, ec2EnvironmentName: string): IEc2Environment;
    /**
     * (experimental) The environment name of this Cloud9 environment.
     *
     * @experimental
     * @attribute true
     */
    readonly ec2EnvironmentName: string;
    /**
     * (experimental) The environment ARN of this Cloud9 environment.
     *
     * @experimental
     * @attribute true
     */
    readonly ec2EnvironmentArn: string;
    /**
     * (experimental) The environment ID of this Cloud9 environment.
     *
     * @experimental
     */
    readonly environmentId: string;
    /**
     * (experimental) The complete IDE URL of this Cloud9 environment.
     *
     * @experimental
     */
    readonly ideUrl: string;
    /**
     * (experimental) VPC ID.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: Ec2EnvironmentProps);
}
/**
 * (experimental) The class for different repository providers.
 *
 * @experimental
 */
export declare class CloneRepository {
    readonly repositoryUrl: string;
    readonly pathComponent: string;
    /**
     * (experimental) import repository to cloud9 environment from AWS CodeCommit.
     *
     * @param repository the codecommit repository to clone from.
     * @param path the target path in cloud9 environment.
     * @experimental
     */
    static fromCodeCommit(repository: codecommit.IRepository, path: string): CloneRepository;
    private constructor();
}
