# coding: utf-8

"""
    Nomad Envoy Utils

    This is the API descriptor for the EC Platform and customs utils. Developed by [Samarkand Global](https://samarkand.global), EC Platform including [Youzan](https://www.youzan.com/) Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for python with `pip install nomad_envoy_utils_cli` - Install for node with `npm install nomad_envoy_utils_cli`  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_envoy_utils_cli.configuration import Configuration


class Cypher(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'store_id': 'str',
        'operation': 'str',
        'items': 'list[str]'
    }

    attribute_map = {
        'store_id': 'storeId',
        'operation': 'operation',
        'items': 'items'
    }

    def __init__(self, store_id=None, operation=None, items=[], local_vars_configuration=None):  # noqa: E501
        """Cypher - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._store_id = None
        self._operation = None
        self._items = None
        self.discriminator = None

        self.store_id = store_id
        self.operation = operation
        if items is not None:
            self.items = items

    @property
    def store_id(self):
        """Gets the store_id of this Cypher.  # noqa: E501

        Platform store ID  # noqa: E501

        :return: The store_id of this Cypher.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this Cypher.

        Platform store ID  # noqa: E501

        :param store_id: The store_id of this Cypher.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and store_id is None:  # noqa: E501
            raise ValueError("Invalid value for `store_id`, must not be `None`")  # noqa: E501

        self._store_id = store_id

    @property
    def operation(self):
        """Gets the operation of this Cypher.  # noqa: E501

        operation name, is_encrypt, encrypt_batch and decrypt_batch  # noqa: E501

        :return: The operation of this Cypher.  # noqa: E501
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this Cypher.

        operation name, is_encrypt, encrypt_batch and decrypt_batch  # noqa: E501

        :param operation: The operation of this Cypher.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and operation is None:  # noqa: E501
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501

        self._operation = operation

    @property
    def items(self):
        """Gets the items of this Cypher.  # noqa: E501


        :return: The items of this Cypher.  # noqa: E501
        :rtype: list[str]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this Cypher.


        :param items: The items of this Cypher.  # noqa: E501
        :type: list[str]
        """

        self._items = items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cypher):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Cypher):
            return True

        return self.to_dict() != other.to_dict()
