# coding: utf8
"""Fix join words"""

from typing import Dict

WORDS_SPACE: Dict[str, str] = {"کردیا": "کر دیا",
                               "کردی": "کر دی",
                               "ہوگیا": "ہو گیا",
                               "جاسکتے": "جا سکتے",
                               "کرادی": "کرا دی",
                               "ہوگئی": "ہو گئی",
                               "جارہا": "جا رہا",
                               "ہوجاتے": "ہو جاتے",
                               "اڑادیا": "اڑا دیا",
                               "ہوجائے": "ہو جائے",
                               "کردیے": "کر دیے",
                               "کرسکیں": "کر سکیں",
                               "بتایاہے": "بتایا ہے",
                               "رہاہے": "رہا ہے",
                               "ہےکہ": "ہے کہ",
                               "بالاترہے": "بالاتر ہے",
                               "کہاہے": "کہا ہے",
                               "جاتاہے": "جاتا ہے",
                               "بلایاہے": "بلایا ہے",
                               "جارہاہے": "جا رہا ہے",
                               "دیاہے": "دیا ہے",
                               "ہوگا": "ہو گا",
                               "کیاتھا": "کیا تھا",
                               # "کرلی۔": "کر لی۔",
                               "کیاگیا": "کیا گیا",
                               "گیاتھا": "گیا تھا",
                               "کےلئے": "کے لئے",
                               # "کےلئے۔": "کے لئے۔",
                               "ہوجانا": "ہو جانا",
                               # "گا۔انہوں": "گا۔ انہوں",
                               "کیاجائے": "کیا جائے",
                               # "آرہا": "آ رہا",
                               "دیاگیا": "دیا گیا",
                               # "ہے۔آپ": "ہے۔ آپ",
                               "کاکہناہے": "کا کہنا ہے",
                               # "ہے۔لیکن": "ہے۔ لیکن",
                               "بتایاگیا": "بتایا گیا",
                               # "ہے۔ایسے": "ہے۔ ایسے",
                               # "ہے۔ترجمان": "ہے۔ ترجمان",
                               "دیکھاجاسکتاہے": "دیکھا جا سکتا ہے",
                               "کامقدمہ": "کا مقدمہ",
                               # "نظرآنے": "نظر آنے",
                               # "گی۔فلم": "گی۔ فلم",
                               "بوگی": "بو گی",
                               "چھوڑدیں": "چھوڑ دیں",
                               # "گا۔ماہرین": "گا۔ ماہرین",
                               "بتاسکتی": "بتا سکتی",
                               # "ہے۔بہت": "ہے۔ بہت",
                               # "تھے۔جب": "تھے۔ جب",
                               # "ہیں۔شاہ": "ہیں۔ شاہ",
                               # "گیا۔محکمہ": "گیا۔ محکمہ",
                               # "تھے۔لیکن": "تھے۔ لیکن",
                               # "تھی۔ذرائع": "تھی۔ ذرائع",
                               # "کرلیں۔اس": "کرلیں۔ اس",
                               # "ہواہے۔": "ہوا ہے۔",
                               "کرارہے": "کرا رہے",
                               # "ہے۔کئی": "ہے۔ کئی",
                               "کرناہو": "کرنا ہو",
                               "کرسکتے": "کر سکتے",
                               "جارہی": "جا رہی",
                               "کہناتھا": "کہنا تھا",
                               "کےلیے": "کے لیے",
                               "کاکہناتھاکہ": "کا کہنا تھا کہ",
                               "جاکر": "جا کر",
                               "کیاہے": "کیا ہے",
                               "کودیا": "کو دیا",
                               "توحکومت": "تو حکومت",
                               "کومعاف": "کو معاف",
                               "کوخبردارکیا": "کو خبردار کیا",
                               "کوجانے": "کو جانے",
                               "کواپنے": "کو اپنے",
                               "اگرکوئی": "اگر کوئی",
                               "کوپھانسی": "کو پھانسی",
                               "کواستعمال": "کو استعمال",
                               "ہےجب": "ہے جب",
                               "رکھاگیا": "رکھا گیا",
                               "دکھایاگیا": "دکھایا گیا",
                               "کےنتیجے": "کے نتیجے",
                               "کیاجاسکتا": "کیا جا سکتا",
                               "تھاکہ": "تھا کہ",
                               "کہاکہ": "کہا کہ",
                               "کےبعد": "کے بعد",
                               "کرکے": "کر کے",
                               "گیاہے": "گیا ہے",
                               "کررہا": "کر رہا",
                               "کاکہنا": "کا کہنا",
                               "ہوتاہے": "ہوتا ہے",
                               "گئےہیں": "گئے ہیں",
                               # "آگئے": "آ گئے",
                               "ہوجاتی": "ہو جاتی",
                               "جاسکتا": "جا سکتا",
                               "کرناہے": "کرنا ہے",
                               "ءتک": "ء تک",
                               "ءکی": "ء کی",
                               "ءکے": "ء کے",
                               "آرہے": "آ رہے",
                               "آسکتا": "آ سکتا",
                               "آگئے": "آ گئے",
                               "آئیےآپ": "آئیے آپ",
                               "آئےروز": "آئے روز",
                               "آباداور": "آباد اور",
                               "آبادسے": "آباد سے",
                               "آبادمیں": "آباد میں",
                               "آبادکی": "آباد کی",
                               "آبادہائی": "آباد ہائی",
                               "آبادیکے": "آبادی کے",
                               "آتاہے": "آتا ہے",
                               "آتےہی": "آتے ہی",
                               "آتےہیں": "آتے ہیں",
                               "آزادعدلیہ": "آزاد عدلیہ",
                               "آسٹریلیاکے": "آسٹریلیا کے",
                               "آغازمیں": "آغاز میں",
                               "آغازکر": "آغاز کر",
                               "آغازکیا": "آغاز کیا",
                               "آمدکے": "آمد کے",
                               "آنےسے": "آنے سے",
                               "آنےوالا": "آنے والا",
                               "آنےوالی": "آنے والی",
                               "آنےوالے": "آنے والے",
                               "آنےپر": "آنے پر",
                               "آنےکا": "آنے کا",
                               "آنےکے": "آنے کے",
                               "آوازمیں": "آواز میں",
                               "آڑمیں": "آڑ میں",
                               "آگےبڑھ": "آگے بڑھ",
                               "آیااور": "آیا اور",
                               "آیاتو": "آیا تو",
                               "آیاکہ": "آیا کہ",
                               "آیاہے": "آیا ہے",
                               "ئےاس": "ئے اس",
                               "ئےاور": "ئے اور",
                               "ئےتا": "ئے تا",
                               "ئےتو": "ئے تو",
                               "ئےجس": "ئے جس",
                               "ئےوقوعہ": "ئے وقوعہ",
                               "ئےکہ": "ئے کہ",
                               "ئےگا": "ئے گا",
                               "ئےگی": "ئے گی",
                               "اتناہی": "اتنا ہی",
                               "اتوارکو": "اتوار کو",
                               "اثرانداز": "اثر انداز",
                               "احمدخان": "احمد خان",
                               "احمدشہزاد": "احمد شہزاد",
                               "اخبارکے": "اخبار کے",
                               "اختیارکرنے": "اختیار کرنے",
                               "اختیارکی": "اختیار کی",
                               "اداکرتا": "ادا کرتا",
                               "اداکرنا": "ادا کرنا",
                               "اداکریں": "ادا کریں",
                               "اداکرے": "ادا کرے",
                               "اداکیا": "ادا کیا",
                               "ادارےکو": "ادارے کو",
                               "ادارےکی": "ادارے کی",
                               "ازجلد": "از جلد",
                               "ازخود": "از خود",
                               "ازوقت": "از وقت",
                               "ازکم": "از کم",
                               "استدعاکی": "استدعا کی",
                               "استفسارکیا": "استفسار کیا",
                               "اسےاس": "اسے اس",
                               "اسےاپنی": "اسے اپنی",
                               "اسےاپنے": "اسے اپنے",
                               "اسےایک": "اسے ایک",
                               "اضافےکی": "اضافے کی",
                               "اضافےکے": "اضافے کے",
                               "اظہارانہوں": "اظہار انہوں",
                               "اظہارخیال": "اظہار خیال",
                               "اظہارکر": "اظہار کر",
                               "اظہارکیا": "اظہار کیا",
                               "اعتبارسے": "اعتبار سے",
                               "اعتزازاحسن": "اعتزاز احسن",
                               "اعتمادمیں": "اعتماد میں",
                               "اعدادو": "اعداد و",
                               "اعزازحاصل": "اعزاز حاصل",
                               "افرادنے": "افراد نے",
                               "افرادکو": "افراد کو",
                               "افرادکی": "افراد کی",
                               "افرادکے": "افراد کے",
                               "افرادہلاک": "افراد ہلاک",
                               "اقتدارکی": "اقتدار کی",
                               "امدادکی": "امداد کی",
                               "امدادکے": "امداد کے",
                               "امرکی": "امر کی",
                               "امریکااور": "امریکا اور",
                               "امریکانے": "امریکا نے",
                               "امریکاکو": "امریکا کو",
                               "انتظارکر": "انتظار کر",
                               "انتہاپسند": "انتہا پسند",
                               "انتہاپسندی": "انتہا پسندی",
                               "اندازسے": "انداز سے",
                               "اندازمیں": "انداز میں",
                               "اندازکر": "انداز کر",
                               "اندرسے": "اندر سے",
                               "انگلینڈکے": "انگلینڈ کے",
                               "انےکا": "انے کا",
                               "انےکی": "انے کی",
                               "انےکے": "انے کے",
                               "اوبامانے": "اوباما نے",
                               "اورآئندہ": "اور آئندہ",
                               "اورآئی": "اور آئی",
                               "اورآپ": "اور آپ",
                               "اوراسرائیل": "اور اسرائیل",
                               "اوراسی": "اور اسی",
                               "اوراسے": "اور اسے",
                               "اورامریکا": "اور امریکا",
                               "اورانسانی": "اور انسانی",
                               "اورانہوں": "اور انہوں",
                               "اورانہیں": "اور انہیں",
                               "اوراپنی": "اور اپنی",
                               "اوراپنے": "اور اپنے",
                               "اوراگر": "اور اگر",
                               "اورایران": "اور ایران",
                               "اورایسے": "اور ایسے",
                               "اوربرطانیہ": "اور برطانیہ",
                               "اوربعد": "اور بعد",
                               "اوربعض": "اور بعض",
                               "اوربلوچستان": "اور بلوچستان",
                               "اوربچوں": "اور بچوں",
                               "اوربھارت": "اور بھارت",
                               "اوربے": "اور بے",
                               "اورتو": "اور تو",
                               "اورتین": "اور تین",
                               "اورجب": "اور جب",
                               "اورجمہوریت": "اور جمہوریت",
                               "اورجنوبی": "اور جنوبی",
                               "اورحکومتی": "اور حکومتی",
                               "اورخشک": "اور خشک",
                               "اورخواتین": "اور خواتین",
                               "اوردل": "اور دل",
                               "اورزخمی": "اور زخمی",
                               "اورزیادہ": "اور زیادہ",
                               "اورسابق": "اور سابق",
                               "اورسماجی": "اور سماجی",
                               "اورسندھ": "اور سندھ",
                               "اورسی": "اور سی",
                               "اورسے": "اور سے",
                               "اورصحت": "اور صحت",
                               "اورصدر": "اور صدر",
                               "اورصوبائی": "اور صوبائی",
                               "اورطالبان": "اور طالبان",
                               "اورعالمی": "اور عالمی",
                               "اورعدلیہ": "اور عدلیہ",
                               "اورعوام": "اور عوام",
                               "اورعوامی": "اور عوامی",
                               "اورلوگ": "اور لوگ",
                               "اورلوگوں": "اور لوگوں",
                               "اورمتعدد": "اور متعدد",
                               "اورمجھے": "اور مجھے",
                               "اورمختلف": "اور مختلف",
                               "اورمذہبی": "اور مذہبی",
                               "اورمسلمانوں": "اور مسلمانوں",
                               "اورمعاشی": "اور معاشی",
                               "اورملک": "اور ملک",
                               "اورمیرے": "اور میرے",
                               "اورمیڈیا": "اور میڈیا",
                               "اورمیں": "اور میں",
                               "اوروزیر": "اور وزیر",
                               "اورپانی": "اور پانی",
                               "اورپاکستان": "اور پاکستان",
                               "اورپر": "اور پر",
                               "اورپنجاب": "اور پنجاب",
                               "اورپی": "اور پی",
                               "اورپیپلز": "اور پیپلز",
                               "اورکس": "اور کس",
                               "اورکشمیر": "اور کشمیر",
                               "اورکو": "اور کو",
                               "اورکہا": "اور کہا",
                               "اورکے": "اور کے",
                               "اورہر": "اور ہر",
                               "اورہم": "اور ہم",
                               "اورہماری": "اور ہماری",
                               "اورہمیں": "اور ہمیں",
                               "اوریوں": "اور یوں",
                               "اوریہاں": "اور یہاں",
                               "اوورزمیں": "اوورز میں",
                               "اوپرسے": "اوپر سے",
                               "اپناکام": "اپنا کام",
                               "اپناکردار": "اپنا کردار",
                               "اپنےآپ": "اپنے آپ",
                               "اپنےاندر": "اپنے اندر",
                               "اپنےبیان": "اپنے بیان",
                               "اپنےبیٹے": "اپنے بیٹے",
                               "اپنےشوہر": "اپنے شوہر",
                               "اپنےلئے": "اپنے لئے",
                               "اپنےمفادات": "اپنے مفادات",
                               "اپنےنام": "اپنے نام",
                               "اپنےوالد": "اپنے والد",
                               "اپنےگھروں": "اپنے گھروں",
                               "اپنےہاتھ": "اپنے ہاتھ",
                               "اپنےہاتھوں": "اپنے ہاتھوں",
                               "اکتوبرء": "اکتوبر ء",
                               "اکتوبرکو": "اکتوبر کو",
                               "اگرایسا": "اگر ایسا",
                               "اگرحکومت": "اگر حکومت",
                               "اگرپاکستان": "اگر پاکستان",
                               "اگرکو": "اگر کو",
                               "اہلکاروںنے": "اہلکاروں نے",
                               "ایئرپورٹ": "ایئر پورٹ",
                               "ایسالگتا": "ایسا لگتا",
                               "ایسانہ": "ایسا نہ",
                               "ایساکرنے": "ایسا کرنے",
                               "ایساہو": "ایسا ہو",
                               "ایسےافراد": "ایسے افراد",
                               "ایسےلوگ": "ایسے لوگ",
                               "ایسےلوگوں": "ایسے لوگوں",
                               "ایسےوقت": "ایسے وقت",
                               "باربار": "بار بار",
                               "بازارمیں": "بازار میں",
                               "باوجودبھی": "باوجود بھی",
                               "باہرنکل": "باہر نکل",
                               "باہرہو": "باہر ہو",
                               "بتایاتھا": "بتایا تھا",
                               "بجائے": "بجا ئے",
                               "بجےتک": "بجے تک",
                               "بدقسمتی": "بد قسمتی",
                               "برسوںسے": "برسوں سے",
                               "برقراررکھنے": "برقرار رکھنے",
                               "بروئےکار": "بروئے کار",
                               "بعداس": "بعد اس",
                               "بعداسے": "بعد اسے",
                               "بعدانہوں": "بعد انہوں",
                               "بعدانہیں": "بعد انہیں",
                               "بعدمیں": "بعد میں",
                               "بعدپاکستان": "بعد پاکستان",
                               "بلندہو": "بلند ہو",
                               "بنادیا": "بنا دیا",
                               "بنارہے": "بنا رہے",
                               "بنالیا": "بنا لیا",
                               "بناکر": "بنا کر",
                               "بناہوا": "بنا ہوا",
                               "بناءپر": "بناء پر",
                               "بنائےگئے": "بنائے گئے",
                               "بناتاہے": "بناتا ہے",
                               "بناتےہوئے": "بناتے ہوئے",
                               "بناتےہیں": "بناتے ہیں",
                               "بنانےوالے": "بنانے والے",
                               "بنانےپر": "بنانے پر",
                               "بنانےکی": "بنانے کی",
                               "بنانےکے": "بنانے کے",
                               "بنایاتھا": "بنایا تھا",
                               "بنایاگیا": "بنایا گیا",
                               "بنایاہے": "بنایا ہے",
                               "بنتےہیں": "بنتے ہیں",
                               "بندکر": "بند کر",
                               "بننےوالی": "بننے والی",
                               "بننےوالے": "بننے والے",
                               "بننےکا": "بننے کا",
                               "بننےکی": "بننے کی",
                               "بننےکے": "بننے کے",
                               "بنیادپر": "بنیاد پر",
                               "بنےگا": "بنے گا",
                               "بنےہوئے": "بنے ہوئے",
                               "بورڈنے": "بورڈ نے",
                               "بچانےکی": "بچانے کی",
                               "بچانےکیلئے": "بچانے کیلئے",
                               "بچنےکے": "بچنے کے",
                               "بچےکے": "بچے کے",
                               "بڑھاکر": "بڑھا کر",
                               "بڑھانےکے": "بڑھانے کے",
                               "بڑھتےہوئے": "بڑھتے ہوئے",
                               "بڑےپیمانے": "بڑے پیمانے",
                               "بھرکی": "بھر کی",
                               "بھرکے": "بھر کے",
                               "بھٹوزرداری": "بھٹو زرداری",
                               "بھٹونے": "بھٹو نے",
                               "بھٹوکو": "بھٹو کو",
                               "بہتربنانے": "بہتر بنانے",
                               "بہترہو": "بہتر ہو",
                               "بیشترعلاقوں": "بیشتر علاقوں",
                               "بینظیربھٹو": "بینظیر بھٹو",
                               "بیٹےکو": "بیٹے کو",
                               "بیٹےکی": "بیٹے کی",
                               "بےبس": "بے بس",
                               "بےبسی": "بے بسی",
                               "بےبنیاد": "بے بنیاد",
                               "بےجا": "بے جا",
                               "بےحسی": "بے حسی",
                               "بےروزگاری": "بے روزگاری",
                               "بےشک": "بے شک",
                               "بےنظیر": "بے نظیر",
                               "بےنقاب": "بے نقاب",
                               "بےپناہ": "بے پناہ",
                               "بےچینی": "بے چینی",
                               "بےگھر": "بے گھر",
                               "تجویزدی": "تجویز دی",
                               "تردیدکر": "تردید کر",
                               "تصویرمیں": "تصویر میں",
                               "تعدادمیں": "تعداد میں",
                               "تقریباایک": "تقریبا ایک",
                               "تنقیدکی": "تنقید کی",
                               "توآج": "تو آج",
                               "توآپ": "تو آپ",
                               "تواب": "تو اب",
                               "تواسے": "تو اسے",
                               "توامریکہ": "تو امریکہ",
                               "توان": "تو ان",
                               "تواپنی": "تو اپنی",
                               "توایسا": "تو ایسا",
                               "توایسے": "تو ایسے",
                               "توبھی": "تو بھی",
                               "توخود": "تو خود",
                               "توسب": "تو سب",
                               "توشاید": "تو شاید",
                               "توصرف": "تو صرف",
                               "تومجھے": "تو مجھے",
                               "تومیں": "تو میں",
                               "تونہ": "تو نہ",
                               "تونہیں": "تو نہیں",
                               "تونے": "تو نے",
                               "تووہاں": "تو وہاں",
                               "توپہلے": "تو پہلے",
                               "توکبھی": "تو کبھی",
                               "توکو": "تو کو",
                               "توکچھ": "تو کچھ",
                               "توکیا": "تو کیا",
                               "توہر": "تو ہر",
                               "توہم": "تو ہم",
                               "توہمارے": "تو ہمارے",
                               "توہمیں": "تو ہمیں",
                               "توہو": "تو ہو",
                               "توہے": "تو ہے",
                               "تویہی": "تو یہی",
                               "تھاجس": "تھا جس",
                               "تھالیکن": "تھا لیکن",
                               "تھےتاہم": "تھے تاہم",
                               "تھےمگر": "تھے مگر",
                               "تھےکہ": "تھے کہ",
                               "تیارکردہ": "تیار کردہ",
                               "تیارکرنے": "تیار کرنے",
                               "تیارکی": "تیار کی",
                               "تیارہو": "تیار ہو",
                               "تیارہے": "تیار ہے",
                               "تےاور": "تے اور",
                               "تےتھے": "تے تھے",
                               "تےرہتے": "تے رہتے",
                               "تےرہیں": "تے رہیں",
                               "تےرہے": "تے رہے",
                               "تےہوئے": "تے ہوئے",
                               "ثناءاللہ": "ثناء اللہ",
                               "جارہے": "جا رہے",
                               "جاسکتی": "جا سکتی",
                               "جاسکے": "جا سکے",
                               "جاچکا": "جا چکا",
                               "جاچکے": "جا چکے",
                               "جاتاتو": "جاتا تو",
                               "جاتارہا": "جاتا رہا",
                               "جاتےتھے": "جاتے تھے",
                               "جاتےہوئے": "جاتے ہوئے",
                               "جاسکتےہیں": "جاسکتے ہیں",
                               "جاناچاہئے": "جانا چاہئے",
                               "جاناچاہیے": "جانا چاہیے",
                               "جانتاہے": "جانتا ہے",
                               "جانتےہیں": "جانتے ہیں",
                               "جانےوالی": "جانے والی",
                               "جانےوالے": "جانے والے",
                               "جانےکا": "جانے کا",
                               "جانےکی": "جانے کی",
                               "جانےکے": "جانے کے",
                               "جاویداقبال": "جاوید اقبال",
                               "جاویدہاشمی": "جاوید ہاشمی",
                               "جاچکاہے": "جاچکا ہے",
                               "ججزکی": "ججز کی",
                               "جدیدترین": "جدید ترین",
                               "جلداز": "جلد از",
                               "جلدکو": "جلد کو",
                               "جلدکے": "جلد کے",
                               "جنوریء": "جنوری ء",
                               "جوآج": "جو آج",
                               "جواب": "جو اب",
                               "جواس": "جو اس",
                               "جوانوں": "جو انوں",
                               "جوانی": "جو انی",
                               "جواپنی": "جو اپنی",
                               "جوپاکستان": "جو پاکستان",
                               "جوپہلے": "جو پہلے",
                               "جوکسی": "جو کسی",
                               "جوکچھ": "جو کچھ",
                               "جوہر": "جو ہر",
                               "جہازمیں": "جہاز میں",
                               "جہازکے": "جہاز کے",
                               "جہانگیرترین": "جہانگیر ترین",
                               "جہاںوہ": "جہاں وہ",
                               "جیسےہی": "جیسے ہی",
                               "جےآئی": "جے آئی",
                               "جےپی": "جے پی",
                               "حادثےمیں": "حادثے میں",
                               "حادثےکے": "حادثے کے",
                               "حامدکرزئی": "حامد کرزئی",
                               "حاملہے": "حامل ہے",
                               "حدتک": "حد تک",
                               "حدسے": "حد سے",
                               "حدودمیں": "حدود میں",
                               "حضورص": "حضور ص",
                               "حیدرآباد": "حیدر آباد",
                               "خانےمیں": "خانے میں",
                               "خبردارکیا": "خبردار کیا",
                               "خداکا": "خدا کا",
                               "خداکی": "خدا کی",
                               "خداکے": "خدا کے",
                               "خطرےمیں": "خطرے میں",
                               "خطےکے": "خطے کے",
                               "خودمختاری": "خود مختاری",
                               "خودکشی": "خود کشی",
                               "خودکو": "خود کو",
                               "خورشیدشاہ": "خورشید شاہ",
                               "خیبرپختونخوا": "خیبر پختونخوا",
                               "خیبرپختونخواہ": "خیبر پختونخواہ",
                               "خیزمواد": "خیز مواد",
                               "دئیےگئے": "دئیے گئے",
                               "دائرکر": "دائر کر",
                               "دائرکی": "دائر کی",
                               "دسمبرء": "دسمبر ء",
                               "دسمبرمیں": "دسمبر میں",
                               "دسمبرکو": "دسمبر کو",
                               "دفترخارجہ": "دفتر خارجہ",
                               "دفترمیں": "دفتر میں",
                               "دنیابھر": "دنیا بھر",
                               "دنیاکو": "دنیا کو",
                               "دنیاکی": "دنیا کی",
                               "دوافراد": "دو افراد",
                               "دوتین": "دو تین",
                               "دودن": "دو دن",
                               "دوروز": "دو روز",
                               "دوسو": "دو سو",
                               "دوماہ": "دو ماہ",
                               "دوچار": "دو چار",
                               "دوہزار": "دو ہزار",
                               "دورتک": "دور تک",
                               "دورحکومت": "دور حکومت",
                               "دورسے": "دور سے",
                               "دورمیں": "دور میں",
                               "دورکرنے": "دور کرنے",
                               "دورکی": "دور کی",
                               "دورکے": "دور کے",
                               "دورہو": "دور ہو",
                               "دورےپر": "دورے پر",
                               "دورےکے": "دورے کے",
                               "دوسرےنمبر": "دوسرے نمبر",
                               "دوسرےکی": "دوسرے کی",
                               "دھماکےسے": "دھماکے سے",
                               "دھماکےمیں": "دھماکے میں",
                               "دھماکےکی": "دھماکے کی",
                               "دیئےجائیں": "دیئے جائیں",
                               "دیااور": "دیا اور",
                               "دیاتو": "دیا تو",
                               "دیاجاتا": "دیا جاتا",
                               "دیاجب": "دیا جب",
                               "دیاکہ": "دیا کہ",
                               "دیتاہوں": "دیتا ہوں",
                               "دیربعد": "دیر بعد",
                               "دیناچاہئے": "دینا چاہئے",
                               "دیناچاہیے": "دینا چاہیے",
                               "دینےمیں": "دینے میں",
                               "دینےوالی": "دینے والی",
                               "دینےکا": "دینے کا",
                               "دینےکی": "دینے کی",
                               "دینےکیلئے": "دینے کیلئے",
                               "دینےکے": "دینے کے",
                               "دیکھاتو": "دیکھا تو",
                               "دیکھاجا": "دیکھا جا",
                               "دیکھاکہ": "دیکھا کہ",
                               "دیکھاگیا": "دیکھا گیا",
                               "دیکھاہے": "دیکھا ہے",
                               "دیکھتےہوئے": "دیکھتے ہوئے",
                               "دیکھتےہی": "دیکھتے ہی",
                               "دیکھنےکو": "دیکھنے کو",
                               "دیکھنےکے": "دیکھنے کے",
                               "دیگرافراد": "دیگر افراد",
                               "دیگرممالک": "دیگر ممالک",
                               "دیےگئے": "دیے گئے",
                               "دےتو": "دے تو",
                               "دےدی": "دے دی",
                               "دےدیا": "دے دیا",
                               "دےرہے": "دے رہے",
                               "دےسکتا": "دے سکتا",
                               "دےسکتے": "دے سکتے",
                               "دےچکے": "دے چکے",
                               "دےکر": "دے کر",
                               "ذکرکیا": "ذکر کیا",
                               "ذکرہے": "ذکر ہے",
                               "رابطےمیں": "رابطے میں",
                               "رابطےکی": "رابطے کی",
                               "راستےمیں": "راستے میں",
                               "رشیدنے": "رشید نے",
                               "رضاگیلانی": "رضا گیلانی",
                               "رفتارسے": "رفتار سے",
                               "رنزبنائے": "رنز بنائے",
                               "رنزکی": "رنز کی",
                               "روزبھی": "روز بھی",
                               "روزتک": "روز تک",
                               "روزمیں": "روز میں",
                               "روزکے": "روز کے",
                               "روپےفی": "روپے فی",
                               "روپےمیں": "روپے میں",
                               "روپےپیسے": "روپے پیسے",
                               "روپےکی": "روپے کی",
                               "روکنےکی": "روکنے کی",
                               "روکنےکے": "روکنے کے",
                               "رکھاتھا": "رکھا تھا",
                               "رکھاجا": "رکھا جا",
                               "رکھاہے": "رکھا ہے",
                               "رکھتاہے": "رکھتا ہے",
                               "رکھتےتھے": "رکھتے تھے",
                               "رکھتےہیں": "رکھتے ہیں",
                               "رکھنےمیں": "رکھنے میں",
                               "رکھنےوالے": "رکھنے والے",
                               "رکھنےکیلئے": "رکھنے کیلئے",
                               "رکھےہوئے": "رکھے ہوئے",
                               "رکھےہیں": "رکھے ہیں",
                               "رہاہوں": "رہا ہوں",
                               "رہتاہے": "رہتا ہے",
                               "رہتےہوئے": "رہتے ہوئے",
                               "رہتےہیں": "رہتے ہیں",
                               "رہنےکا": "رہنے کا",
                               "رہےتو": "رہے تو",
                               "رہےگا": "رہے گا",
                               "رہےگی": "رہے گی",
                               "رہےہو": "رہے ہو",
                               "رہےہوتے": "رہے ہوتے",
                               "رہےہوں": "رہے ہوں",
                               "رہےہیں": "رہے ہیں",
                               "ریمنڈڈیوس": "ریمنڈ ڈیوس",
                               "ریکارڈکی": "ریکارڈ کی",
                               "ریکارڈکیا": "ریکارڈ کیا",
                               "زائدافراد": "زائد افراد",
                               "زلزلےکے": "زلزلے کے",
                               "زورسے": "زور سے",
                               "زیرصدارت": "زیر صدارت",
                               "سالء": "سال ء",
                               "سامناکرنا": "سامنا کرنا",
                               "سامنےآ": "سامنے آ",
                               "سامنےآئی": "سامنے آئی",
                               "سامنےآئے": "سامنے آئے",
                               "سامنےنہیں": "سامنے نہیں",
                               "سامنےپیش": "سامنے پیش",
                               "ستمبرکو": "ستمبر کو",
                               "سرپرستی": "سر پرستی",
                               "سرحدپر": "سرحد پر",
                               "سرفرازاحمد": "سرفراز احمد",
                               "سرےسے": "سرے سے",
                               "سزادی": "سزا دی",
                               "سزاسنائی": "سزا سنائی",
                               "سعدرفیق": "سعد رفیق",
                               "سفارتخانے": "سفارت خانے",
                               "سفرکر": "سفر کر",
                               "سلسلےمیں": "سلسلے میں",
                               "سمجھتاہوں": "سمجھتا ہوں",
                               "سمجھتاہے": "سمجھتا ہے",
                               "سمجھتےہیں": "سمجھتے ہیں",
                               "سمندرمیں": "سمندر میں",
                               "سناہے": "سنا ہے",
                               "سوسے": "سو سے",
                               "سواکچھ": "سوا کچھ",
                               "سونےسے": "سونے سے",
                               "سونےکی": "سونے کی",
                               "سونےکے": "سونے کے",
                               "سپرلیگ": "سپر لیگ",
                               "سکتاہوں": "سکتا ہوں",
                               "سکتاہے": "سکتا ہے",
                               "سکتےتھے": "سکتے تھے",
                               "سکےاور": "سکے اور",
                               "سکےگی": "سکے گی",
                               "سیریزکے": "سیریز کے",
                               "سینےمیں": "سینے میں",
                               "سےآج": "سے آج",
                               "سےآزاد": "سے آزاد",
                               "سےآنے": "سے آنے",
                               "سےآپ": "سے آپ",
                               "سےآگے": "سے آگے",
                               "سےاستعفی": "سے استعفی",
                               "سےافراد": "سے افراد",
                               "سےامریکہ": "سے امریکہ",
                               "سےامریکی": "سے امریکی",
                               "سےاور": "سے اور",
                               "سےاپنا": "سے اپنا",
                               "سےاپنی": "سے اپنی",
                               "سےاپنے": "سے اپنے",
                               "سےاپیل": "سے اپیل",
                               "سےبات": "سے بات",
                               "سےباز": "سے باز",
                               "سےباہر": "سے باہر",
                               "سےبتایا": "سے بتایا",
                               "سےبجلی": "سے بجلی",
                               "سےبچ": "سے بچ",
                               "سےبچا": "سے بچا",
                               "سےبچانے": "سے بچانے",
                               "سےبڑا": "سے بڑا",
                               "سےبڑی": "سے بڑی",
                               "سےبھارت": "سے بھارت",
                               "سےبھر": "سے بھر",
                               "سےبھری": "سے بھری",
                               "سےبہت": "سے بہت",
                               "سےتعلق": "سے تعلق",
                               "سےتعلقات": "سے تعلقات",
                               "سےتقریبا": "سے تقریبا",
                               "سےتنگ": "سے تنگ",
                               "سےتھا": "سے تھا",
                               "سےجاری": "سے جاری",
                               "سےجب": "سے جب",
                               "سےجسم": "سے جسم",
                               "سےجلد": "سے جلد",
                               "سےحکومت": "سے حکومت",
                               "سےخطاب": "سے خطاب",
                               "سےخود": "سے خود",
                               "سےخون": "سے خون",
                               "سےدرخواست": "سے درخواست",
                               "سےدنیا": "سے دنیا",
                               "سےدور": "سے دور",
                               "سےدہشت": "سے دہشت",
                               "سےدیکھا": "سے دیکھا",
                               "سےرابطے": "سے رابطے",
                               "سےرجوع": "سے رجوع",
                               "سےروک": "سے روک",
                               "سےروکنے": "سے روکنے",
                               "سےسال": "سے سال",
                               "سےسب": "سے سب",
                               "سےسخت": "سے سخت",
                               "سےسوال": "سے سوال",
                               "سےشدید": "سے شدید",
                               "سےشکست": "سے شکست",
                               "سےصاف": "سے صاف",
                               "سےظاہر": "سے ظاہر",
                               "سےعلیحدگی": "سے علیحدگی",
                               "سےغیر": "سے غیر",
                               "سےفارغ": "سے فارغ",
                               "سےفرار": "سے فرار",
                               "سےفی": "سے فی",
                               "سےقاصر": "سے قاصر",
                               "سےلطف": "سے لطف",
                               "سےلیس": "سے لیس",
                               "سےلے": "سے لے",
                               "سےمتاثرہ": "سے متاثرہ",
                               "سےمحروم": "سے محروم",
                               "سےمذاکرات": "سے مذاکرات",
                               "سےمزید": "سے مزید",
                               "سےمطالبہ": "سے مطالبہ",
                               "سےمعافی": "سے معافی",
                               "سےمعلوم": "سے معلوم",
                               "سےمل": "سے مل",
                               "سےملاقات": "سے ملاقات",
                               "سےمنسلک": "سے منسلک",
                               "سےمکمل": "سے مکمل",
                               "سےنجات": "سے نجات",
                               "سےنوازا": "سے نوازا",
                               "سےنکالنے": "سے نکالنے",
                               "سےنکلنے": "سے نکلنے",
                               "سےنہ": "سے نہ",
                               "سےنہیں": "سے نہیں",
                               "سےنیچے": "سے نیچے",
                               "سےواقف": "سے واقف",
                               "سےواپس": "سے واپس",
                               "سےوہ": "سے وہ",
                               "سےپانچ": "سے پانچ",
                               "سےپاکستان": "سے پاکستان",
                               "سےپاکستانی": "سے پاکستانی",
                               "سےپر": "سے پر",
                               "سےپیدا": "سے پیدا",
                               "سےپیش": "سے پیش",
                               "سےچار": "سے چار",
                               "سےچند": "سے چند",
                               "سےکافی": "سے کافی",
                               "سےکام": "سے کام",
                               "سےکر": "سے کر",
                               "سےکسی": "سے کسی",
                               "سےکم": "سے کم",
                               "سےکو": "سے کو",
                               "سےکچھ": "سے کچھ",
                               "سےکہا": "سے کہا",
                               "سےکہہ": "سے کہہ",
                               "سےکیا": "سے کیا",
                               "سےگرفتار": "سے گرفتار",
                               "سےگزر": "سے گزر",
                               "سےگفتگو": "سے گفتگو",
                               "سےہاتھ": "سے ہاتھ",
                               "سےہزار": "سے ہزار",
                               "سےہمارے": "سے ہمارے",
                               "سےہوئی": "سے ہوئی",
                               "سےہوا": "سے ہوا",
                               "سےہٹ": "سے ہٹ",
                               "سےہی": "سے ہی",
                               "سےہیں": "سے ہیں",
                               "سےہے": "سے ہے",
                               "شاہدخاقان": "شاہد خاقان",
                               "شایداس": "شاید اس",
                               "شدیدتنقید": "شدید تنقید",
                               "شدیدزخمی": "شدید زخمی",
                               "شومیں": "شو میں",
                               "شکارہے": "شکار ہے",
                               "شہبازشریف": "شہباز شریف",
                               "شہرمیں": "شہر میں",
                               "شہرکی": "شہر کی",
                               "شہیدہو": "شہید ہو",
                               "شیئرکی": "شیئر کی",
                               "صدتک": "صد تک",
                               "صدسے": "صد سے",
                               "صدرآصف": "صدر آصف",
                               "صدراوباما": "صدر اوباما",
                               "صدرزرداری": "صدر زرداری",
                               "صدرصاحب": "صدر صاحب",
                               "صدرمشرف": "صدر مشرف",
                               "صدرپاکستان": "صدر پاکستان",
                               "صدرپرویز": "صدر پرویز",
                               "صدرکا": "صدر کا",
                               "صدرکو": "صدر کو",
                               "صوبےمیں": "صوبے میں",
                               "صوبےکے": "صوبے کے",
                               "ضیاءالحق": "ضیاء الحق",
                               "طرزعمل": "طرز عمل",
                               "طریقےسے": "طریقے سے",
                               "طیارےمیں": "طیارے میں",
                               "طیارےکے": "طیارے کے",
                               "طےشدہ": "طے شدہ",
                               "طےکر": "طے کر",
                               "ظاہرکر": "ظاہر کر",
                               "ظاہرکی": "ظاہر کی",
                               "ظاہرہے": "ظاہر ہے",
                               "عائدکی": "عائد کی",
                               "عرصےتک": "عرصے تک",
                               "عرصےمیں": "عرصے میں",
                               "علاقےمیں": "علاقے میں",
                               "علاقےکو": "علاقے کو",
                               "علاقےکے": "علاقے کے",
                               "عمراکمل": "عمر اکمل",
                               "عہدےسے": "عہدے سے",
                               "عہدےپر": "عہدے پر",
                               "غورکیا": "غور کیا",
                               "غیرضروری": "غیر ضروری",
                               "غیرملکی": "غیر ملکی",
                               "غیرملکیوں": "غیر ملکیوں",
                               "فاصلےپر": "فاصلے پر",
                               "فرارہو": "فرار ہو",
                               "فردجرم": "فرد جرم",
                               "فرماتےہیں": "فرماتے ہیں",
                               "فرمایاکہ": "فرمایا کہ",
                               "فروریء": "فروری ء",
                               "فضامیں": "فضا میں",
                               "فیصلےسے": "فیصلے سے",
                               "فیصلےکو": "فیصلے کو",
                               "قابوپانے": "قابو پانے",
                               "قرارداد": "قرار داد",
                               "قراردینے": "قرار دینے",
                               "قراردے": "قرار دے",
                               "قیدکی": "قید کی",
                               "لئےاستعمال": "لئے استعمال",
                               "لئےان": "لئے ان",
                               "لئےبہت": "لئے بہت",
                               "لئےتیار": "لئے تیار",
                               "لئےوہ": "لئے وہ",
                               "لئےکو": "لئے کو",
                               "لاکر": "لا کر",
                               "لانےکا": "لانے کا",
                               "لانےکی": "لانے کی",
                               "لانےکے": "لانے کے",
                               "لاہورمیں": "لاہور میں",
                               "لایاجا": "لایا جا",
                               "لایاگیا": "لایا گیا",
                               "لنکاکے": "لنکا کے",
                               "لوڈشیڈنگ": "لوڈ شیڈنگ",
                               "لوگربل": "لوگر بل",
                               "لکھاتھا": "لکھا تھا",
                               "لکھاکہ": "لکھا کہ",
                               "لکھتےہیں": "لکھتے ہیں",
                               "لگادی": "لگا دی",
                               "لگادیا": "لگا دیا",
                               "لگاکر": "لگا کر",
                               "لگاکہ": "لگا کہ",
                               "لگاہے": "لگا ہے",
                               "لگائےگئے": "لگائے گئے",
                               "لگانےکا": "لگانے کا",
                               "لگانےکی": "لگانے کی",
                               "لگانےکے": "لگانے کے",
                               "لگایاجا": "لگایا جا",
                               "لگایاگیا": "لگایا گیا",
                               "لگتاہے": "لگتا ہے",
                               "لگےگا": "لگے گا",
                               "لگےہیں": "لگے ہیں",
                               "لہجےمیں": "لہجے میں",
                               "لہذااس": "لہذا اس",
                               "لیاجا": "لیا جا",
                               "لیاجاتا": "لیا جاتا",
                               "لیبیاکے": "لیبیا کے",
                               "لیتےہیں": "لیتے ہیں",
                               "لیناچاہئے": "لینا چاہئے",
                               "لینڈمیں": "لینڈ میں",
                               "لینڈکی": "لینڈ کی",
                               "لینےسے": "لینے سے",
                               "لینےوالے": "لینے والے",
                               "لیےاستعمال": "لیے استعمال",
                               "لیےان": "لیے ان",
                               "لیےبہت": "لیے بہت",
                               "لیےتیار": "لیے تیار",
                               "لیےضروری": "لیے ضروری",
                               "لیےپیش": "لیے پیش",
                               "لیےیہ": "لیے یہ",
                               "لےجا": "لے جا",
                               "لےجایا": "لے جایا",
                               "لےرہی": "لے رہی",
                               "لےرہے": "لے رہے",
                               "لےلی": "لے لی",
                               "لےلیا": "لے لیا",
                               "لےگئے": "لے گئے",
                               "لےگا": "لے گا",
                               "لےگی": "لے گی",
                               "لےگیا": "لے گیا",
                               "مارچء": "مارچ ء",
                               "ماہسے": "ماہ سے",
                               "مبتلاہو": "مبتلا ہو",
                               "متحدہو": "متحد ہو",
                               "مجبورکر": "مجبور کر",
                               "مجبورکیا": "مجبور کیا",
                               "مجبورہیں": "مجبور ہیں",
                               "مجھےاس": "مجھے اس",
                               "مجھےیہ": "مجھے یہ",
                               "محمدبن": "محمد بن",
                               "محمدحفیظ": "محمد حفیظ",
                               "محمدعامر": "محمد عامر",
                               "محمدچودھری": "محمد چودھری",
                               "محمدچوہدری": "محمد چوہدری",
                               "مدمیں": "مد میں",
                               "مددسے": "مدد سے",
                               "مددملے": "مدد ملے",
                               "مددکر": "مدد کر",
                               "مددکی": "مدد کی",
                               "مددکے": "مدد کے",
                               "مددگارثابت": "مددگار ثابت",
                               "مرحلےمیں": "مرحلے میں",
                               "مزیداضافہ": "مزید اضافہ",
                               "مزیدبتایا": "مزید بتایا",
                               "مزیدکہا": "مزید کہا",
                               "مسئلےپر": "مسئلے پر",
                               "مسئلےکا": "مسئلے کا",
                               "مسئلےکو": "مسئلے کو",
                               "مسجدمیں": "مسجد میں",
                               "مسجدکے": "مسجد کے",
                               "مصرمیں": "مصر میں",
                               "مصرکے": "مصر کے",
                               "معاشرےکی": "معاشرے کی",
                               "معاشرےکے": "معاشرے کے",
                               "معاہدےپر": "معاہدے پر",
                               "معاہدےکی": "معاہدے کی",
                               "معاہدےکے": "معاہدے کے",
                               "مفادمیں": "مفاد میں",
                               "مفیدہے": "مفید ہے",
                               "مقابلےمیں": "مقابلے میں",
                               "مقاصدکے": "مقاصد کے",
                               "مقدمےمیں": "مقدمے میں",
                               "مقدمےکی": "مقدمے کی",
                               "مقررکر": "مقرر کر",
                               "مقررکیا": "مقرر کیا",
                               "ملاہے": "ملا ہے",
                               "ملتےہیں": "ملتے ہیں",
                               "ملنےوالی": "ملنے والی",
                               "ملنےوالے": "ملنے والے",
                               "ملنےپر": "ملنے پر",
                               "ملنےکے": "ملنے کے",
                               "مندہے": "مند ہے",
                               "منصوبےپر": "منصوبے پر",
                               "منصوبےکی": "منصوبے کی",
                               "منصوبےکے": "منصوبے کے",
                               "منظرمیں": "منظر میں",
                               "منظورکر": "منظور کر",
                               "منعقدہو": "منعقد ہو",
                               "موجودتھا": "موجود تھا",
                               "موجودہیں": "موجود ہیں",
                               "موجودہے": "موجود ہے",
                               "موٹرسائیکل": "موٹر سائیکل",
                               "مگراس": "مگر اس",
                               "مگرجب": "مگر جب",
                               "مگرپھر": "مگر پھر",
                               "مگرہم": "مگر ہم",
                               "مہینےمیں": "مہینے میں",
                               "میجرجنرل": "میجر جنرل",
                               "میرےخیال": "میرے خیال",
                               "میرےساتھ": "میرے ساتھ",
                               "میرےلئے": "میرے لئے",
                               "میزپر": "میز پر",
                               "میچزمیں": "میچز میں",
                               "میڈیارپورٹس": "میڈیا رپورٹس",
                               "میڈیاسے": "میڈیا سے",
                               "میڈیامیں": "میڈیا میں",
                               "میڈیانے": "میڈیا نے",
                               "میڈیاپر": "میڈیا پر",
                               "میڈیاکے": "میڈیا کے",
                               "نافذکر": "نافذ کر",
                               "نافذکرنے": "نافذ کرنے",
                               "نثارعلی": "نثار علی",
                               "نثارنے": "نثار نے",
                               "نریندرمودی": "نریندر مودی",
                               "نظرآ": "نظر آ",
                               "نظرآنے": "نظر آنے",
                               "نظرثانی": "نظر ثانی",
                               "نظرسے": "نظر سے",
                               "نظرمیں": "نظر میں",
                               "نظیربھٹو": "نظیر بھٹو",
                               "نمازجنازہ": "نماز جنازہ",
                               "نمبرپر": "نمبر پر",
                               "نمٹنےکے": "نمٹنے کے",
                               "نوازنے": "نواز نے",
                               "نوجوان": "نوجو ان",
                               "نوجوانوں": "نوجو انوں",
                               "نوربصیرت": "نور بصیرت",
                               "نومبرء": "نومبر ء",
                               "نومبرکو": "نومبر کو",
                               "نیوزکے": "نیوز کے",
                               "نےء": "نے ء",
                               "نےآج": "نے آج",
                               "نےاب": "نے اب",
                               "نےاسلام": "نے اسلام",
                               "نےاسے": "نے اسے",
                               "نےاعتراف": "نے اعتراف",
                               "نےاعلان": "نے اعلان",
                               "نےافغانستان": "نے افغانستان",
                               "نےالزام": "نے الزام",
                               "نےانکشاف": "نے انکشاف",
                               "نےانہیں": "نے انہیں",
                               "نےاور": "نے اور",
                               "نےایسا": "نے ایسا",
                               "نےبھارتی": "نے بھارتی",
                               "نےبے": "نے بے",
                               "نےتمام": "نے تمام",
                               "نےتین": "نے تین",
                               "نےجا": "نے جا",
                               "نےجس": "نے جس",
                               "نےخود": "نے خود",
                               "نےدنیا": "نے دنیا",
                               "نےدہشت": "نے دہشت",
                               "نےدیا": "نے دیا",
                               "نےدیکھا": "نے دیکھا",
                               "نےریمارکس": "نے ریمارکس",
                               "نےسابق": "نے سابق",
                               "نےسب": "نے سب",
                               "نےسوچا": "نے سوچا",
                               "نےسے": "نے سے",
                               "نےشرکت": "نے شرکت",
                               "نےصدر": "نے صدر",
                               "نےصرف": "نے صرف",
                               "نےعمران": "نے عمران",
                               "نےعوام": "نے عوام",
                               "نےفیصلہ": "نے فیصلہ",
                               "نےقومی": "نے قومی",
                               "نےلگے": "نے لگے",
                               "نےمجھ": "نے مجھ",
                               "نےمزید": "نے مزید",
                               "نےمیڈیا": "نے میڈیا",
                               "نےنہ": "نے نہ",
                               "نےنہیں": "نے نہیں",
                               "نےواضح": "نے واضح",
                               "نےوالا": "نے والا",
                               "نےوالوں": "نے والوں",
                               "نےوالی": "نے والی",
                               "نےوالے": "نے والے",
                               "نےوہ": "نے وہ",
                               "نےپاکستان": "نے پاکستان",
                               "نےپاکستانی": "نے پاکستانی",
                               "نےپر": "نے پر",
                               "نےپوچھا": "نے پوچھا",
                               "نےپہلی": "نے پہلی",
                               "نےپی": "نے پی",
                               "نےکئی": "نے کئی",
                               "نےکا": "نے کا",
                               "نےکسی": "نے کسی",
                               "نےکو": "نے کو",
                               "نےکچھ": "نے کچھ",
                               "نےگذشتہ": "نے گذشتہ",
                               "نےہر": "نے ہر",
                               "نےہمیشہ": "نے ہمیشہ",
                               "نےہمیں": "نے ہمیں",
                               "نےہی": "نے ہی",
                               "وانصاف": "و انصاف",
                               "ودیگر": "و دیگر",
                               "وشمار": "و شمار",
                               "وغریب": "و غریب",
                               "وقوم": "و قوم",
                               "وکشمیر": "و کشمیر",
                               "واقعےکی": "واقعے کی",
                               "واقعےکے": "واقعے کے",
                               "والےاداروں": "والے اداروں",
                               "والےافراد": "والے افراد",
                               "والےشخص": "والے شخص",
                               "والےکو": "والے کو",
                               "والےہیں": "والے ہیں",
                               "ورلڈٹی": "ورلڈ ٹی",
                               "وزیراطلاعات": "وزیر اطلاعات",
                               "وزیراعلی": "وزیر اعلی",
                               "وزیرخارجہ": "وزیر خارجہ",
                               "وزیرداخلہ": "وزیر داخلہ",
                               "وزیرمملکت": "وزیر مملکت",
                               "ووڈاداکارہ": "ووڈ اداکارہ",
                               "ووڈمیں": "ووڈ میں",
                               "ووڈکی": "ووڈ کی",
                               "ووڈکے": "ووڈ کے",
                               "ویسےبھی": "ویسے بھی",
                               "ویسےتو": "ویسے تو",
                               "ویڈیومیں": "ویڈیو میں",
                               "ٹوئٹرپر": "ٹوئٹر پر",
                               "پائےجاتے": "پائے جاتے",
                               "پانےوالے": "پانے والے",
                               "پانےکے": "پانے کے",
                               "پرآ": "پر آ",
                               "پرآمادہ": "پر آمادہ",
                               "پرآنے": "پر آنے",
                               "پرآپ": "پر آپ",
                               "پراثر": "پر اثر",
                               "پراس": "پر اس",
                               "پراستعمال": "پر استعمال",
                               "پراسرار": "پر اسرار",
                               "پراسی": "پر اسی",
                               "پراسے": "پر اسے",
                               "پراعتماد": "پر اعتماد",
                               "پرالزام": "پر الزام",
                               "پرامریکی": "پر امریکی",
                               "پرامن": "پر امن",
                               "پران": "پر ان",
                               "پرانہوں": "پر انہوں",
                               "پرانہیں": "پر انہیں",
                               "پراور": "پر اور",
                               "پراپنا": "پر اپنا",
                               "پراپنے": "پر اپنے",
                               "پرایک": "پر ایک",
                               "پربحث": "پر بحث",
                               "پربھارت": "پر بھارت",
                               "پربھارتی": "پر بھارتی",
                               "پربیٹھ": "پر بیٹھ",
                               "پربے": "پر بے",
                               "پرتبادلہ": "پر تبادلہ",
                               "پرتشدد": "پر تشدد",
                               "پرتو": "پر تو",
                               "پرتیار": "پر تیار",
                               "پرجاری": "پر جاری",
                               "پرجو": "پر جو",
                               "پرحملہ": "پر حملہ",
                               "پرحکومت": "پر حکومت",
                               "پرخرچ": "پر خرچ",
                               "پرخود": "پر خود",
                               "پردو": "پر دو",
                               "پردہشت": "پر دہشت",
                               "پررنز": "پر رنز",
                               "پرزور": "پر زور",
                               "پرسخت": "پر سخت",
                               "پرسوار": "پر سوار",
                               "پرسے": "پر سے",
                               "پرشدید": "پر شدید",
                               "پرعائد": "پر عائد",
                               "پرعدالت": "پر عدالت",
                               "پرعمل": "پر عمل",
                               "پرفائرنگ": "پر فائرنگ",
                               "پرفائز": "پر فائز",
                               "پرقائم": "پر قائم",
                               "پرلگا": "پر لگا",
                               "پرمبنی": "پر مبنی",
                               "پرمجبور": "پر مجبور",
                               "پرمشتمل": "پر مشتمل",
                               "پرمنتقل": "پر منتقل",
                               "پرموجود": "پر موجود",
                               "پرمکمل": "پر مکمل",
                               "پرمیں": "پر میں",
                               "پرنہ": "پر نہ",
                               "پرواضح": "پر واضح",
                               "پرواقع": "پر واقع",
                               "پروزیر": "پر وزیر",
                               "پرپابندی": "پر پابندی",
                               "پرپورا": "پر پورا",
                               "پرپولیس": "پر پولیس",
                               "پرکام": "پر کام",
                               "پرکو": "پر کو",
                               "پرکچھ": "پر کچھ",
                               "پرکی": "پر کی",
                               "پرہاتھ": "پر ہاتھ",
                               "پرہم": "پر ہم",
                               "پرہو": "پر ہو",
                               "پرہی": "پر ہی",
                               "پرہیز": "پر ہیز",
                               "پرہے": "پر ہے",
                               "پریہ": "پر یہ",
                               "پرویزالہی": "پرویز الہی",
                               "پرویزمشرف": "پرویز مشرف",
                               "پرویزکی": "پرویز کی",
                               "پسندکر": "پسند کر",
                               "پشاورزلمی": "پشاور زلمی",
                               "پشاورمیں": "پشاور میں",
                               "پشاورکے": "پشاور کے",
                               "پوراکر": "پورا کر",
                               "پوراکرنے": "پورا کرنے",
                               "پوچھاکہ": "پوچھا کہ",
                               "پوچھاگیا": "پوچھا گیا",
                               "پڑاتھا": "پڑا تھا",
                               "پڑاہے": "پڑا ہے",
                               "پڑتاہے": "پڑتا ہے",
                               "پڑےگی": "پڑے گی",
                               "پکڑکر": "پکڑ کر",
                               "پھراس": "پھر اس",
                               "پھراسے": "پھر اسے",
                               "پھران": "پھر ان",
                               "پھرایک": "پھر ایک",
                               "پھربھی": "پھر بھی",
                               "پھرسے": "پھر سے",
                               "پھروہ": "پھر وہ",
                               "پھریہ": "پھر یہ",
                               "پہلےتو": "پہلے تو",
                               "پہلےسے": "پہلے سے",
                               "پہلےہی": "پہلے ہی",
                               "پہنچادیا": "پہنچا دیا",
                               "پہنچاہے": "پہنچا ہے",
                               "پہنچنےکے": "پہنچنے کے",
                               "پہنچےتو": "پہنچے تو",
                               "پیدانہیں": "پیدا نہیں",
                               "پیداہو": "پیدا ہو",
                               "پیداہوئی": "پیدا ہوئی",
                               "پیداہوئے": "پیدا ہوئے",
                               "پیداہوا": "پیدا ہوا",
                               "پیداہوتا": "پیدا ہوتا",
                               "پیداہوتی": "پیدا ہوتی",
                               "پیرکو": "پیر کو",
                               "پیرکے": "پیر کے",
                               "پینےسے": "پینے سے",
                               "پینےکے": "پینے کے",
                               "چارسال": "چار سال",
                               "چاہئےاور": "چاہئے اور",
                               "چاہئےتھا": "چاہئے تھا",
                               "چاہئےکہ": "چاہئے کہ",
                               "چاہتاتھا": "چاہتا تھا",
                               "چاہتاہے": "چاہتا ہے",
                               "چاہیےاور": "چاہیے اور",
                               "چاہیےکہ": "چاہیے کہ",
                               "چلاکہ": "چلا کہ",
                               "چلاگیا": "چلا گیا",
                               "چلتاہے": "چلتا ہے",
                               "چلےجاتے": "چلے جاتے",
                               "چندماہ": "چند ماہ",
                               "چھوڑکر": "چھوڑ کر",
                               "چیئرمین": "چیئر مین",
                               "چیزہے": "چیز ہے",
                               "ڈالرتقریبا": "ڈالر تقریبا",
                               "ڈالرکا": "ڈالر کا",
                               "ڈالرکے": "ڈالر کے",
                               "ڈالنےکی": "ڈالنے کی",
                               "ڈاکٹرمحمد": "ڈاکٹر محمد",
                               "ڈونلڈٹرمپ": "ڈونلڈ ٹرمپ",
                               "کئےبغیر": "کئے بغیر",
                               "کئےتھے": "کئے تھے",
                               "کئےجاتے": "کئے جاتے",
                               "کئےگئے": "کئے گئے",
                               "کئےہوئے": "کئے ہوئے",
                               "کاآخری": "کا آخری",
                               "کاآغاز": "کا آغاز",
                               "کااثر": "کا اثر",
                               "کااختیار": "کا اختیار",
                               "کااس": "کا اس",
                               "کااصل": "کا اصل",
                               "کااطلاق": "کا اطلاق",
                               "کااعزاز": "کا اعزاز",
                               "کاامکان": "کا امکان",
                               "کاانتظام": "کا انتظام",
                               "کاانعقاد": "کا انعقاد",
                               "کااور": "کا اور",
                               "کااپنا": "کا اپنا",
                               "کااہم": "کا اہم",
                               "کاباعث": "کا باعث",
                               "کابحران": "کا بحران",
                               "کابنیادی": "کا بنیادی",
                               "کابڑا": "کا بڑا",
                               "کابہت": "کا بہت",
                               "کابہترین": "کا بہترین",
                               "کابیان": "کا بیان",
                               "کابیٹا": "کا بیٹا",
                               "کاتجربہ": "کا تجربہ",
                               "کاتجزیہ": "کا تجزیہ",
                               "کاتحفظ": "کا تحفظ",
                               "کاتذکرہ": "کا تذکرہ",
                               "کاتصور": "کا تصور",
                               "کاتعلق": "کا تعلق",
                               "کاتعین": "کا تعین",
                               "کاتو": "کا تو",
                               "کاتھا": "کا تھا",
                               "کاتیل": "کا تیل",
                               "کاجائزہ": "کا جائزہ",
                               "کاجواب": "کا جواب",
                               "کاحامل": "کا حامل",
                               "کاحصول": "کا حصول",
                               "کاحصہ": "کا حصہ",
                               "کاحق": "کا حق",
                               "کاحوالہ": "کا حوالہ",
                               "کاحکم": "کا حکم",
                               "کاخاتمہ": "کا خاتمہ",
                               "کاخطرہ": "کا خطرہ",
                               "کاخواب": "کا خواب",
                               "کاخون": "کا خون",
                               "کاخیال": "کا خیال",
                               "کادائرہ": "کا دائرہ",
                               "کادفاع": "کا دفاع",
                               "کادل": "کا دل",
                               "کادن": "کا دن",
                               "کادور": "کا دور",
                               "کادورہ": "کا دورہ",
                               "کادوسرا": "کا دوسرا",
                               "کاذریعہ": "کا ذریعہ",
                               "کاذمہ": "کا ذمہ",
                               "کاذکر": "کا ذکر",
                               "کارجحان": "کا رجحان",
                               "کارس": "کا رس",
                               "کارنگ": "کا رنگ",
                               "کارویہ": "کا رویہ",
                               "کاریکارڈ": "کا ریکارڈ",
                               "کازیادہ": "کا زیادہ",
                               "کاسامان": "کا سامان",
                               "کاسب": "کا سب",
                               "کاسر": "کا سر",
                               "کاسفر": "کا سفر",
                               "کاسلسلہ": "کا سلسلہ",
                               "کاسہارا": "کا سہارا",
                               "کاشمار": "کا شمار",
                               "کاشوق": "کا شوق",
                               "کاشکریہ": "کا شکریہ",
                               "کاطریقہ": "کا طریقہ",
                               "کاعزم": "کا عزم",
                               "کاعندیہ": "کا عندیہ",
                               "کافائدہ": "کا فائدہ",
                               "کافرض": "کا فرض",
                               "کافی": "کا فی",
                               "کاقتل": "کا قتل",
                               "کاقیام": "کا قیام",
                               "کامالک": "کا مالک",
                               "کامرکز": "کا مرکز",
                               "کامطالبہ": "کا مطالبہ",
                               "کامطالعہ": "کا مطالعہ",
                               "کامطلب": "کا مطلب",
                               "کامظاہرہ": "کا مظاہرہ",
                               "کامعاہدہ": "کا معاہدہ",
                               "کامقصد": "کا مقصد",
                               "کامنہ": "کا منہ",
                               "کاموقع": "کا موقع",
                               "کاموقف": "کا موقف",
                               "کانشانہ": "کا نشانہ",
                               "کانظام": "کا نظام",
                               "کانعرہ": "کا نعرہ",
                               "کانقصان": "کا نقصان",
                               "کانوٹس": "کا نوٹس",
                               "کانہیں": "کا نہیں",
                               "کانیا": "کا نیا",
                               "کاواحد": "کا واحد",
                               "کاواقعہ": "کا واقعہ",
                               "کاوجود": "کا وجود",
                               "کاوزن": "کا وزن",
                               "کاوعدہ": "کا وعدہ",
                               "کاپاکستان": "کا پاکستان",
                               "کاپورا": "کا پورا",
                               "کاپیغام": "کا پیغام",
                               "کاچمچ": "کا چمچ",
                               "کاچمچہ": "کا چمچہ",
                               "کاچہرہ": "کا چہرہ",
                               "کاکام": "کا کام",
                               "کاکردار": "کا کردار",
                               "کاکو": "کا کو",
                               "کاکہا": "کا کہا",
                               "کاہدف": "کا ہدف",
                               "کاہو": "کا ہو",
                               "کاہی": "کا ہی",
                               "کاہے": "کا ہے",
                               "کارنہیں": "کار نہیں",
                               "کارکر": "کار کر",
                               "کارکیا": "کار کیا",
                               "کارکے": "کار کے",
                               "کرآپ": "کر آپ",
                               "کراس": "کر اس",
                               "کرانا": "کر انا",
                               "کرانہیں": "کر انہیں",
                               "کرانے": "کر انے",
                               "کراور": "کر اور",
                               "کرخود": "کر خود",
                               "کردئیے": "کر دئیے",
                               "کردیئے": "کر دیئے",
                               "کردینا": "کر دینا",
                               "کردینے": "کر دینے",
                               "کردیں": "کر دیں",
                               "کررکھ": "کر رکھ",
                               "کررکھی": "کر رکھی",
                               "کررہے": "کر رہے",
                               "کرسکتا": "کر سکتا",
                               "کرلیا": "کر لیا",
                               "کرلیتے": "کر لیتے",
                               "کرنہیں": "کر نہیں",
                               "کروہ": "کر وہ",
                               "کرپاکستان": "کر پاکستان",
                               "کرچکا": "کر چکا",
                               "کرچکی": "کر چکی",
                               "کرڈالا": "کر ڈالا",
                               "کرکام": "کر کام",
                               "کرکہا": "کر کہا",
                               "کرگئے": "کر گئے",
                               "کرہی": "کر ہی",
                               "کریہ": "کر یہ",
                               "کرایاجا": "کرایا جا",
                               "کرایاگیا": "کرایا گیا",
                               "کرتارہا": "کرتا رہا",
                               "کردارادا": "کردار ادا",
                               "کرنااور": "کرنا اور",
                               "کرنابھی": "کرنا بھی",
                               "کرناتھا": "کرنا تھا",
                               "کرناپڑ": "کرنا پڑ",
                               "کرناپڑتا": "کرنا پڑتا",
                               "کرناپڑے": "کرنا پڑے",
                               "کرناچاہتی": "کرنا چاہتی",
                               "کرناچاہتے": "کرنا چاہتے",
                               "کرنےاور": "کرنے اور",
                               "کرنےلگے": "کرنے لگے",
                               "کرنےوالوں": "کرنے والوں",
                               "کرنےوالی": "کرنے والی",
                               "کروڑعوام": "کروڑ عوام",
                               "کروڑڈالر": "کروڑ ڈالر",
                               "کرےتو": "کرے تو",
                               "کرےکہ": "کرے کہ",
                               "کرےگا": "کرے گا",
                               "کرےگی": "کرے گی",
                               "کشمیراور": "کشمیر اور",
                               "کشمیرمیں": "کشمیر میں",
                               "کشمیرکے": "کشمیر کے",
                               "کشمیریوںکو": "کشمیریوں کو",
                               "کشمیریوںکی": "کشمیریوں کی",
                               "کلومیٹر": "کلو میٹر",
                               "کمزورہو": "کمزور ہو",
                               "کوآگ": "کو آگ",
                               "کوآگاہ": "کو آگاہ",
                               "کوآگے": "کو آگے",
                               "کواب": "کو اب",
                               "کواسلام": "کو اسلام",
                               "کواعتماد": "کو اعتماد",
                               "کوامریکہ": "کو امریکہ",
                               "کوامریکی": "کو امریکی",
                               "کوان": "کو ان",
                               "کوانٹرویو": "کو انٹرویو",
                               "کواور": "کو اور",
                               "کواپنا": "کو اپنا",
                               "کواپنی": "کو اپنی",
                               "کواچھی": "کو اچھی",
                               "کوبتایا": "کو بتایا",
                               "کوبحال": "کو بحال",
                               "کوبرقرار": "کو برقرار",
                               "کوبند": "کو بند",
                               "کوبچانے": "کو بچانے",
                               "کوبھارت": "کو بھارت",
                               "کوبے": "کو بے",
                               "کوتباہ": "کو تباہ",
                               "کوتبدیل": "کو تبدیل",
                               "کوتحفظ": "کو تحفظ",
                               "کوترجیح": "کو ترجیح",
                               "کوجاری": "کو جاری",
                               "کوجب": "کو جب",
                               "کوجس": "کو جس",
                               "کوجنم": "کو جنم",
                               "کوحاصل": "کو حاصل",
                               "کوحراست": "کو حراست",
                               "کوحل": "کو حل",
                               "کوحکم": "کو حکم",
                               "کوختم": "کو ختم",
                               "کوخط": "کو خط",
                               "کوخود": "کو خود",
                               "کوخوش": "کو خوش",
                               "کودرپیش": "کو درپیش",
                               "کودنیا": "کو دنیا",
                               "کودو": "کو دو",
                               "کودوبارہ": "کو دوبارہ",
                               "کودور": "کو دور",
                               "کودی": "کو دی",
                               "کودیکھا": "کو دیکھا",
                               "کودیکھتے": "کو دیکھتے",
                               "کودیکھنے": "کو دیکھنے",
                               "کوزندہ": "کو زندہ",
                               "کوسب": "کو سب",
                               "کوسخت": "کو سخت",
                               "کوسزا": "کو سزا",
                               "کوسمجھنے": "کو سمجھنے",
                               "کوشامل": "کو شامل",
                               "کوصاف": "کو صاف",
                               "کوصرف": "کو صرف",
                               "کوطلب": "کو طلب",
                               "کوقبول": "کو قبول",
                               "کوقومی": "کو قومی",
                               "کولے": "کو لے",
                               "کومتاثر": "کو متاثر",
                               "کومحفوظ": "کو محفوظ",
                               "کومدنظر": "کو مدنظر",
                               "کوملک": "کو ملک",
                               "کومکمل": "کو مکمل",
                               "کومیں": "کو میں",
                               "کوناکام": "کو ناکام",
                               "کونظر": "کو نظر",
                               "کووزیر": "کو وزیر",
                               "کوووٹ": "کو ووٹ",
                               "کووہ": "کو وہ",
                               "کوپاکستان": "کو پاکستان",
                               "کوپتہ": "کو پتہ",
                               "کوپسند": "کو پسند",
                               "کوپورا": "کو پورا",
                               "کوپہلے": "کو پہلے",
                               "کوچاہئے": "کو چاہئے",
                               "کوچاہیے": "کو چاہیے",
                               "کوچھوڑ": "کو چھوڑ",
                               "کوکبھی": "کو کبھی",
                               "کوکس": "کو کس",
                               "کوکسی": "کو کسی",
                               "کوکمزور": "کو کمزور",
                               "کوکنٹرول": "کو کنٹرول",
                               "کوکو": "کو کو",
                               "کوکہا": "کو کہا",
                               "کوگرفتار": "کو گرفتار",
                               "کوہدایت": "کو ہدایت",
                               "کوہلاک": "کو ہلاک",
                               "کوہم": "کو ہم",
                               "کوہمیشہ": "کو ہمیشہ",
                               "کوہو": "کو ہو",
                               "کوہے": "کو ہے",
                               "کویاد": "کو یاد",
                               "کویقین": "کو یقین",
                               "کویہ": "کو یہ",
                               "کپورنے": "کپور نے",
                               "کھاتےہیں": "کھاتے ہیں",
                               "کھانےپینے": "کھانے پینے",
                               "کھانےکی": "کھانے کی",
                               "کھانےکے": "کھانے کے",
                               "کھڑاہو": "کھڑا ہو",
                               "کھڑےہو": "کھڑے ہو",
                               "کھیلاجا": "کھیلا جا",
                               "کہء": "کہ ء",
                               "کہاتھا": "کہا تھا",
                               "کہاجاتا": "کہا جاتا",
                               "کیاان": "کیا ان",
                               "کیابلکہ": "کیا بلکہ",
                               "کیاتو": "کیا تو",
                               "کیاجا": "کیا جا",
                               "کیاجائیگا": "کیا جائیگا",
                               "کیاجاس": "کیا جاس",
                               "کیاجانا": "کیا جانا",
                               "کیاجب": "کیا جب",
                               "کیاجس": "کیا جس",
                               "کیاجو": "کیا جو",
                               "کیالیکن": "کیا لیکن",
                               "کیاکر": "کیا کر",
                               "کیاہو": "کیا ہو",
                               "کیلئےاس": "کیلئے اس",
                               "کیلئےاستعمال": "کیلئے استعمال",
                               "کیلئےپاکستان": "کیلئے پاکستان",
                               "کینسرکے": "کینسر کے",
                               "کیوایم": "کیو ایم",
                               "کیےجا": "کیے جا",
                               "کیےجائیں": "کیے جائیں",
                               "کیےجاتے": "کیے جاتے",
                               "کیےگئے": "کیے گئے",
                               "کیےہیں": "کیے ہیں",
                               "کےآخر": "کے آخر",
                               "کےاتحاد": "کے اتحاد",
                               "کےاجلاس": "کے اجلاس",
                               "کےاحکامات": "کے احکامات",
                               "کےاختتام": "کے اختتام",
                               "کےاخراجات": "کے اخراجات",
                               "کےاراکین": "کے اراکین",
                               "کےاستحکام": "کے استحکام",
                               "کےاستعمال": "کے استعمال",
                               "کےاسے": "کے اسے",
                               "کےاعتبار": "کے اعتبار",
                               "کےاعلان": "کے اعلان",
                               "کےاعلی": "کے اعلی",
                               "کےاقدامات": "کے اقدامات",
                               "کےامراض": "کے امراض",
                               "کےامیدوار": "کے امیدوار",
                               "کےامیر": "کے امیر",
                               "کےان": "کے ان",
                               "کےانتخاب": "کے انتخاب",
                               "کےانتخابات": "کے انتخابات",
                               "کےانتقال": "کے انتقال",
                               "کےانہیں": "کے انہیں",
                               "کےاوقات": "کے اوقات",
                               "کےاپنی": "کے اپنی",
                               "کےاپنے": "کے اپنے",
                               "کےاہلکار": "کے اہلکار",
                               "کےاہلکاروں": "کے اہلکاروں",
                               "کےاہم": "کے اہم",
                               "کےایٹمی": "کے ایٹمی",
                               "کےبانی": "کے بانی",
                               "کےباہر": "کے باہر",
                               "کےبجا": "کے بجا",
                               "کےبحران": "کے بحران",
                               "کےبدلے": "کے بدلے",
                               "کےبعض": "کے بعض",
                               "کےبغیر": "کے بغیر",
                               "کےبل": "کے بل",
                               "کےبنیادی": "کے بنیادی",
                               "کےبھائی": "کے بھائی",
                               "کےبیانات": "کے بیانات",
                               "کےبیشتر": "کے بیشتر",
                               "کےبے": "کے بے",
                               "کےترجمان": "کے ترجمان",
                               "کےتعاون": "کے تعاون",
                               "کےتعلقات": "کے تعلقات",
                               "کےتمام": "کے تمام",
                               "کےتناظر": "کے تناظر",
                               "کےتیل": "کے تیل",
                               "کےجج": "کے جج",
                               "کےجذبات": "کے جذبات",
                               "کےجرم": "کے جرم",
                               "کےجو": "کے جو",
                               "کےجواب": "کے جواب",
                               "کےحامی": "کے حامی",
                               "کےحساب": "کے حساب",
                               "کےحصول": "کے حصول",
                               "کےحصے": "کے حصے",
                               "کےحق": "کے حق",
                               "کےحل": "کے حل",
                               "کےحملے": "کے حملے",
                               "کےحکام": "کے حکام",
                               "کےخاتمہ": "کے خاتمہ",
                               "کےخاتمے": "کے خاتمے",
                               "کےخاندان": "کے خاندان",
                               "کےخطرے": "کے خطرے",
                               "کےخواب": "کے خواب",
                               "کےخیال": "کے خیال",
                               "کےدارالحکومت": "کے دارالحکومت",
                               "کےدرد": "کے درد",
                               "کےدروازے": "کے دروازے",
                               "کےدفتر": "کے دفتر",
                               "کےدل": "کے دل",
                               "کےدلوں": "کے دلوں",
                               "کےدماغ": "کے دماغ",
                               "کےدو": "کے دو",
                               "کےدور": "کے دور",
                               "کےدورہ": "کے دورہ",
                               "کےدونوں": "کے دونوں",
                               "کےذرائع": "کے ذرائع",
                               "کےذہن": "کے ذہن",
                               "کےرد": "کے رد",
                               "کےروز": "کے روز",
                               "کےرہائشی": "کے رہائشی",
                               "کےزمانے": "کے زمانے",
                               "کےزیادہ": "کے زیادہ",
                               "کےسابق": "کے سابق",
                               "کےساتھی": "کے ساتھی",
                               "کےساتھیوں": "کے ساتھیوں",
                               "کےسارے": "کے سارے",
                               "کےسپرد": "کے سپرد",
                               "کےسیاسی": "کے سیاسی",
                               "کےسینئر": "کے سینئر",
                               "کےسیکرٹری": "کے سیکرٹری",
                               "کےسے": "کے سے",
                               "کےشریک": "کے شریک",
                               "کےشعبہ": "کے شعبہ",
                               "کےشعبے": "کے شعبے",
                               "کےشوہر": "کے شوہر",
                               "کےشکار": "کے شکار",
                               "کےشہر": "کے شہر",
                               "کےصدر": "کے صدر",
                               "کےضلع": "کے ضلع",
                               "کےعادی": "کے عادی",
                               "کےعلاج": "کے علاج",
                               "کےعلاقوں": "کے علاقوں",
                               "کےعلاقہ": "کے علاقہ",
                               "کےعلاقے": "کے علاقے",
                               "کےعوام": "کے عوام",
                               "کےعہدے": "کے عہدے",
                               "کےغیر": "کے غیر",
                               "کےفرائض": "کے فرائض",
                               "کےفروغ": "کے فروغ",
                               "کےفوری": "کے فوری",
                               "کےفیصلے": "کے فیصلے",
                               "کےقانون": "کے قانون",
                               "کےقبضے": "کے قبضے",
                               "کےقتل": "کے قتل",
                               "کےقریبی": "کے قریبی",
                               "کےقیام": "کے قیام",
                               "کےلحاظ": "کے لحاظ",
                               "کےلواحقین": "کے لواحقین",
                               "کےمابین": "کے مابین",
                               "کےمتعلق": "کے متعلق",
                               "کےمختلف": "کے مختلف",
                               "کےمریضوں": "کے مریضوں",
                               "کےمسئلے": "کے مسئلے",
                               "کےمسائل": "کے مسائل",
                               "کےمستقبل": "کے مستقبل",
                               "کےمسلمانوں": "کے مسلمانوں",
                               "کےمشہور": "کے مشہور",
                               "کےمشیر": "کے مشیر",
                               "کےمعاملات": "کے معاملات",
                               "کےمعاملے": "کے معاملے",
                               "کےمعاہدے": "کے معاہدے",
                               "کےمعروف": "کے معروف",
                               "کےمفاد": "کے مفاد",
                               "کےمفادات": "کے مفادات",
                               "کےمقابلے": "کے مقابلے",
                               "کےمقام": "کے مقام",
                               "کےملازمین": "کے ملازمین",
                               "کےملک": "کے ملک",
                               "کےمنافی": "کے منافی",
                               "کےمنصوبے": "کے منصوبے",
                               "کےموقع": "کے موقع",
                               "کےمیدان": "کے میدان",
                               "کےمیں": "کے میں",
                               "کےنائب": "کے نائب",
                               "کےنظام": "کے نظام",
                               "کےنعرے": "کے نعرے",
                               "کےنفاذ": "کے نفاذ",
                               "کےنمائندوں": "کے نمائندوں",
                               "کےنمائندے": "کے نمائندے",
                               "کےوالد": "کے والد",
                               "کےوزیر": "کے وزیر",
                               "کےوقت": "کے وقت",
                               "کےپانی": "کے پانی",
                               "کےپر": "کے پر",
                               "کےپروگرام": "کے پروگرام",
                               "کےپس": "کے پس",
                               "کےپیش": "کے پیش",
                               "کےپیٹ": "کے پیٹ",
                               "کےپیچھے": "کے پیچھے",
                               "کےچمچ": "کے چمچ",
                               "کےچیئرمین": "کے چیئرمین",
                               "کےڈائریکٹر": "کے ڈائریکٹر",
                               "کےکارکنوں": "کے کارکنوں",
                               "کےکسی": "کے کسی",
                               "کےکنارے": "کے کنارے",
                               "کےکو": "کے کو",
                               "کےکہ": "کے کہ",
                               "کےکہنے": "کے کہنے",
                               "کےکینسر": "کے کینسر",
                               "کےکے": "کے کے",
                               "کےگھر": "کے گھر",
                               "کےگھروں": "کے گھروں",
                               "کےہاتھ": "کے ہاتھ",
                               "کےہاتھوں": "کے ہاتھوں",
                               "کےہم": "کے ہم",
                               "کےہمراہ": "کے ہمراہ",
                               "کےہی": "کے ہی",
                               "کےہیں": "کے ہیں",
                               "گئےاور": "گئے اور",
                               "گئےجس": "گئے جس",
                               "گئےلیکن": "گئے لیکن",
                               "گئےکہ": "گئے کہ",
                               "گااس": "گا اس",
                               "گاجس": "گا جس",
                               "گالیکن": "گا لیکن",
                               "گامگر": "گا مگر",
                               "گاکہ": "گا کہ",
                               "گرکر": "گر کر",
                               "گرفتارکر": "گرفتار کر",
                               "گرفتاریکے": "گرفتاری کے",
                               "گرنےسے": "گرنے سے",
                               "گزرنےکے": "گزرنے کے",
                               "گفتگومیں": "گفتگو میں",
                               "گفتگوکر": "گفتگو کر",
                               "گلےمیں": "گلے میں",
                               "گنازیادہ": "گنا زیادہ",
                               "گورنرپنجاب": "گورنر پنجاب",
                               "گھرمیں": "گھر میں",
                               "گھروالوں": "گھر والوں",
                               "گھرپر": "گھر پر",
                               "گھرکا": "گھر کا",
                               "گھنٹےتک": "گھنٹے تک",
                               "گھیرےمیں": "گھیرے میں",
                               "گیااس": "گیا اس",
                               "گیاتاہم": "گیا تاہم",
                               "گیاتو": "گیا تو",
                               "گیاجس": "گیا جس",
                               "گیاجو": "گیا جو",
                               "گیاجہاں": "گیا جہاں",
                               "گیالیکن": "گیا لیکن",
                               "گیامگر": "گیا مگر",
                               "گیاہو": "گیا ہو",
                               "گےاور": "گے اور",
                               "گےلیکن": "گے لیکن",
                               "ہربار": "ہر بار",
                               "ہرجگہ": "ہر جگہ",
                               "ہرروز": "ہر روز",
                               "ہرشخص": "ہر شخص",
                               "ہرطرح": "ہر طرح",
                               "ہرممکن": "ہر ممکن",
                               "ہرچیز": "ہر چیز",
                               "ہرکسی": "ہر کسی",
                               "ہرکو": "ہر کو",
                               "ہرگز": "ہر گز",
                               "ہرگزنہیں": "ہرگز نہیں",
                               "ہزارافراد": "ہزار افراد",
                               "ہزارروپے": "ہزار روپے",
                               "ہزارڈالر": "ہزار ڈالر",
                               "ہفتےکے": "ہفتے کے",
                               "ہمارےحکمران": "ہمارے حکمران",
                               "ہمارےساتھ": "ہمارے ساتھ",
                               "ہمارےلئے": "ہمارے لئے",
                               "ہمارےپاس": "ہمارے پاس",
                               "ہواس": "ہو اس",
                               "ہواور": "ہو اور",
                               "ہوتو": "ہو تو",
                               "ہوجا": "ہو جا",
                               "ہوجائیں": "ہو جائیں",
                               "ہوجاتا": "ہو جاتا",
                               "ہوجانے": "ہو جانے",
                               "ہورہا": "ہو رہا",
                               "ہورہی": "ہو رہی",
                               "ہورہے": "ہو رہے",
                               "ہوسکا": "ہو سکا",
                               "ہوسکتا": "ہو سکتا",
                               "ہوسکتی": "ہو سکتی",
                               "ہوسکی": "ہو سکی",
                               "ہوسکیں": "ہو سکیں",
                               "ہوچکا": "ہو چکا",
                               "ہوچکی": "ہو چکی",
                               "ہوچکے": "ہو چکے",
                               "ہوئےاسے": "ہوئے اسے",
                               "ہوئےایک": "ہوئے ایک",
                               "ہوئےبتایا": "ہوئے بتایا",
                               "ہوئےبھی": "ہوئے بھی",
                               "ہوئےتو": "ہوئے تو",
                               "ہوئےتھے": "ہوئے تھے",
                               "ہوئےوزیر": "ہوئے وزیر",
                               "ہوئےکیا": "ہوئے کیا",
                               "ہوئےہے": "ہوئے ہے",
                               "ہواتو": "ہوا تو",
                               "ہواتھا": "ہوا تھا",
                               "ہواجب": "ہوا جب",
                               "ہوامیں": "ہوا میں",
                               "ہواکہ": "ہوا کہ",
                               "ہوتاجا": "ہوتا جا",
                               "ہوتےتو": "ہوتے تو",
                               "ہوتےتھے": "ہوتے تھے",
                               "ہوتےہوئے": "ہوتے ہوئے",
                               "ہوتےہی": "ہوتے ہی",
                               "ہوناشروع": "ہونا شروع",
                               "ہےاب": "ہے اب",
                               "ہےاگر": "ہے اگر",
                               "ہےایک": "ہے ایک",
                               "ہےتاہم": "ہے تاہم",
                               "ہےجس": "ہے جس",
                               "ہےمیں": "ہے میں",
                               "ہےوہ": "ہے وہ",
                               "ہےپاکستان": "ہے پاکستان",
                               "ہےہم": "ہے ہم",
                               "ہےیہ": "ہے یہ",
                               "یاان": "یا ان",
                               "یاتو": "یا تو",
                               "یانہ": "یا نہ",
                               "یاپھر": "یا پھر",
                               "یادرہے": "یاد رہے",
                               "نےایک": "نے ایک",
                               "اترنےکا": "اترنے کا",
                               "کااعلان": "کا اعلان",
                               "اوراحتجاجی": "اور احتجاجی",
                               "کاوہ": "کاوہ",
                               "عرصےسے": "عرصے سے",
                               "سےرکا": "سے رکا",
                               "رکاہوا": "رکا ہوا",
                               "بعددونوں": "بعد دونوں",
                               "اسےدوبارہ": "اسے دوبارہ",
                               "کرنےکا": "کرنے کا",
                               "نےسانحہ": "نے سانحہ",
                               "بعددھرنا": "بعد دھرنا",
                               "دھرناختم": "دھرنا ختم",
                               "دیاتھا": "دیا تھا",
                               "چارحلقوں": "چار حلقوں",
                               "کےمطالبے": "کے مطالبے",
                               "اےکی": "اے کی",
                               "سامنےآنے": "سامنے آنے",
                               "بعدعمران": "بعد عمران",
                               "سجانےکا": "سجانے کا",
                               "کافیصلہ": "کا فیصلہ",
                               "لیاہے": "لیا ہے",
                               "وقفےکے": "وقفے کے",
                               "کےدوران": "کے دوران",
                               "ہوگئےتھے": "ہوگئے تھے",
                               "نےبھی": "نے بھی",
                               "کےکام": "کے کام",
                               "پرواپسی": "پر واپسی",
                               "ہےاور": "ہے اور",
                               "اورجنوری": "اور جنوری",
                               "کودھرنا": "کو دھرنا",
                               "دھرناورکرز": "دھرنا ورکرز",
                               "ورکرزکنونشن": "ورکرز کنونشن",
                               "جوتحریک": "جو تحریک",
                               "نےجوڈیشل": "نے جوڈیشل",
                               "لیےحکومت": "لیے حکومت",
                               "دےرکھی": "دے رکھی",
                               "کےمطابق": "کے مطابق",
                               "بعدملک": "بعد ملک",
                               "کےدیگر": "کے دیگر",
                               "دیگرحصوں": "دیگر حصوں",
                               "اشارےبھی": "اشارے بھی",
                               "دیدتھے": "دید تھے",
                               "نےتقریر": "نے تقریر",
                               "تقریرکم": "تقریر کم",
                               "اورہاتھوں": "اور ہاتھوں",
                               "اشارےزیادہ": "اشارے زیادہ",
                               "کئےوہ": "کئے وہ",
                               "کوزبان": "کو زبان",
                               "کےاشاروں": "کے اشاروں",
                               "سےبھی": "سے بھی",
                               "دیتےرہے": "دیتے رہے",
                               "سزادل": "سزا دل",
                               "وانےکیلئے": "وانے کیلئے",
                               "کیلئےپر": "کیلئے پر",
                               "پراسکیوشن": "پر اسکیوشن",
                               "پرکیری": "پر کیری",
                               "کےتحفظات": "کے تحفظات",
                               "دیگردہشت": "دیگر دہشت",
                               "نےبہتری": "نے بہتری",
                               "معاملےپر": "معاملے پر",
                               "پرپاکستان": "پر پاکستان",
                               "رہاامریکہ": "رہا امریکہ",
                               "کےافغانستان": "کے افغانستان",
                               "سےانخلاء": "سے انخلاء",
                               "انخلاءکے": "انخلاء کے",
                               "خطےمیں": "خطے میں",
                               "کیلئےاختلافات": "کیلئے اختلافات",
                               "اورافغانستان": "اور افغانستان",
                               "ملافضل": "ملا فضل",
                               "کےنصاب": "کے نصاب",
                               "کوازسر": "کو ازسر",
                               "ازسرنو": "ازسر نو",
                               "نومرتب": "نو مرتب",
                               "کااحوال": "کا احوال",
                               "آبادقدرت": "آباد قدرت",
                               "نیوزامریکی": "نیوز امریکی",
                               "قراردیا": "قرار دیا",
                               "دیاجا": "دیا جا",
                               "بعدکیری": "بعد کیری",
                               "آنااس": "آنا اس",
                               "خاطرپاکستان": "خاطر پاکستان",
                               "اورانڈیا": "اور انڈیا",
                               "انڈیاکے": "انڈیا کے",
                               "کےاختلافات": "کے اختلافات",
                               "کاخواہش": "کا خواہش",
                               "نےاپنے": "نے اپنے",
                               "اپنےدورہ": "اپنے دورہ",
                               "اوروزارت": "اور وزارت",
                               "سےملاقاتوں": "سے ملاقاتوں",
                               "کااظہار": "کا اظہار",
                               "کیاکہ": "کیا کہ",
                               "کےانخلاء": "کے انخلاء",
                               "برقراررہے": "برقرار رہے",
                               "رہےاور": "رہے اور",
                               "اوردہشت": "اور دہشت",
                               "کےممالک": "کے ممالک",
                               "کےاندرونی": "کے اندرونی",
                               "کےحوالے": "کے حوالے",
                               "حوالےسے": "حوالے سے",
                               "سےاہم": "سے اہم",
                               "خصوصاپاکستان": "خصوصا پاکستان",
                               "انڈیااور": "انڈیا اور",
                               "کوکم": "کو کم",
                               "گیاکہ": "گیا کہ",
                               "ناگزیرہے": "ناگزیر ہے",
                               "سےانڈیا": "سے انڈیا",
                               "کوبھی": "کو بھی",
                               "مدنظررکھتے": "مدنظر رکھتے",
                               "رکھتےہوئے": "رکھتے ہوئے",
                               "ہوئےاپنی": "ہوئے اپنی",
                               "عزیزنے": "عزیز نے",
                               "کےواقعات": "کے واقعات",
                               "انڈیاکی": "انڈیا کی",
                               "کوسرحدی": "کو سرحدی",
                               "اورواقعات": "اور واقعات",
                               "ہونےکے": "ہونے کے",
                               "سےفہرست": "سے فہرست",
                               "کےٹھکانوں": "کے ٹھکانوں",
                               "سےدونوں": "سے دونوں",
                               "نےانٹیلی": "نے انٹیلی",
                               "کابھی": "کا بھی",
                               "کیاجبکہ": "کیا جبکہ",
                               "مارےجانے": "مارے جانے",
                               "والےدہشت": "والے دہشت",
                               "کیلئےافغان": "کیلئے افغان",
                               "اورامریکہ": "اور امریکہ",
                               "اہےکہ": "اہے کہ",
                               "سےکوئی": "سے کوئی",
                               "پردونوں": "پر دونوں",
                               "رزامندی": "رزا مندی",
                               "پرنصاب": "پر نصاب",
                               "اورغیر": "اور غیر",
                               "غیرقانونی": "غیر قانونی",
                               "غیررجسٹرڈ": "غیر رجسٹرڈ",
                               "رجسٹرڈمدارس": "رجسٹرڈ مدارس",
                               "کےخلا": "کے خلا",
                               "اپنےصارفین": "اپنے صارفین",
                               "کیلئےفری": "کیلئے فری",
                               "کرنےکے": "کرنے کے",
                               "کیلئےخطرے": "کیلئے خطرے",
                               "خطرےکی": "خطرے کی",
                               "بھرمیں": "بھر میں",
                               "سےزائد": "سے زائد",
                               "نیافیچر": "نیا فیچر",
                               "فیچرمتعارف": "فیچر متعارف",
                               "نئےفیچر": "نئے فیچر",
                               "فیچرکے": "فیچر کے",
                               "کےذریعے": "کے ذریعے",
                               "ذریعےاپنے": "ذریعے اپنے",
                               "اپنےمطلوبہ": "اپنے مطلوبہ",
                               "سےہالینڈ": "سے ہالینڈ",
                               "ہالینڈکی": "ہالینڈ کی",
                               "ورلڈنامی": "ورلڈ نامی",
                               "نےکمپنی": "نے کمپنی",
                               "کامبینہ": "کا مبینہ",
                               "کےمیڈیا": "کے میڈیا",
                               "معیاریاشیاء": "معیاری اشیاء",
                               "اشیاءکے": "اشیاء کے",
                               "سےخواتین": "سے خواتین",
                               "پرمنفی": "پر منفی",
                               "سکتےہیں": "سکتے ہیں",
                               "نےکہا": "نے کہا",
                               "دوسرےخلیجی": "دوسرے خلیجی",
                               "کاسالانہ": "کا سالانہ",
                               "کاروبارتین": "کاروبار تین",
                               "سےتجاوز": "سے تجاوز",
                               "تجاوزکر": "تجاوز کر",
                               "چکاہے": "چکا ہے",
                               "کےمعیار": "کے معیار",
                               "معیارکی": "معیار کی",
                               "اشدضرورت": "اشد ضرورت",
                               "کواس": "کو اس",
                               "کےمنفی": "کے منفی",
                               "سےبچایا": "سے بچایا",
                               "بچایاجا": "بچایا جا",
                               "سکےڈاکٹر": "سکے ڈاکٹر",
                               "ڈاکٹرالعجاجی": "ڈاکٹر العجاجی",
                               "ڈالرکی": "ڈالر کی",
                               "پرپھونکی": "پر پھونکی",
                               "اورسعودی": "اور سعودی",
                               "نےبتایا": "نے بتایا",
                               "بتایاکہ": "بتایا کہ",
                               "چارفیصد": "چار فیصد",
                               "فیصدترقی": "فیصد ترقی",
                               "فیصدسالانہ": "فیصد سالانہ",
                               "جاپہنچی": "جا پہنچی",
                               "اگلےپانچ": "اگلے پانچ",
                               "گنااضافہ": "گنا اضافہ",
                               "اپنےحکومتوں": "اپنے حکومتوں",
                               "کوجنگجوؤں": "کو جنگجوؤں",
                               "اتحادمیں": "اتحاد میں",
                               "ہونےسے": "ہونے سے",
                               "سےروکیں": "سے روکیں",
                               "کوسمجھنا": "کو سمجھنا",
                               "سمجھناہو": "سمجھنا ہو",
                               "امریکادہشت": "امریکا دہشت",
                               "کےخلاف": "کے خلاف",
                               "کےپردے": "کے پردے",
                               "پردےمیں": "پردے میں",
                               "لڑرہا": "لڑ رہا",
                               "نیوزالقاعدہ": "نیوز القاعدہ",
                               "سےخطرے": "سے خطرے",
                               "بجاتےہوئے": "بجاتے ہوئے",
                               "ہوئےکہا": "ہوئے کہا",
                               "امریکاکے": "امریکا کے",
                               "کےتاریک": "کے تاریک",
                               "اورشمالی": "اور شمالی",
                               "نےامریکا": "نے امریکا",
                               "امریکاکی": "امریکا کی",
                               "اتحادکے": "اتحاد کے",
                               "سےنمٹنے": "سے نمٹنے",
                               "لیےعراق": "لیے عراق",
                               "اورشام": "اور شام",
                               "کےدرمیان": "کے درمیان",
                               "اتحادکی": "اتحاد کی",
                               "زوردیا": "زور دیا",
                               "نماعرب": "نما عرب",
                               "اوراسلامی": "اور اسلامی",
                               "اورجزیرہ": "اور جزیرہ",
                               "نےداعش": "نے داعش",
                               "ہونےوالے": "ہونے والے",
                               "والےدس": "والے دس",
                               "کہاگیا": "کہا گیا",
                               "اوربرائی": "اور برائی",
                               "ڈاکٹرایمن": "ڈاکٹر ایمن",
                               "سےلاتعلقی": "سے لاتعلقی",
                               "محاذالقاعدہ": "محاذ القاعدہ",
                               "جنگجوگروپوں": "جنگجو گروپوں",
                               "لیےاپنے": "لیے اپنے",
                               "اپنےباہمی": "اپنے باہمی",
                               "بالائےطاق": "بالائے طاق",
                               "امریکاپر": "امریکا پر",
                               "پراسلام": "پر اسلام",
                               "کاالزام": "کا الزام",
                               "عایدکیا": "عاید کیا",
                               "اورجنگجو": "اور جنگجو",
                               "اتحادپیدا": "اتحاد پیدا",
                               "پیداکرلیں": "پیدا کرلیں",
                               "اورامریکی": "اور امریکی",
                               "مقابلےکے": "مقابلے کے",
                               "لیےایک": "لیے ایک",
                               "ہفتےبحرین": "ہفتے بحرین",
                               "مصراردن": "مصر اردن",
                               "قطرسعودی": "قطر سعودی",
                               "اورمتحدہ": "اور متحدہ",
                               "کوداعش": "کو داعش",
                               "ہونےوالی": "ہونے والی",
                               "کرتےہیں": "کرتے ہیں",
                               "کارحکومتوں": "کار حکومتوں",
                               "کےسامنے": "کے سامنے",
                               "سامنےکھڑے": "سامنے کھڑے",
                               "اورانھیں": "اور انھیں",
                               "اورجائز": "اور جائز",
                               "جائزطریقوں": "جائز طریقوں",
                               "بننےسے": "بننے سے",
                               "اوراپنا": "اور اپنا",
                               "اپناراستہ": "اپنا راستہ",
                               "کرتےہوئے": "کرتے ہوئے",
                               "ہوئےامریکا": "ہوئے امریکا",
                               "امریکاکا": "امریکا کا",
                               "کاآلہ": "کا آلہ",
                               "کاربننے": "کار بننے",
                               "سےگریز": "سے گریز",
                               "گریزکریں": "گریز کریں",
                               "سےجون": "سے جون",
                               "کومسترد": "کو مسترد",
                               "مستردکر": "مسترد کر",
                               "تھااور": "تھا اور",
                               "کےوفادار": "کے وفادار",
                               "وفاداررہیں": "وفادار رہیں",
                               "امریکاجزیرہ": "امریکا جزیرہ",
                               "جنگجوگروہ": "جنگجو گروہ",
                               "کرتاہے": "کرتا ہے",
                               "پرمتعدد": "پر متعدد",
                               "متعددحملوں": "متعدد حملوں",
                               "پرڈیٹرائٹ": "پر ڈیٹرائٹ",
                               "والےایک": "والے ایک",
                               "مسافرطیارے": "مسافر طیارے",
                               "طیارےکو": "طیارے کو",
                               "کوبم": "کو بم",
                               "سےاڑانے": "سے اڑانے",
                               "اڑانےکی": "اڑانے کی",
                               "اوریمن": "اور یمن",
                               "بغیرپائیلٹ": "بغیر پائیلٹ",
                               "طیارےبھی": "طیارے بھی",
                               "کےسرکردہ": "کے سرکردہ",
                               "کونشانہ": "کو نشانہ",
                               "انسداددہشت": "انسداد دہشت",
                               "افرادمارے": "افراد مارے",
                               "مارےگئے": "مارے گئے",
                               "اورشخص": "اور شخص",
                               "قصبےمیں": "قصبے میں",
                               "چھاپےکے": "چھاپے کے",
                               "یاعوام": "یا عوام",
                               "کاکوئی": "کا کوئی",
                               "نےنامہ": "نے نامہ",
                               "نےشام": "نے شام",
                               "جوبڑے": "جو بڑے",
                               "پیمانےپر": "پیمانے پر",
                               "پرحملے": "پر حملے",
                               "حملےکرنے": "حملے کرنے",
                               "کرنےکی": "کرنے کی",
                               "رہاتھا": "رہا تھا",
                               "نےپولیس": "نے پولیس",
                               "پررائفلوں": "پر رائفلوں",
                               "سےفائر": "سے فائر",
                               "فائرکھول": "فائر کھول",
                               "نےفوجی": "نے فوجی",
                               "معیارکے": "معیار کے",
                               "کےاسلحے": "کے اسلحے",
                               "اسلحےسے": "اسلحے سے",
                               "سےپولیس": "سے پولیس",
                               "کےخصوصی": "کے خصوصی",
                               "پرفائر": "پر فائر",
                               "دیاجس": "دیا جس",
                               "بعدانھیں": "بعد انھیں",
                               "برسلزمیں": "برسلز میں",
                               "چھاپےمارے": "چھاپے مارے",
                               "مارےجا": "مارے جا",
                               "کادرجہ": "کا درجہ",
                               "کرتین": "کر تین",
                               "میڈیاکی": "میڈیا کی",
                               "سےقبل": "سے قبل",
                               "شہرکے": "شہر کے",
                               "کےنواح": "کے نواح",
                               "کےصحافی": "کے صحافی",
                               "نےبی": "نے بی",
                               "کےمشتبہ": "کے مشتبہ",
                               "افرادایک": "افراد ایک",
                               "کےبڑے": "کے بڑے",
                               "پرلوگوں": "پر لوگوں",
                               "کوقتل": "کو قتل",
                               "چاہتےتھے": "چاہتے تھے",
                               "نےخبر": "نے خبر",
                               "خبردی": "خبر دی",
                               "تیزفائرنگ": "تیز فائرنگ",
                               "آوازسنی": "آواز سنی",
                               "کےپاس": "کے پاس",
                               "اسےچاروں": "اسے چاروں",
                               "سےبند": "سے بند",
                               "قصبےکے": "قصبے کے",
                               "کےمرکز": "کے مرکز",
                               "مرکزمیں": "مرکز میں",
                               "اخبارالوطن": "اخبار الوطن",
                               "کوایک": "کو ایک",
                               "سےشکایت": "سے شکایت",
                               "نےاس": "نے اس",
                               "بغیرخواتین": "بغیر خواتین",
                               "کےجنسی": "کے جنسی",
                               "کےبارے": "کے بارے",
                               "بارےمیں": "بارے میں",
                               "نےوزارت": "نے وزارت",
                               "کوفلم": "کو فلم",
                               "کیلئےلے": "کیلئے لے",
                               "گیااور": "گیا اور",
                               "اورباپ": "اور باپ",
                               "بغیرچند": "بغیر چند",
                               "بندکروائے": "بند کروائے",
                               "پرعوامی": "پر عوامی",
                               "کیلئےبنائی": "کیلئے بنائی",
                               "کےباپ": "کے باپ",
                               "توحیران": "تو حیران",
                               "عمرکے": "عمر کے",
                               "سےمناسب": "سے مناسب",
                               "اورریکارڈنگ": "اور ریکارڈنگ",
                               "اسےکپڑے": "اسے کپڑے",
                               "کپڑےاتارنے": "کپڑے اتارنے",
                               "اتارنےپر": "اتارنے پر",
                               "مجبوربھی": "مجبور بھی",
                               "گیاجبکہ": "گیا جبکہ",
                               "یازبانی": "یا زبانی",
                               "میڈیااور": "میڈیا اور",
                               "اورسیاسی": "اور سیاسی",
                               "سےواشنگٹن": "سے واشنگٹن",
                               "پرمسلمانوں": "پر مسلمانوں",
                               "جھوٹاپروپگینڈا": "جھوٹا پروپگینڈا",
                               "پروپگینڈااپنے": "پروپگینڈا اپنے",
                               "اپنےعروج": "اپنے عروج",
                               "پرپہنچ": "پر پہنچ",
                               "کارنے": "کار نے",
                               "نےبرطانوی": "نے برطانوی",
                               "شہربرمنگھم": "شہر برمنگھم",
                               "کومسلم": "کو مسلم",
                               "تیزتر": "تیز تر",
                               "ترہوتا": "تر ہوتا",
                               "اورالقاعدہ": "اور القاعدہ",
                               "سےتشبیہ": "سے تشبیہ",
                               "نیوزپر": "نیوز پر",
                               "پرپیش": "پر پیش",
                               "آیاجب": "آیا جب",
                               "قراردیتے": "قرار دیتے",
                               "دیتےہوئے": "دیتے ہوئے",
                               "ہوئےیہ": "ہوئے یہ",
                               "ڈالاکہ": "ڈالا کہ",
                               "پسندنظریات": "پسند نظریات",
                               "اپنےتبصرے": "اپنے تبصرے",
                               "تبصرےمیں": "تبصرے میں",
                               "کوبرمنگھم": "کو برمنگھم",
                               "تشددکرتی": "تشدد کرتی",
                               "کالباس": "کا لباس",
                               "غیراسلامی": "غیر اسلامی",
                               "دلانےپر": "دلانے پر",
                               "اسےبڑی": "اسے بڑی",
                               "کہتےہوئے": "کہتے ہوئے",
                               "ہوئےمعافی": "ہوئے معافی",
                               "اسٹیوامرسن": "اسٹیو امرسن",
                               "حملےکے": "حملے کے",
                               "بعدپر": "بعد پر",
                               "پرواقعے": "پر واقعے",
                               "واقعےپر": "واقعے پر",
                               "اپنےخیالات": "اپنے خیالات",
                               "مشہورصحافی": "مشہور صحافی",
                               "اورشدت": "اور شدت",
                               "کےماہر": "کے ماہر",
                               "ماہرہیں": "ماہر ہیں",
                               "انٹرویوکے": "انٹرویو کے",
                               "کےنشر": "کے نشر",
                               "نشرہونے": "نشر ہونے",
                               "بعدسوشل": "بعد سوشل",
                               "پربرمنگھم": "پر برمنگھم",
                               "اورلندن": "اور لندن",
                               "شدیدردعمل": "شدید ردعمل",
                               "سامنےآیا": "سامنے آیا",
                               "اورشہریوں": "اور شہریوں",
                               "نےان": "نے ان",
                               "کےتبصرے": "کے تبصرے",
                               "تبصرےکو": "تبصرے کو",
                               "کوبکواس": "کو بکواس",
                               "نےای": "نے ای",
                               "ویڈیوزگرافک": "ویڈیوز گرافک",
                               "ویڈیوزاور": "ویڈیوز اور",
                               "اورتصاویر": "اور تصاویر",
                               "تصاویرپر": "تصاویر پر",
                               "پروارننگ": "پر وارننگ",
                               "کالیبل": "کا لیبل",
                               "کےیوزرز": "کے یوزرز",
                               "یوزرزکی": "یوزرز کی",
                               "سےبڑھتے": "سے بڑھتے",
                               "ہوئےدباؤ": "ہوئے دباؤ",
                               "دباؤکے": "دباؤ کے",
                               "بعدفیس": "بعد فیس",
                               "لیےبھی": "لیے بھی",
                               "اورصدمے": "اور صدمے",
                               "صدمےکا": "صدمے کا",
                               "تصاویرجو": "تصاویر جو",
                               "صدمےتکلیف": "صدمے تکلیف",
                               "اورذہنی": "اور ذہنی",
                               "کالییل": "کا لییل",
                               "لگاناشروع": "لگانا شروع",
                               "ہوسکتے": "ہو سکتے",
                               "کوبالائے": "کو بالائے",
                               "کوطالبان": "کو طالبان",
                               "ہراس": "ہر اس",
                               "امورکے": "امور کے",
                               "عمرافراد": "عمر افراد",
                               "ویڈیوزسے": "ویڈیوز سے",
                               "دوررکھنے": "دور رکھنے",
                               "رکھنےکے": "رکھنے کے",
                               "کئےجا": "کئے جا",
                               "گیاالرٹ": "گیا الرٹ",
                               "خودبخود": "خود بخود",
                               "بخودکھلنے": "بخود کھلنے",
                               "کھلنےسے": "کھلنے سے",
                               "دےگا": "دے گا",
                               "کےمشیروں": "کے مشیروں",
                               "سےحفاظتی": "سے حفاظتی",
                               "نظرکے": "نظر کے",
                               "کےتحت": "کے تحت",
                               "نئےاقدام": "نئے اقدام",
                               "سےجو": "سے جو",
                               "جوپوسٹ": "جو پوسٹ",
                               "سےپہلے": "سے پہلے",
                               "پہلےمتاثر": "پہلے متاثر",
                               "متاثرہوئی": "متاثر ہوئی",
                               "والےفرانسی": "والے فرانسی",
                               "افسراحمد": "افسر احمد",
                               "جسےویڈیوز": "جسے ویڈیوز",
                               "ویڈیوزمیں": "ویڈیوز میں",
                               "ہوئےدکھایا": "ہوئے دکھایا",
                               "کاغیر": "کا غیر",
                               "نیوزایجنسی": "نیوز ایجنسی",
                               "ہوئےکہنا": "ہوئے کہنا",
                               "امیدکرتی": "امید کرتی",
                               "سےویڈیوز": "سے ویڈیوز",
                               "ویڈیوزشیئر": "ویڈیوز شیئر",
                               "شیئرکریں": "شیئر کریں",
                               "سےکہیں": "سے کہیں",
                               "گےکہ": "گے کہ",
                               "تشددویڈیو": "تشدد ویڈیو",
                               "ویڈیوپوسٹ": "ویڈیو پوسٹ",
                               "لیےاس": "لیے اس",
                               "کاٹیگ": "کا ٹیگ",
                               "کےانجینئرز": "کے انجینئرز",
                               "انجینئرزاس": "انجینئرز اس",
                               "کومزید": "کو مزید",
                               "مزیدبہتر": "مزید بہتر",
                               "بہترکرنے": "بہتر کرنے",
                               "لیےکوشاں": "لیے کوشاں",
                               "ایسےمواد": "ایسے مواد",
                               "موادکو": "مواد کو",
                               "کوشیئر": "کو شیئر",
                               "وارکنونشن": "وار کنونشن",
                               "منعقدہوں": "منعقد ہوں",
                               "اوراس": "اور اس",
                               "کولاہور": "کو لاہور",
                               "لاہورجبکہ": "لاہور جبکہ",
                               "کوپشاور": "کو پشاور",
                               "نےطاہر": "نے طاہر",
                               "طاہرالقادری": "طاہر القادری",
                               "دھرنےختم": "دھرنے ختم",
                               "کیےتھے": "کیے تھے",
                               "پرانصاف": "پر انصاف",
                               "پراحتجاجی": "پر احتجاجی",
                               "چلانےکا": "چلانے کا",
                               "اورپہلا": "اور پہلا",
                               "پہلااحتجاج": "پہلا احتجاج",
                               "کوکیا": "کو کیا",
                               "جائےگا": "جائے گا",
                               "کوافغانستان": "کو افغانستان",
                               "لیاگیا": "لیا گیا",
                               "پرملزمان": "پر ملزمان",
                               "کوافغان": "کو افغان",
                               "فورسزنے": "فورسز نے",
                               "نےگرفتار": "نے گرفتار",
                               "گرفتارکیا": "گرفتار کیا",
                               "کیاملزمان": "کیا ملزمان",
                               "علاقےسے": "علاقے سے",
                               "گیاپانچوں": "گیا پانچوں",
                               "کمانڈرزہیں": "کمانڈرز ہیں",
                               "کایہ": "کا یہ",
                               "کہناہے": "کہنا ہے",
                               "کےمنصوبہ": "کے منصوبہ",
                               "کارتھے": "کار تھے",
                               "سےمتعلق": "سے متعلق",
                               "مزیدتفتیش": "مزید تفتیش",
                               "سےیہ": "سے یہ",
                               "ہواہے": "ہوا ہے",
                               "کاحالیہ": "کا حالیہ",
                               "سلسلےکی": "سلسلے کی",
                               "والےآرمی": "والے آرمی",
                               "کوتعطیلات": "کو تعطیلات",
                               "بعدکھول": "بعد کھول",
                               "گیااسلام": "گیا اسلام",
                               "آبادپاکستان": "آباد پاکستان",
                               "کےچیئر": "کے چیئر",
                               "ڈاکٹرشیریں": "ڈاکٹر شیریں",
                               "کھلنےکے": "کھلنے کے",
                               "بعدچیئر": "بعد چیئر",
                               "پرعمران": "پر عمران",
                               "اوران": "اور ان",
                               "کےاساتذہ": "کے اساتذہ",
                               "محمودخان": "محمود خان",
                               "کےقومی": "کے قومی",
                               "پشاورپر": "پشاور پر",
                               "پرخطاب": "پر خطاب",
                               "کےسربراہ": "کے سربراہ",
                               "کےساتھ": "کے ساتھ",
                               "کےاشارے": "کے اشارے",
                               "اشارےبقی": "اشارے بقی",
                               "پرمتاثر": "پر متاثر",
                               "متاثرکن": "متاثر کن",
                               "پرجذباتی": "پر جذباتی",
                               "تقریرکی": "تقریر کی",
                               "روزاجلاس": "روز اجلاس",
                               "رہےتھے": "رہے تھے",
                               "کاخطاب": "کا خطاب",
                               "تھاتاہم": "تھا تاہم",
                               "کےتقریر": "کے تقریر",
                               "تقریرکے": "تقریر کے",
                               "دید تھے": "دیدتھے",
                               "ذریعےباآسانی": "ذریعے باآسانی",
                               "اپنےموبائل": "اپنے موبائل",
                               "کاہیڈ": "کا ہیڈ",
                               "جوڑکر": "جوڑ کر",
                               "کربھی": "کر بھی",
                               "پرکال": "پر کال",
                               "ڈالرسے": "ڈالر سے",
                               "سےمتجاوز": "سے متجاوز",
                               "سےزیادہ": "سے زیادہ",
                               "کیاجاتا": "کیا جاتا",
                               "خطرےکا": "خطرے کا",
                               "قراردی": "قرار دی",
                               "رہےکہ": "رہے کہ",
                               "ڈالرمالیت": "ڈالر مالیت",
                               "کےایوان": "کے ایوان",
                               "کےرکن": "کے رکن",
                               "کےسامان": "کے سامان",
                               "کےمسلسل": "کے مسلسل",
                               "اورکم": "اور کم",
                               "شیئرکرنے": "شیئر کرنے",
                               "کرنےپر": "کرنے پر",
                               "تشددکرنے": "تشدد کرنے",
                               "کرنےوالا": "کرنے والا",
                               "والاخوشی": "والا خوشی",
                               "رہاہو": "رہا ہو",
                               "یااس": "یا اس",
                               "ایساپیغام": "ایسا پیغام",
                               "ہوجس": "ہو جس",
                               "سےتشدد": "سے تشدد",
                               "تشددکو": "تشدد کو",
                               "پسندکیا": "پسند کیا",
                               "ہوتاہم": "ہو تاہم",
                               "تشددنیوز": "تشدد نیوز",
                               "نیوزرپورٹ": "نیوز رپورٹ",
                               "اوردیگر": "اور دیگر",
                               "دکھانےپر": "دکھانے پر",
                               "کوتشدد": "کو تشدد",
                               "کےمواد": "کے مواد",
                               "دیکھنےسے": "دیکھنے سے",
                               "سکتےاس": "سکتے اس",
                               "لیےمزید": "لیے مزید",
                               "مزیدسخت": "مزید سخت",
                               "رہےسوشل": "رہے سوشل",
                               "پرشام": "پر شام",
                               "کئےجانے": "کئے جانے",
                               "کےسروں": "کے سروں",
                               "لٹکائےجانے": "لٹکائے جانے",
                               "ویڈیوکو": "ویڈیو کو",
                               "کولوگوں": "کو لوگوں",
                               "نےسخت": "نے سخت",
                               "تنقیدکا": "تنقید کا",
                               "لینےکے": "لینے کے",
                               "لئےدباؤ": "لئے دباؤ",
                               "غیرمعمولی": "غیر معمولی",
                               "پرنٹرمستقبل": "پرنٹر مستقبل",
                               "اورخارجہ": "اور خارجہ",
                               "اورکردار": "اور کردار",
                               "کردارکا": "کردار کا",
                               "پرنٹرزکے": "پرنٹرز کے",
                               "ذریعےمسقبل": "ذریعے مسقبل",
                               "کوحقیقت": "کو حقیقت",
                               "سکےگا": "سکے گا",
                               "گااور": "گا اور",
                               "اوردفاعی": "اور دفاعی",
                               "یاشاید": "یا شاید",
                               "شایدعالمی": "شاید عالمی",
                               "کاایک": "کا ایک",
                               "درکھل": "در کھل",
                               "متعددافراد": "متعدد افراد",
                               "ساہے": "سا ہے",
                               "ذریعےپلاسٹک": "ذریعے پلاسٹک",
                               "کاروپ": "کا روپ",
                               "شعبےمیں": "شعبے میں",
                               "اورکپڑے": "اور کپڑے",
                               "کپڑےاور": "کپڑے اور",
                               "دیگرچیزوں": "دیگر چیزوں",
                               "سےپرنٹنگ": "سے پرنٹنگ",
                               "سےاندازہ": "سے اندازہ",
                               "دنیامیں": "دنیا میں",
                               "کابے": "کا بے",
                               "بےانتہا": "بے انتہا",
                               "انتہااہم": "انتہا اہم",
                               "کردارہوا": "کردار ہوا",
                               "ہواکرے": "ہوا کرے",
                               "پرسرمایہ": "پر سرمایہ",
                               "کررہی": "کر رہی",
                               "ذریعےیونیفارمز": "ذریعے یونیفارمز",
                               "یونیفارمزجنگ": "یونیفارمز جنگ",
                               "والےزخموں": "والے زخموں",
                               "لیےپٹیاں": "لیے پٹیاں",
                               "اورحتی": "اور حتی",
                               "غذاکی": "غذا کی",
                               "کےسائنس": "کے سائنس",
                               "ایجادکر": "ایجاد کر",
                               "کرلی": "کر لی",
                               "مادےکو": "مادے کو",
                               "کوپانی": "کو پانی",
                               "اورنئے": "اور نئے",
                               "نئےمواد": "نئے مواد",
                               "موادمیں": "مواد میں",
                               "ذریعےایسے": "ذریعے ایسے",
                               "ایسےیونیفارم": "ایسے یونیفارم",
                               "تیارکیے": "تیار کیے",
                               "جاسکیں": "جا سکیں",
                               "کےرنگ": "کے رنگ",
                               "کےماحول": "کے ماحول",
                               "اٹھائےجا": "اٹھائے جا",
                               "چکےہیں": "چکے ہیں",
                               "اےای": "اے ای",
                               "سسٹمزنے": "سسٹمز نے",
                               "ٹورناڈولڑاکا": "ٹورناڈو لڑاکا",
                               "لڑاکاطیارے": "لڑاکا طیارے",
                               "ایسےہی": "ایسے ہی",
                               "ذریعےچھاپا": "ذریعے چھاپا",
                               "چھاپاگیا": "چھاپا گیا",
                               "گیاایک": "گیا ایک",
                               "نےابھی": "نے ابھی",
                               "اینیمیٹڈویڈیو": "اینیمیٹڈ ویڈیو",
                               "ویڈیوجاری": "ویڈیو جاری",
                               "ذریعےمستقبل": "ذریعے مستقبل",
                               "کےامکانات": "کے امکانات",
                               "دکھائےگئے": "دکھائے گئے",
                               "جہازکو": "جہاز کو",
                               "اورجہاز": "اور جہاز",
                               "جہازپرنٹ": "جہاز پرنٹ",
                               "کرتےدکھایا": "کرتے دکھایا",
                               "کےخانے": "کے خانے",
                               "خانےسے": "خانے سے",
                               "سےاچانک": "سے اچانک",
                               "بیدارہوتا": "بیدار ہوتا",
                               "اوراڑنے": "اور اڑنے",
                               "اڑنےلگتا": "اڑنے لگتا",
                               "کےتھری": "کے تھری",
                               "سٹیوینزکے": "سٹیوینز کے",
                               "ہےمگر": "ہے مگر",
                               "ہماراہدف": "ہمارا ہدف",
                               "سےپورے": "سے پورے",
                               "پورےکے": "پورے کے",
                               "کےپورے": "کے پورے",
                               "پورےطیارے": "پورے طیارے",
                               "بنانےلگیں": "بنانے لگیں",
                               "برائےصحت": "برائے صحت",
                               "سےویڈیو": "سے ویڈیو",
                               "ویڈیوگیمز": "ویڈیو گیمز",
                               "گیمزکھیلنے": "گیمز کھیلنے",
                               "کھیلنےکے": "کھیلنے کے",
                               "کےشوقین": "کے شوقین",
                               "لیےانتباہ": "لیے انتباہ",
                               "گیمزکھیلنا": "گیمز کھیلنا",
                               "کھیلناانکی": "کھیلنا انکی",
                               "کاسبب": "کا سبب",
                               "کاانکشاف": "کا انکشاف",
                               "لینڈکے": "لینڈ کے",
                               "کےایک": "کے ایک",
                               "گیمرکے": "گیمر کے",
                               "کےجسم": "کے جسم",
                               "پلےسٹیشن": "پلے سٹیشن",
                               "پرگیمز": "پر گیمز",
                               "کھیلنےکی": "کھیلنے کی",
                               "بندہونے": "بند ہونے",
                               "ہونےلگیں": "ہونے لگیں",
                               "کوظاہر": "کو ظاہر",
                               "ظاہرنہیں": "ظاہر نہیں",
                               "گیاچار": "گیا چار",
                               "چارروز": "چار روز",
                               "اپنےبستر": "اپنے بستر",
                               "بسترپر": "بستر پر",
                               "پرٹانگیں": "پر ٹانگیں",
                               "گھنٹےروزانہ": "گھنٹے روزانہ",
                               "گیمزکھیلتا": "گیمز کھیلتا",
                               "کھیلتارہا": "کھیلتا رہا",
                               "گیمزکے": "گیمز کے",
                               "کےاس": "کے اس",
                               "کودوسرے": "کو دوسرے",
                               "دوسرےدن": "دوسرے دن",
                               "بھرپور": "بھر پور",
                               "پورگیم": "پور گیم",
                               "بیٹھنےدیا": "بیٹھنے دیا",
                               "چوتھےروز": "چوتھے روز",
                               "روزجب": "روز جب",
                               "اسکےجسم": "اسکے جسم",
                               "اورانکی": "اور انکی",
                               "تواس": "تو اس",
                               "نےفوری": "نے فوری",
                               "طورپر": "طور پر",
                               "پرطبی": "پر طبی",
                               "امدادحاصل": "امداد حاصل",
                               "نےتشخیص": "نے تشخیص",
                               "اگربروقت": "اگر بروقت",
                               "اسکاعلاج": "اسکا علاج",
                               "اورخون": "اور خون",
                               "کےلوتھڑے": "کے لوتھڑے",
                               "لوتھڑےجمنے": "لوتھڑے جمنے",
                               "جمنےکی": "جمنے کی",
                               "سےاس": "سے اس",
                               "کمپیوٹریا": "کمپیوٹر یا",
                               "یاانٹرنیٹ": "یا انٹرنیٹ",
                               "کھیلنےوالے": "کھیلنے والے",
                               "بیٹھےرہتے": "بیٹھے رہتے",
                               "گیمزبھی": "گیمز بھی",
                               "پرزیادہ": "پر زیادہ",
                               "اورمسائل": "اور مسائل",
                               "آغازہو": "آغاز ہو",
                               "تواگر": "تو اگر",
                               "اگرآپ": "اگر آپ",
                               "سےسبق": "سے سبق",
                               "اوردن": "اور دن",
                               "حددو": "حد دو",
                               "دوگھنٹے": "دو گھنٹے",
                               "گھنٹےسے": "گھنٹے سے",
                               "گیمزمت": "گیمز مت",
                               "سےچلتے": "سے چلتے",
                               "چلتےپھرتے": "چلتے پھرتے",
                               "پھرتےرہیں": "پھرتے رہیں",
                               "پرکسی": "پر کسی",
                               "کاسمجھوتا": "کا سمجھوتا",
                               "سمجھوتانہیں": "سمجھوتا نہیں",
                               "کرناچاہیے": "کرنا چاہیے",
                               "مفیدپروگرامز": "مفید پروگرامز",
                               "پروگرامزکا": "پروگرامز کا",
                               "سےتو": "سے تو",
                               "جسےایک": "جسے ایک",
                               "گھریلوکمپیوٹر": "گھریلو کمپیوٹر",
                               "اورخصوصیات": "اور خصوصیات",
                               "توکتابوں": "تو کتابوں",
                               "اورپڑھی": "اور پڑھی",
                               "جاچکی": "جا چکی",
                               "اسےبے": "اسے بے",
                               "بےحد": "بے حد",
                               "حدموثر": "حد موثر",
                               "موثراور": "موثر اور",
                               "اورمحفوظ": "اور محفوظ",
                               "سمجھاجاتا": "سمجھا جاتا",
                               "دھرنےکی": "دھرنے کی",
                               "پربھی": "پر بھی",
                               "کیاآپ": "کیا آپ",
                               "نےکبھی": "نے کبھی",
                               "سوچاہے": "سوچا ہے",
                               "بظاہربے": "بظاہر بے",
                               "بےضرر": "بے ضرر",
                               "ساپروگرام": "سا پروگرام",
                               "کااعتماد": "کا اعتماد",
                               "اعتمادشامل": "اعتماد شامل",
                               "کوآپ": "کو آپ",
                               "غیرمحفوظ": "غیر محفوظ",
                               "پہنچاسکتا": "پہنچا سکتا",
                               "نےکے": "نے کے",
                               "یانئی": "یا نئی",
                               "ظاہرہوگی": "ظاہر ہوگی",
                               "آخرپر": "آخر پر",
                               "کومعلومات": "کو معلومات",
                               "دےگی": "دے گی",
                               "اورآپکے": "اور آپکے",
                               "آپکےکمپیوٹر": "آپکے کمپیوٹر",
                               "کمپیوٹرکا": "کمپیوٹر کا",
                               "کانام": "کا نام",
                               "کتنےلوگوں": "کتنے لوگوں",
                               "نےمل": "نے مل",
                               "کوتشکیل": "کو تشکیل",
                               "کتناعرصہ": "کتنا عرصہ",
                               "اوریونس": "اور یونس",
                               "انفوکی": "انفو کی",
                               "سےایوارڈز": "سے ایوارڈز",
                               "پرفارمنسزکی": "پرفارمنسز کی",
                               "نےتاریخی": "نے تاریخی",
                               "تیزترین": "تیز ترین",
                               "ریکارڈبرابر": "ریکارڈ برابر",
                               "برابرکرنے": "برابر کرنے",
                               "پرمصباح": "پر مصباح",
                               "اوردبئی": "اور دبئی",
                               "کےرنز": "کے رنز",
                               "رنزکو": "رنز کو",
                               "کوشارٹ": "کو شارٹ",
                               "لارڈزمیں": "لارڈز میں",
                               "کےعوض": "کے عوض",
                               "کارکردگی": "کار کردگی",
                               "وینیوپر": "وینیو پر",
                               "پربرس": "پر برس",
                               "بعدپہلی": "بعد پہلی",
                               "اگلےٹیسٹ": "اگلے ٹیسٹ",
                               "والےجیمز": "والے جیمز",
                               "جیمزاینڈرسن": "جیمز اینڈرسن",
                               "سےانگلش": "سے انگلش",
                               "نےسیریز": "نے سیریز",
                               "سیریزمیں": "سیریز میں",
                               "مالنگاکی": "مالنگا کی",
                               "دواور": "دو اور",
                               "اورٹوئنٹی": "اور ٹوئنٹی",
                               "کےشان": "کے شان",
                               "ڈیوڈوارنر": "ڈیوڈ وارنر",
                               "وارنرجونسن": "وارنر جونسن",
                               "اورریان": "اور ریان",
                               "نےجنوبی": "نے جنوبی",
                               "اورکیپ": "اور کیپ",
                               "تھااگرچہ": "تھا اگرچہ",
                               "کےآخری": "کے آخری",
                               "حصےمیں": "حصے میں",
                               "نےعمدہ": "نے عمدہ",
                               "سےآسٹریلیا": "سے آسٹریلیا",
                               "آسٹریلیاکی": "آسٹریلیا کی",
                               "کویقینی": "کو یقینی",
                               "کیلیےشارٹ": "کیلیے شارٹ",
                               "اننگزکھیلی": "اننگز کھیلی",
                               "ایوارڈزکا": "ایوارڈز کا",
                               "کےپہلے": "کے پہلے",
                               "پہلےہفتے": "پہلے ہفتے",
                               "ہفتےمیں": "ہفتے میں",
                               "کھیلےگئے": "کھیلے گئے",
                               "گئےسیریز": "گئے سیریز",
                               "کےتیسرے": "کے تیسرے",
                               "تیسرےاور": "تیسرے اور",
                               "اورآخری": "اور آخری",
                               "بلےباز": "بلے باز",
                               "نےانتہائی": "نے انتہائی",
                               "شانداراور": "شاندار اور",
                               "اورذمہ": "اور ذمہ",
                               "نےسری": "نے سری",
                               "ڈےمیں": "ڈے میں",
                               "بنانےکا": "بنانے کا",
                               "انتظاربھی": "انتظار بھی",
                               "اورآخر": "اور آخر",
                               "آخرکار": "آخر کار",
                               "کاروہ": "کار وہ",
                               "کیریئرکی": "کیریئر کی",
                               "بنانےمیں": "بنانے میں",
                               "ہوگئیں": "ہو گئیں",
                               "کےعلاوہ": "کے علاوہ",
                               "اننگزمیں": "اننگز میں",
                               "رنزکا": "رنز کا",
                               "کاملکی": "کا ملکی",
                               "ریکارڈبھی": "ریکارڈ بھی",
                               "سےسنچری": "سے سنچری",
                               "بنانےوالی": "بنانے والی",
                               "بازہیں": "باز ہیں",
                               "بناچکی": "بنا چکی",
                               "ڈےکیریئر": "ڈے کیریئر",
                               "کیریئرکا": "کیریئر کا",
                               "کیااور": "کیا اور",
                               "اورکیریئر": "اور کیریئر",
                               "نےکیریئر": "نے کیریئر",
                               "کیریئرکے": "کیریئر کے",
                               "بورڈکو": "بورڈ کو",
                               "کوواضح": "کو واضح",
                               "کےجادوگر": "کے جادوگر",
                               "سعیداجمل": "سعید اجمل",
                               "کرائےتو": "کرائے تو",
                               "اسےورلڈ": "اسے ورلڈ",
                               "ورلڈکپ": "ورلڈ کپ",
                               "لاہورسے": "لاہور سے",
                               "سےروزنامہ": "سے روزنامہ",
                               "نےباقاعدہ": "نے باقاعدہ",
                               "کوپیغام": "کو پیغام",
                               "اگرچاہتے": "اگر چاہتے",
                               "چاہتےہیں": "چاہتے ہیں",
                               "توفروری": "تو فروری",
                               "کرائےمگر": "کرائے مگر",
                               "مگردوسری": "مگر دوسری",
                               "روزقذافی": "روز قذافی",
                               "اگرسعید": "اگر سعید",
                               "کلئیربھی": "کلئیر بھی",
                               "اسےکھیلنے": "اسے کھیلنے",
                               "دیکھناہو": "دیکھنا ہو",
                               "کےواضح": "کے واضح",
                               "بورڈکیا": "بورڈ کیا",
                               "کیافیصلہ": "کیا فیصلہ",
                               "لاہورمصباح": "لاہور مصباح",
                               "کہتےہیں": "کہتے ہیں",
                               "ڈےکرکٹ": "ڈے کرکٹ",
                               "سےریٹائرمنٹ": "سے ریٹائرمنٹ",
                               "کیلئےمناسب": "کیلئے مناسب",
                               "کاانتظار": "کا انتظار",
                               "انتظارکیا": "انتظار کیا",
                               "جیسااسٹار": "جیسا اسٹار",
                               "اسٹارآسانی": "اسٹار آسانی",
                               "سفرمکمل": "سفر مکمل",
                               "میگاایونٹ": "میگا ایونٹ",
                               "بعدکپتان": "بعد کپتان",
                               "دباؤکا": "دباؤ کا",
                               "کانتیجہ": "کا نتیجہ",
                               "سےبرسوں": "سے برسوں",
                               "اسےچھوڑنا": "اسے چھوڑنا",
                               "چھوڑناآسان": "چھوڑنا آسان",
                               "بنےنہ": "بنے نہ",
                               "شہریارخان": "شہریار خان",
                               "کوزبردست": "کو زبردست",
                               "نےسال": "نے سال",
                               "ہزارچودہ": "ہزار چودہ",
                               "کےبہترین": "کے بہترین",
                               "پرمنتخب": "پر منتخب",
                               "رونالڈواور": "رونالڈو اور",
                               "اورارجن": "اور ارجن",
                               "سوئٹزرلینڈکے": "سوئٹزرلینڈ کے",
                               "شہرزیورخ": "شہر زیورخ",
                               "فیفاکی": "فیفا کی",
                               "کاسبھی": "کا سبھی",
                               "کوانتظار": "کو انتظار",
                               "انتظارتھا": "انتظار تھا",
                               "توسبھی": "تو سبھی",
                               "اسٹارزجمع": "اسٹارز جمع",
                               "کاایوارڈ": "کا ایوارڈ",
                               "اڑانےوالے": "اڑانے والے",
                               "والےمینوئل": "والے مینوئل",
                               "موجودتھے": "موجود تھے",
                               "توراموس": "تو راموس",
                               "سلوابھی": "سلوا بھی",
                               "ماریاآنیسٹا": "ماریا آنیسٹا",
                               "آنیسٹاکروز": "آنیسٹا کروز",
                               "کروزلیونل": "کروز لیونل",
                               "کرسٹیانورونالڈو": "کرسٹیانو رونالڈو",
                               "ایوارڈملا": "ایوارڈ ملا",
                               "کوسال": "کو سال",
                               "پلیئرکا": "پلیئر کا",
                               "ایوارڈدیا": "ایوارڈ دیا",
                               "نےنواب": "نے نواب",
                               "اکبربگٹی": "اکبر بگٹی",
                               "پرسابق": "پر سابق",
                               "افرادپر": "افراد پر",
                               "پرفرد": "پر فرد",
                               "عائدکر": "عائد کر",
                               "کےوکیل": "کے وکیل",
                               "نےعدالت": "نے عدالت",
                               "سےاستدعا": "سے استدعا",
                               "کےباعث": "کے باعث",
                               "ہوسکتےاس": "ہوسکتے اس",
                               "سےاستثنی": "سے استثنی",
                               "دیاجائے": "دیا جائے",
                               "جائےجس": "جائے جس",
                               "نےمیڈیکل": "نے میڈیکل",
                               "بورڈکی": "بورڈ کی",
                               "شدیدبرہمی": "شدید برہمی",
                               "نےمختلف": "نے مختلف",
                               "چینلزپر": "چینلز پر",
                               "پردیکھا": "پر دیکھا",
                               "انٹرویودیتے": "انٹرویو دیتے",
                               "دیتےہیں": "دیتے ہیں",
                               "نےوکلا": "نے وکلا",
                               "وکلاکے": "وکلا کے",
                               "کےدلائل": "کے دلائل",
                               "سننےکے": "سننے کے",
                               "بعدسابق": "بعد سابق",
                               "شیرپاؤاور": "شیرپاؤ اور",
                               "عائدکرتے": "عائد کرتے",
                               "ہوئےسماعت": "ہوئے سماعت",
                               "کےصاحبزادے": "کے صاحبزادے",
                               "صاحبزادےجمیل": "صاحبزادے جمیل",
                               "سےمیں": "سے میں",
                               "والدکے": "والد کے",
                               "شیرپاؤصوبائی": "شیرپاؤ صوبائی",
                               "کےگورنر": "کے گورنر",
                               "گورنراویس": "گورنر اویس",
                               "کیاتھ": "کیا تھ",
                               "ذریعےدہشت": "ذریعے دہشت",
                               "سےلڑنے": "سے لڑنے",
                               "لڑنےکا": "لڑنے کا",
                               "کامشورہ": "کا مشورہ",
                               "لاہورک": "لاہور ک",
                               "نےگزشتہ": "نے گزشتہ",
                               "نےوزیراعظم": "نے وزیراعظم",
                               "کےبچوں": "کے بچوں",
                               "نےجہاں": "نے جہاں",
                               "کےہر": "کے ہر",
                               "ہرطبقے": "ہر طبقے",
                               "طبقےکو": "طبقے کو",
                               "کوہلا": "کو ہلا",
                               "ہلاکر": "ہلا کر",
                               "کررکھا": "کر رکھا",
                               "رکھاہیں": "رکھا ہیں",
                               "بچےبھی": "بچے بھی",
                               "دورنہیں": "دور نہیں",
                               "لاہورکی": "لاہور کی",
                               "ذریعےملک": "ذریعے ملک",
                               "کاپر": "کا پر",
                               "کےخط": "کے خط",
                               "قدرکرتے": "قدر کرتے",
                               "اسےمیڈل": "اسے میڈل",
                               "سےنواز": "سے نواز",
                               "عہدکیا": "عہد کیا",
                               "کوقائد": "کو قائد",
                               "قائداعظم": "قائد اعظم",
                               "نےخط": "نے خط",
                               "مزیدلکھا": "مزید لکھا",
                               "لکھاہے": "لکھا ہے",
                               "بہادرقوم": "بہادر قوم",
                               "سےڈرنے": "سے ڈرنے",
                               "ڈرنےوالے": "ڈرنے والے",
                               "والےنہیں": "والے نہیں",
                               "احمدنے": "احمد نے",
                               "پرپاک": "پر پاک",
                               "کروانےکے": "کروانے کے",
                               "لئےاقوام": "لئے اقوام",
                               "اپنےبھرپور": "اپنے بھرپور",
                               "بھرپورکردار": "بھرپور کردار",
                               "کردارکی": "کردار کی",
                               "چھوٹےضرور": "چھوٹے ضرور",
                               "ضرورہیں": "ضرور ہیں",
                               "لیےہمیشہ": "لیے ہمیشہ",
                               "آوازاٹھاتے": "آواز اٹھاتے",
                               "اٹھاتےرہیں": "اٹھاتے رہیں",
                               "دباؤکو": "دباؤ کو",
                               "اورمشینی": "اور مشینی",
                               "ہرانسان": "ہر انسان",
                               "مسئلےمیں": "مسئلے میں",
                               "نظرآتا": "نظر آتا",
                               "جوذہنی": "جو ذہنی",
                               "کرکئی": "کر کئی",
                               "دیتاہے": "دیتا ہے",
                               "مختصراور": "مختصر اور",
                               "اورآسان": "اور آسان",
                               "بتایاجا": "بتایا جا",
                               "جسےاختیار": "جسے اختیار",
                               "اختیارکر": "اختیار کر",
                               "کےآپ": "کے آپ",
                               "خوشگوارزندگی": "خوشگوار زندگی",
                               "گذارسکتے": "گذار سکتے",
                               "نےذہنی": "نے ذہنی",
                               "دباؤپر": "دباؤ پر",
                               "پرتحقیق": "پر تحقیق",
                               "پرقابو": "پر قابو",
                               "پانےکا": "پانے کا",
                               "کاآسان": "کا آسان",
                               "اشیاکی": "اشیا کی",
                               "اورکھانے": "اور کھانے",
                               "کےشیڈول": "کے شیڈول",
                               "کوذرا": "کو ذرا",
                               "ذراسا": "ذرا سا",
                               "ساتبدیل": "سا تبدیل",
                               "کےذہنی": "کے ذہنی",
                               "دباؤسے": "دباؤ سے",
                               "بچاجا": "بچا جا",
                               "سرکمر": "سر کمر",
                               "کمردرد": "کمر درد",
                               "دردڈپریشن": "درد ڈپریشن",
                               "شوگراور": "شوگر اور",
                               "اورموٹاپے": "اور موٹاپے",
                               "موٹاپےجیسی": "موٹاپے جیسی",
                               "پیداکر": "پیدا کر",
                               "پرفوری": "پر فوری",
                               "کرناانتہائی": "کرنا انتہائی",
                               "کوپرسکون": "کو پرسکون",
                               "کےموٹاپے": "کے موٹاپے",
                               "موٹاپےکو": "موٹاپے کو",
                               "اگراس": "اگر اس",
                               "مراقبےکو": "مراقبے کو",
                               "لیاجائے": "لیا جائے",
                               "جائےتو": "جائے تو",
                               "کےبہت": "کے بہت",
                               "اوردیرپا": "اور دیرپا",
                               "دیرپااثرات": "دیرپا اثرات",
                               "ہوتےہیں": "ہوتے ہیں",
                               "کااستعمال": "کا استعمال",
                               "نوازشریف": "نواز شریف",
                               "گارہوتے": "گار ہوتے",
                               "اوردوسری": "اور دوسری",
                               "چیزجسے": "چیز جسے",
                               "جسےعام": "جسے عام",
                               "پرنظر": "پر نظر",
                               "نظرانداز": "نظر انداز",
                               "گھرکی": "گھر کی",
                               "اگراشیا": "اگر اشیا",
                               "اشیااپنی": "اشیا اپنی",
                               "تویہ": "تو یہ",
                               "کوبڑھا": "کو بڑھا",
                               "بڑھادیتی": "بڑھا دیتی",
                               "کارکہنا": "کار کہنا",
                               "پہلےاپنے": "پہلے اپنے",
                               "اپنےگھر": "اپنے گھر",
                               "گھرخاص": "گھر خاص",
                               "پرباورچی": "پر باورچی",
                               "اورکمروں": "اور کمروں",
                               "چیزنشان": "چیز نشان",
                               "موجودہو": "موجود ہو",
                               "ہوتاکہ": "ہو تاکہ",
                               "پڑنےپر": "پڑنے پر",
                               "چیزکو": "چیز کو",
                               "کوتلاش": "کو تلاش",
                               "کرنےمیں": "کرنے میں",
                               "ہواپنی": "ہو اپنی",
                               "پینےکا": "پینے کا",
                               "کاہفتہ": "کا ہفتہ",
                               "اورپھر": "اور پھر",
                               "بارپھر": "بار پھر",
                               "مطالبےسے": "مطالبے سے",
                               "سےپیچھے": "سے پیچھے",
                               "پیچھےنہیں": "پیچھے نہیں",
                               "حملےمیں": "حملے میں",
                               "سوچناچھوڑ": "سوچنا چھوڑ",
                               "گھرآئیں": "گھر آئیں",
                               "تودن": "تو دن",
                               "بھرکیا": "بھر کیا",
                               "کیاہوا": "کیا ہوا",
                               "کوبھول": "کو بھول",
                               "اورایک": "اور ایک",
                               "اورپیار": "اور پیار",
                               "پیاربھری": "پیار بھری",
                               "پھردیکھیں": "پھر دیکھیں",
                               "دوربھاگ": "دور بھاگ",
                               "نسخےکو": "نسخے کو",
                               "کوآمائیں": "کو آمائیں",
                               "ہمارادعوی": "ہمارا دعوی",
                               "سےذہنی": "سے ذہنی",
                               "دباؤدور": "دباؤ دور",
                               "پرشہدا": "پر شہدا",
                               "شہداکے": "شہدا کے",
                               "شدیداحتجاج": "شدید احتجاج",
                               "پشاورچیئرمین": "پشاورچیئر مین",
                               "بعدان": "بعد ان",
                               "دوسرےگیٹ": "دوسرے گیٹ",
                               "کےاندر": "کے اندر",
                               "اندرلے": "اندر لے",
                               "جایاگیا": "جایا گیا",
                               "باہرشہید": "باہر شہید",
                               "شہیدبچوں": "شہید بچوں",
                               "کےغم": "کے غم",
                               "سےنڈھال": "سے نڈھال",
                               "روزبعد": "روز بعد",
                               "بعدآمد": "بعد آمد",
                               "آمدپر": "آمد پر",
                               "شدیدناراضگی": "شدید ناراضگی",
                               "شہیدبچے": "شہید بچے",
                               "بچےکی": "بچے کی",
                               "نےمشکل": "نے مشکل",
                               "تنہاچھوڑدیا": "تنہا چھوڑدیا",
                               "چھوڑدیااورجس": "چھوڑدیا اورجس",
                               "ہمارےبچوں": "ہمارے بچوں",
                               "پرظلم": "پر ظلم",
                               "تووہ": "تو وہ",
                               "عزیزتھیں": "عزیز تھیں",
                               "ہمارےغم": "ہمارے غم",
                               "گئےاتنے": "گئے اتنے",
                               "اتنےروز": "اتنے روز",
                               "یادآیا": "یاد آیا",
                               "فکرنہیں": "فکر نہیں",
                               "پرکیا": "پر کیا",
                               "آنےکی": "آنے کی",
                               "کیاضرورت": "کیا ضرورت",
                               "پردکھ": "پر دکھ",
                               "کےچاقو": "کے چاقو",
                               "چاقوچل": "چاقو چل",
                               "معاملےمیں": "معاملے میں",
                               "پہلےیہاں": "پہلے یہاں",
                               "آناچاہییے": "آنا چاہییے",
                               "چاہییےتھا": "چاہییے تھا",
                               "آئےاور": "آئے اور",
                               "اوراب": "اور اب",
                               "آنےنہیں": "آنے نہیں",
                               "اپنےشہدا": "اپنے شہدا",
                               "شہداکا": "شہدا کا",
                               "کاحساب": "کا حساب",
                               "لیناہے": "لینا ہے",
                               "چاہےاس": "چاہے اس",
                               "لئےہماری": "لئے ہماری",
                               "دینےپر": "دینے پر",
                               "پرآج": "پر آج",
                               "لئےووٹ": "لئے ووٹ",
                               "دیئےلیکن": "دیئے لیکن",
                               "تنہاچھوڑ": "تنہا چھوڑ",
                               "چھوڑدی": "چھوڑ دی",
                               "پراب": "پر اب",
                               "اسےقبول": "اسے قبول",
                               "آبادکے": "آباد کے",
                               "باہرمیڈیا": "باہر میڈیا",
                               "ہوئےوفاقی": "ہوئے وفاقی",
                               "لئےجمہوری": "لئے جمہوری",
                               "کمزورکرنا": "کمزور کرنا",
                               "نےماہ": "نے ماہ",
                               "روڑےاٹکا": "روڑے اٹکا",
                               "اٹکارہے": "اٹکا رہے",
                               "اورجھوٹ": "اور جھوٹ",
                               "سامنےسچ": "سامنے سچ",
                               "رکھتےعمران": "رکھتے عمران",
                               "کےطرز": "کے طرز",
                               "کومضبوط": "کو مضبوط",
                               "کوآرمی": "کو آرمی",
                               "گوعمران": "گو عمران",
                               "گوکے": "گو کے",
                               "نعرےسننے": "نعرے سننے",
                               "سننےپڑے": "سننے پڑے",
                               "کےدکھی": "کے دکھی",
                               "پرویزرشید": "پرویز رشید",
                               "پربنتا": "پر بنتا",
                               "بنتاہے": "بنتا ہے",
                               "جوٹریبونل": "جو ٹریبونل",
                               "کےدائرہ": "کے دائرہ",
                               "اختیارمیں": "اختیار میں",
                               "کےووٹوں": "کے ووٹوں",
                               "کرنےوالے": "کرنے والے",
                               "والےلوکل": "والے لوکل",
                               "نےکہیں": "نے کہیں",
                               "کےکاؤنٹر": "کے کاؤنٹر",
                               "کاؤنٹرفائل": "کاؤنٹر فائل",
                               "پردستخط": "پر دستخط",
                               "گھنٹےمیں": "گھنٹے میں",
                               "لئےاب": "لئے اب",
                               "پیچھےہٹ": "پیچھے ہٹ",
                               "نیوزتحریک": "نیوز تحریک",
                               "بتاتےہیں": "بتاتے ہیں",
                               "دیوارگرنے": "دیوار گرنے",
                               "کیاگزر": "کیا گزر",
                               "کروڑروپے": "کروڑ روپے",
                               "روپےبھی": "روپے بھی",
                               "کوماڈل": "کو ماڈل",
                               "کیاگاؤں": "کیا گاؤں",
                               "نگررکھا": "نگر رکھا",
                               "لئےپندرہ": "لئے پندرہ",
                               "منصوبےمیں": "منصوبے میں",
                               "تعمیرلڑکیوں": "تعمیر لڑکیوں",
                               "کاکالج": "کا کالج",
                               "تعمیرشامل": "تعمیر شامل",
                               "تھامگر": "تھا مگر",
                               "مگرتین": "مگر تین",
                               "گزرگئے": "گزر گئے",
                               "گئےکوئی": "گئے کوئی",
                               "کےگاؤں": "کے گاؤں",
                               "تومنسوب": "تو منسوب",
                               "مگراسے": "مگر اسے",
                               "اسےماڈل": "اسے ماڈل",
                               "سےسولہ": "سے سولہ",
                               "سےملاقاتیں": "سے ملاقاتیں",
                               "کاپہاڑ": "کا پہاڑ",
                               "پہاڑٹوٹ": "پہاڑ ٹوٹ",
                               "پڑاخوشیوں": "پڑا خوشیوں",
                               "پردیوار": "پر دیوار",
                               "دیوارگر": "دیوار گر",
                               "گرگئی": "گر گئی",
                               "دھماکاہوا": "دھماکا ہوا",
                               "پہنچائےگئے": "پہنچائے گئے",
                               "توبچے": "تو بچے",
                               "بچےزخموں": "بچے زخموں",
                               "سےچور": "سے چور",
                               "پہنچےاور": "پہنچے اور",
                               "اوربتایا": "اور بتایا",
                               "لےلیے": "لے لیے",
                               "لیےگئے": "لیے گئے",
                               "افرادکا": "افراد کا",
                               "کاٹائم": "کا ٹائم",
                               "شایدجانیں": "شاید جانیں",
                               "واقعےکا": "واقعے کا",
                               "لیتےہوئے": "لیتے ہوئے",
                               "ہوئےرپورٹ": "ہوئے رپورٹ",
                               "پشاورکی": "پشاور کی",
                               "سےدھرنا": "سے دھرنا",
                               "ہزارووٹ": "ہزار ووٹ",
                               "نکلےہیں": "نکلے ہیں",
                               "کےپولنگ": "کے پولنگ",
                               "اسٹیشنزکی": "اسٹیشنز کی",
                               "اگروہ": "اگر وہ",
                               "ایازصادق": "ایاز صادق",
                               "پہلےدن": "پہلے دن",
                               "کاکہہ": "کا کہہ",
                               "نےسوال": "نے سوال",
                               "جیتنےوالا": "جیتنے والا",
                               "والااسپیکر": "والا اسپیکر",
                               "اسپیکرڈیڑھ": "اسپیکر ڈیڑھ",
                               "سےکیسے": "سے کیسے",
                               "کیسےقومی": "کیسے قومی",
                               "چلارہا": "چلا رہا",
                               "پھردہرایا": "پھر دہرایا",
                               "دہرایاکہ": "دہرایا کہ",
                               "اوردھاندلی": "اور دھاندلی",
                               "والےجمہوریت": "والے جمہوریت",
                               "کےدشمن": "کے دشمن",
                               "پرنکل": "پر نکل",
                               "کرحکومت": "کر حکومت",
                               "کاچلنا": "کا چلنا",
                               "ہندوآبادی": "ہندو آبادی",
                               "افرادمیں": "افراد میں",
                               "سپیکرگیلری": "سپیکر گیلری",
                               "کچلنےپر": "کچلنے پر",
                               "پربھرپور": "پر بھرپور",
                               "بھرپورحمایت": "بھرپور حمایت",
                               "اورساڑھے": "اور ساڑھے",
                               "اورفیصلے": "اور فیصلے",
                               "سیکریٹریزخارجہ": "سیکریٹریز خارجہ",
                               "گاپاکستان": "گا پاکستان",
                               "چھوڑدیا": "چھوڑ دیا",
                               "لیےعطیات": " لیے عطیات",
                               "دفترپر": "دفتر پر",
                               "زیراستعمال": "زیر استعمال",
                               "شکارپورواقعہ": "شکارپور واقعہ",
                               "کاانتخاب": "کا انتخاب",
                               "اوردوسرے": "اور دوسرے",
                               "پرچلنے": "پر چلنے",
                               "ریٹیلراسٹور": "ریٹیلر اسٹور",
                               "گھریلوملازم": "گھریلو ملازم",
                               "کارڈبھارت": "کارڈ بھارت",
                               "پروفیسراور": "پروفیسر اور",
                               "بولرکا": "بولر کا",
                               "کاباؤنسر": "کا باؤنسر",
                               "مسافرملائیشیا": "مسافر ملائیشیا",
                               "ہتھیاراٹھانا": "ہتھیار اٹھانا",
                               "ہتھیاررکھنے": "ہتھیار رکھنے",
                               "اور باقاعدہ": "اورباقاعدہ",
                               "ڈاکٹرباربرا": "ڈاکٹر باربرا",
                               "بوڑھےاور": "بوڑھے اور",
                               "کےگائوں": "کے گائوں",
                               "نبھایاہے": "نبھایا ہے",
                               "فیصلےکر": "فیصلے کر",
                               "کرسکتی": "کر سکتی",
                               "اورجدید": "اور جدید",
                               "استعفےمنظور": "استعفے منظور",
                               "کرلیے": "کر لیے",
                               "ڈلیوریزکا": "ڈلیوریز کا",
                               "اوررابطہ": "اور رابطہ",
                               "وزیربرائے": "وزیر برائے",
                               "پیداکرنے": "پیدا کرنے",
                               "اوربالخصوص": "اور بالخصوص",
                               "پرچہرے": "پر چہرے",
                               "نئےجوڑے": "نئے جوڑے",
                               "پرامریکا": "پر امریکا",
                               "لڑرہے": "لڑ رہے",
                               "ہرمحاذ": "ہر محاذ",
                               "پرلڑ": "پر لڑ",
                               "محاذپر": "محاذ پر",
                               "توتیار": "تو تیار",
                               "دیناپڑے": "دینا پڑے",
                               "ہزارکلو": "ہزار کلو",
                               "میٹرلمبی": "میٹر لمبی",
                               "کوتیار": "کو تیار",
                               "تیارہیں": "تیار ہیں",
                               "مدنظررکھا": "مدنظر رکھا",
                               "جائیگااور": "جائیگا اور",
                               "مدنظررکھنا": "مدنظر رکھنا",
                               "رکھناچاہئے": "رکھنا چاہئے",
                               "اوربجلی": "اور بجلی",
                               "اوربائیو": "اور بائیو",
                               "قیداور": "قید اور",
                               "اورجرمانے": "اور جرمانے",
                               "پرگجرانوالہ": "پر گجرانوالہ",
                               "پراپنی": "پر اپنی",
                               "اورملازمین": "اور ملازمین",
                               "اورٹرانسپورٹ": "اور ٹرانسپورٹ",
                               "اجراءکرنے": "اجراء کرنے",
                               "اہلکارطیارے": "اہلکار طیارے",
                               "لگناچاہئے": "لگنا چاہئے",
                               "اورجماعت": "اور جماعت",
                               "متاثرہونے": "متاثر ہونے",
                               "اگروزیراعظم": "اگر وزیراعظم",
                               "روزگارکی": "روزگار کی",
                               "نکلواسکتا": "نکلوا سکتا",
                               "پرپرویز": "پر پرویز",
                               "پرویزخٹک": "پرویز خٹک",
                               "تونواز": "تو نواز",
                               "کو کاٹے": "کو کاٹے",
                               "بغیر اینڈواسکوپک": "بغیر اینڈواسکوپک",
                               "اپنےگاہکوں": "اپنے گاہکوں",
                               "سہرااپنے": "سہرا اپنے",
                               "سرپر": "سر پر",
                               "پرسجا": "پر سجا",
                               "سجالے": "سجا لے",
                               "والاروبوٹ": "والا روبوٹ",
                               "کےگلے": "کے گلے",
                               "گلےکاٹنے": "گلے کاٹنے",
                               "مولانامظہر": "مولانا مظہر",
                               "چھوڑدیتے": "چھوڑ دیتے",
                               "اداکاراور": "اداکار اور",
                               "ٹیکسزنافذ": "ٹیکسز نافذ",
                               "تعمیرکرنے": "تعمیر کرنے",
                               "رہنماءاور": "رہنماء اور",
                               "ڈاکٹربابر": "ڈاکٹر بابر",
                               "پھیلاناشروع": "پھیلانا شروع",
                               "لہذامجھے": "لہذا مجھے",
                               "لاہورڈیویلپمنٹ": "لاہور ڈیویلپمنٹ",
                               "چیخناچلانا": "چیخنا چلانا",
                               "چلاناشروع": "چلانا شروع",
                               "گیابھارتی": "گیا بھارتی",
                               "آزادکشمیرس": "آزاد کشمیرس",
                               "کشمیرسے": "کشمیر سے",
                               "ہوناچاہیے": "ہونا چاہیے",
                               "عبدالقادرکا": "عبدالقادر کا",
                               "مولاناعبدالعزیز": "مولانا عبدالعزیز",
                               "عبدالعزیزکو": "عبدالعزیز کو",
                               "محدودرکھنا": "محدود رکھنا",
                               "رکھناچاہتے": "رکھنا چاہتے",
                               "اغواکروایا": "اغوا کروایا",
                               "پالتوجانوروں": "پالتو جانوروں",
                               "کہناچاہتا": "کہنا چاہتا",
                               "چاہتاہوں": "چاہتا ہوں",
                               "رکنایقینا": "رکنا یقینا",
                               "ملائیشیاءجیسے": "ملائیشیاء جیسے",
                               "طلباءکو": "طلباء کو",
                               "ترٹیکنالوجی": "تر ٹیکنالوجی",
                               "فضاءمیں": "فضاء میں",
                               "نظررکھنے": "نظر رکھنے",
                               "یانکلوانے": "یا نکلوانے",
                               "اورقومی": "اور قومی",
                               "پھوڑدیا": "پھوڑ دیا",
                               "رہناضروری": "رہنا ضروری",
                               "بازرنز": "باز رنز",
                               "رنزجوڑ": "رنز جوڑ",
                               "جوڑرہے": "جوڑ رہے",
                               "انڈونیشیاءاور": "انڈونیشیاء اور",
                               "پہنچاتاہے": "پہنچاتا ہے",
                               "پوچھناچاہیے": "پوچھنا چاہیے",
                               "سروےکے": "سروے کے",
                               "کروایاگیا": "کروایا گیا",
                               "کاشہزادے": "کاشہزادے",
                               "لیےقدرتی": " لیے قدرتی",
                               "تھاتاکہ": "تھا تاکہ",
                               "کولکھے": "کو لکھے",
                               "وزیربنانا": "وزیر بنانا",
                               "بڑھالیتے": "بڑھا لیتے",
                               "جیسےمشہور": "جیسے مشہور",
                               "باوجوداہلکار": "باوجود اہلکار",
                               "اہلکاراپنے": "اہلکار اپنے",
                               "خواہشمندباقی": "خواہشمند باقی",
                               "ضروربہتر": "ضرور بہتر",
                               "بکرابنایا": "بکرا بنایا",
                               "بلاناچاہیے": "بلانا چاہیے",
                               "آباداپنے": "آباد اپنے",
                               "فائیواسٹار": "فائیو اسٹار",
                               "روزگارہوگئے": "روزگار ہوگئے",
                               "اورمختار": "اور مختار",
                               "دھکادیا": "دھکا دیا",
                               "اوراطراف": "اور اطراف",
                               "باہراور": "باہر اور",
                               "بنایااور": "بنایا اور",
                               "سمندرپر": "سمندر پر",
                               "رکھتاتھا": "رکھتا تھا",
                               "بناناشروع": "بنانا شروع",
                               "سمجھاجانا": "سمجھا جانا",
                               "سزاسمجھا": "سزا سمجھا",
                               "گرفتارملزمان": "گرفتار ملزمان",
                               "پردربدر": "پر دربدر",
                               "دربدربھٹکتے": "دربدر بھٹکتے",
                               "کھاناکھا": "کھانا کھا",
                               "کھارہے": "کھا رہے",
                               "کرناچاہتا": "کرنا چاہتا",
                               "بازوآیا": "بازو آیا",
                               "کابازو": "کا بازو",
                               "اشتہاردیا": "ااشتہار دیا",
                               "گھرخریدنے": "گھر خریدنے",
                               "کاغذاور": "کاغذ ور",
                               "سےعلاقے": "سے علاقے",
                               "سرشارہو": "سرشار ہو",
                               "کرجب": "کر جب",
                               "پرکھو": "پر کھو",
                               "کھوجانا": "کھو جانا",
                               "اورہاتھ": "اور ہاتھ",
                               "بھجواتاتھ": "بھجواتا تھا",
                               "امداددینے": "امداد دینے",
                               "والاسب": "والا سب",
                               "گاجراور": "گاجر اور",
                               "اورکدو": "اور کدو",
                               "تاخیرہوتی": "تاخیر ہوتی",
                               "اتاردیتے": "اتار دیتے",
                               "کراتار": "کر اتار",
                               "بھرپورفائدہ": "بھرپور فائدہ",
                               "میرےگھر": "میرے گھر",
                               "اگرمیرے": "اگر میرے",
                               "گھرسے": "گھر سے",
                               "گھرکے": "گھر کے",
                               "اندرنہیں": "اندر نہیں",
                               "اوپردباؤ": "اوپر دباؤ",
                               "دباؤڈالنے": "دباؤ ڈالنے",
                               "سہارالے": "سہارا لے",
                               "تیزرفتار": "تیز رفتار",
                               "معمرخاتون": "معمر خاتون",
                               "کوکاٹے": "کو کاٹے",
                               "گاان": "گا ان",
                               "آگیا": "آ گیا",
                               "حسیناکا": "حسینا کا"
                               }


def fix_join_words(text: str) -> str:
    """
    Replace all join ``urdu`` words with separate words

    Args:
        text (str): raw ``urdu`` text

    Returns:
        str: returns a ``str`` object containing normalized text.
    """
    for key, value in WORDS_SPACE.items():
        text = text.replace(key, value)
    return text
