# Generated by Django 3.2.13 on 2022-07-01 13:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import tinymce.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('notifications', '0004_auto_20200915_1222'),
    ]

    operations = [
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('os', models.IntegerField(choices=[(0, 'IOS'), (1, 'Android')])),
                ('token', models.CharField(max_length=255, unique=True)),
                ('arn', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('active', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Device',
                'verbose_name_plural': 'Devices',
            },
        ),
        migrations.CreateModel(
            name='NotificationTopic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(max_length=256, verbose_name='Topic name')),
                ('language', models.CharField(choices=[('is', 'Íslenska'), ('en', 'English')], max_length=6, verbose_name='Language for topic')),
                ('arn', models.CharField(blank=True, help_text='ARN used to identify topic in AWS SNS', max_length=256, null=True, verbose_name='Topic ARN')),
            ],
            options={
                'verbose_name': 'Notification topic',
                'verbose_name_plural': 'Notification topics',
            },
        ),
        migrations.AlterModelOptions(
            name='notification',
            options={'verbose_name': 'Notification', 'verbose_name_plural': 'Notifications'},
        ),
        migrations.AlterModelOptions(
            name='usernotification',
            options={'verbose_name': 'User notification', 'verbose_name_plural': 'User notifications'},
        ),
        migrations.AddField(
            model_name='notification',
            name='aws_sns_id',
            field=models.UUIDField(blank=True, default=None, help_text='Message id in AWS, if notification is a push notification', null=True, verbose_name='Id of notification in AWS SNS'),
        ),
        migrations.AddField(
            model_name='notification',
            name='notification_type',
            field=models.IntegerField(choices=[(0, 'Web notification'), (1, 'Push notification'), (2, 'Email notification (not implemented)')], default=0, verbose_name='Notification type'),
        ),
        migrations.AlterField(
            model_name='notification',
            name='attachment',
            field=models.FileField(blank=True, default=None, null=True, upload_to=''),
        ),
        migrations.AlterField(
            model_name='notification',
            name='expires',
            field=models.DateTimeField(blank=True, default=None, help_text='Notification will not be shown after this time.', null=True),
        ),
        migrations.AlterField(
            model_name='notification',
            name='look',
            field=models.CharField(choices=[('SIGN_COMPANY', 'Sign Company'), ('SIMPLE_OK', 'Simple Ok'), ('RELEASE_NOTES', 'Release Notes')], default='SIMPLE_OK', help_text='This controls the appearance of the notification.', max_length=50),
        ),
        migrations.AlterField(
            model_name='notification',
            name='message',
            field=tinymce.models.HTMLField(help_text='Full message as shown to user'),
        ),
        migrations.AlterField(
            model_name='notification',
            name='name',
            field=models.CharField(help_text='Used to reference notification, shown in title for some looks', max_length=250, unique=True),
        ),
        migrations.AlterField(
            model_name='notification',
            name='needs_approval',
            field=models.BooleanField(default=False, help_text='Set this field if approval is necessary, see snooze time.'),
        ),
        migrations.AlterField(
            model_name='notification',
            name='snooze_time',
            field=models.IntegerField(blank=True, default=None, help_text='If user dismisses message (when relevant), message is shown again after this many days.', null=True),
        ),
        migrations.AlterField(
            model_name='usernotification',
            name='answer',
            field=models.BooleanField(blank=True, default=None, null=True),
        ),
        migrations.CreateModel(
            name='SentToDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sent_at', models.DateTimeField(auto_now_add=True)),
                ('message_id', models.UUIDField(blank=True, null=True, verbose_name='Message id in AWS')),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.device')),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.notification')),
            ],
        ),
        migrations.AddField(
            model_name='device',
            name='sent_notifications',
            field=models.ManyToManyField(related_name='sent_to_devices', through='notifications.SentToDevice', to='notifications.Notification'),
        ),
        migrations.AddField(
            model_name='device',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='devices', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='notification',
            name='topic',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sent_notifications', to='notifications.notificationtopic'),
        ),
        migrations.CreateModel(
            name='DeviceSubscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('device_arn', models.CharField(help_text='ARN for device subscribed to topic', max_length=255, verbose_name='Device arn')),
                ('arn', models.CharField(help_text='Used to identify subscription in AWS', max_length=255, verbose_name='Subscription ARN')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('topic', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='notifications.notificationtopic')),
            ],
            options={
                'verbose_name': 'Device subscriptions',
                'abstract': False,
                'unique_together': {('device_arn', 'topic_id')},
            },
        ),
    ]
