"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        // const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey');
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: data_plane,
        });
        //TODO : Error: kong-dp/KongEksDp/KongPreReqsStack/AutoScalar/KarpenterNodeRole should be defined in the scope of the kong-dp stack to prevent circular dependencies
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.MetricsServer(kong_pre_requisites_nested_stack, 'MetricsServer', {
            cluster: data_plane,
        });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        new index_1.KongDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_core.Namespace.KONG_DATA_PLANE,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemetryDns,
            // nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_DP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                'kong-dp.internal',
                'admin.kong-cp.internal',
                'cluster.kong-cp.internal',
                'telemetry.kong-cp.internal',
                'manager.kong-cp.internal',
            ],
            hostedZoneName: 'kong-dp.internal',
        });
        kong_data_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "2.0.4" };
//# sourceMappingURL=data:application/json;base64,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