# coding: utf-8

"""
    Monitor API

    An API for an integrator to access the features of DocuSign Monitor  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_monitor.client.configuration import Configuration


class WebQuery(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'filters': 'list[object]',
        'aggregations': 'list[object]',
        'query_scope': 'str',
        'query_scope_id': 'str'
    }

    attribute_map = {
        'filters': 'filters',
        'aggregations': 'aggregations',
        'query_scope': 'queryScope',
        'query_scope_id': 'queryScopeId'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """WebQuery - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._filters = None
        self._aggregations = None
        self._query_scope = None
        self._query_scope_id = None
        self.discriminator = None

        setattr(self, "_{}".format('filters'), kwargs.get('filters', None))
        setattr(self, "_{}".format('aggregations'), kwargs.get('aggregations', None))
        setattr(self, "_{}".format('query_scope'), kwargs.get('query_scope', None))
        setattr(self, "_{}".format('query_scope_id'), kwargs.get('query_scope_id', None))

    @property
    def filters(self):
        """Gets the filters of this WebQuery.  # noqa: E501


        :return: The filters of this WebQuery.  # noqa: E501
        :rtype: list[object]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this WebQuery.


        :param filters: The filters of this WebQuery.  # noqa: E501
        :type: list[object]
        """

        self._filters = filters

    @property
    def aggregations(self):
        """Gets the aggregations of this WebQuery.  # noqa: E501


        :return: The aggregations of this WebQuery.  # noqa: E501
        :rtype: list[object]
        """
        return self._aggregations

    @aggregations.setter
    def aggregations(self, aggregations):
        """Sets the aggregations of this WebQuery.


        :param aggregations: The aggregations of this WebQuery.  # noqa: E501
        :type: list[object]
        """

        self._aggregations = aggregations

    @property
    def query_scope(self):
        """Gets the query_scope of this WebQuery.  # noqa: E501


        :return: The query_scope of this WebQuery.  # noqa: E501
        :rtype: str
        """
        return self._query_scope

    @query_scope.setter
    def query_scope(self, query_scope):
        """Sets the query_scope of this WebQuery.


        :param query_scope: The query_scope of this WebQuery.  # noqa: E501
        :type: str
        """
        allowed_values = ["OrganizationId"]  # noqa: E501
        if (self._configuration.client_side_validation and
                query_scope not in allowed_values):
            raise ValueError(
                "Invalid value for `query_scope` ({0}), must be one of {1}"  # noqa: E501
                .format(query_scope, allowed_values)
            )

        self._query_scope = query_scope

    @property
    def query_scope_id(self):
        """Gets the query_scope_id of this WebQuery.  # noqa: E501


        :return: The query_scope_id of this WebQuery.  # noqa: E501
        :rtype: str
        """
        return self._query_scope_id

    @query_scope_id.setter
    def query_scope_id(self, query_scope_id):
        """Sets the query_scope_id of this WebQuery.


        :param query_scope_id: The query_scope_id of this WebQuery.  # noqa: E501
        :type: str
        """

        self._query_scope_id = query_scope_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebQuery, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebQuery):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WebQuery):
            return True

        return self.to_dict() != other.to_dict()
