# This package will contain the spiders of your Scrapy project
#
# Please refer to the documentation for information on how to create and manage
# your spiders.

import scrapy

from os_scrapy_linkextractor.items import ExampleItem
from os_scrapy_linkextractor.lx_extensions import LxExtensionManager


class ExampleSpider(scrapy.Spider):
    """ ExampleSpider
    Auto generated by os-scrapy-cookiecuter

    Run:
        scrapy crawl example
    """

    name = "example"

    def start_requests(self):
        yield scrapy.Request(
            url="http://www.example.com",
            meta={
                "extractor.rules": [
                    {"type": "re", "allow_domains": [], "deny_domains": []},
                    {
                        "type": "lxml",
                        "allow": [],
                        "deny": [],
                        "allow_domains": [],
                        "deny_domains": [],
                        "restrict_xpaths": [],
                        "tags": ["a", "area"],
                        "attrs": ["href"],
                        "restrict_css": [],
                    }
                ]
            },
        )

    def parse(self, response):
        response = self.lx_manager.process_response(response)
        return ExampleItem(
                url=response.url,
                request_headers=response.request.headers,
                response_headers=response.headers,
                status=response.status,
                meta=response.meta,
                body=response.body,
            )

    def _set_lxmanager(self, crawler):
        self.lx_manager = LxExtensionManager.from_crawler(crawler)

    @classmethod
    def from_crawler(cls, crawler, *args, **kwargs):
        spider = super().from_crawler(crawler, *args, **kwargs)
        spider._set_lxmanager(crawler)
        return spider
