/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;

public class TimeScaleCompressed
implements TimeScale {
    private final double scale;
    private final TimeScale daily;

    public TimeScaleCompressed(Day calendar, double scale) {
        this.daily = new TimeScaleDaily(calendar, null);
        this.scale = scale;
    }

    @Override
    public double getStartingPosition(Day instant) {
        return this.daily.getStartingPosition(instant) * this.scale;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.daily.getEndingPosition(instant) * this.scale;
    }

    @Override
    public double getWidth(Day instant) {
        return this.daily.getWidth(instant) * this.scale;
    }

    @Override
    public boolean isBreaking(Day instant) {
        return instant.getDayOfWeek() == DayOfWeek.SUNDAY;
    }
}

