/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.command.CommandColorTask;
import net.sourceforge.plantuml.project.command.CommandFootbox;
import net.sourceforge.plantuml.project.command.CommandGanttArrow;
import net.sourceforge.plantuml.project.command.CommandGanttArrow2;
import net.sourceforge.plantuml.project.command.CommandNoteBottom;
import net.sourceforge.plantuml.project.command.CommandPage;
import net.sourceforge.plantuml.project.command.CommandPrintBetween;
import net.sourceforge.plantuml.project.command.CommandPrintScale;
import net.sourceforge.plantuml.project.command.CommandSeparator;
import net.sourceforge.plantuml.project.command.CommandWeekNumberStrategy;
import net.sourceforge.plantuml.project.command.NaturalCommand;
import net.sourceforge.plantuml.project.lang.SentenceAnd;
import net.sourceforge.plantuml.project.lang.SentenceAndAnd;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.SubjectDayAsDate;
import net.sourceforge.plantuml.project.lang.SubjectDayOfWeek;
import net.sourceforge.plantuml.project.lang.SubjectDaysAsDates;
import net.sourceforge.plantuml.project.lang.SubjectProject;
import net.sourceforge.plantuml.project.lang.SubjectResource;
import net.sourceforge.plantuml.project.lang.SubjectTask;
import net.sourceforge.plantuml.project.lang.SubjectToday;
import net.sourceforge.plantuml.style.CommandStyleImport;
import net.sourceforge.plantuml.style.CommandStyleMultilinesCSS;

public class GanttDiagramFactory
extends PSystemCommandFactory {
    private static final Collection<Command> cache = new ArrayList<Command>();

    private static final List<Subject> subjects() {
        return Arrays.asList(new SubjectTask(), new SubjectProject(), new SubjectDayOfWeek(), new SubjectDayAsDate(), new SubjectDaysAsDates(), new SubjectResource(), new SubjectToday());
    }

    public GanttDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.addTitleCommands(cmds);
        this.addCommonCommands2(cmds);
        cmds.add(new CommandStyleMultilinesCSS());
        cmds.add(new CommandStyleImport());
        cmds.add(new CommandNope());
        cmds.addAll(GanttDiagramFactory.getLanguageCommands());
        cmds.add(new CommandGanttArrow());
        cmds.add(new CommandGanttArrow2());
        cmds.add(new CommandColorTask());
        cmds.add(new CommandSeparator());
        cmds.add(new CommandWeekNumberStrategy());
        cmds.add(new CommandPrintScale());
        cmds.add(new CommandPrintBetween());
        cmds.add(new CommandPage());
        cmds.add(new CommandNoteBottom());
        cmds.add(new CommandFootbox());
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Command> getLanguageCommands() {
        Collection<Command> collection = cache;
        synchronized (collection) {
            if (cache.size() == 0) {
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        cache.add(NaturalCommand.create(sentenceSimple));
                        for (SentenceSimple sentenceSimple2 : subject.getSentences()) {
                            if (sentenceSimple.getVerbPattern().equals(sentenceSimple2.getVerbPattern())) continue;
                            cache.add(NaturalCommand.create(new SentenceAnd(sentenceSimple, sentenceSimple2)));
                        }
                    }
                }
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        for (SentenceSimple sentenceSimple3 : subject.getSentences()) {
                            for (SentenceSimple sentenceSimple4 : subject.getSentences()) {
                                if (sentenceSimple.getVerbPattern().equals(sentenceSimple3.getVerbPattern()) || sentenceSimple.getVerbPattern().equals(sentenceSimple4.getVerbPattern()) || sentenceSimple4.getVerbPattern().equals(sentenceSimple3.getVerbPattern())) continue;
                                cache.add(NaturalCommand.create(new SentenceAndAnd(sentenceSimple, sentenceSimple3, sentenceSimple4)));
                            }
                        }
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public GanttDiagram createEmptyDiagram() {
        return new GanttDiagram();
    }
}

