/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends PlainDiagram {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6sWD0AmFkBap0wp4H6CjU-RENbb-8cPf4i7oFA4uiOZJNK3y0UwT7lSRwI-YAxltJJEYrckJSaPHV13qW7UtXVQXzBy-27EYV0Z-tGWU80D4ITH6jIptfDXjcof3Il3lEr_v9UWTth51eZbAgyMHwq-_8GFlEsFpx3GsNZsQe2y2FmRsrVzTJelBGo7Cqcm5Hc3KQOHRtMF_7mLLrwXs9rN3JZ-cKxagXgkYAh7PzgQ8LjBSCIlKjVDHeyb5CMafKjoja8RRw4neoCdi4sI31eqVweVmPdE5fOmpWJZQ4A7hwxqT-quilr3YWyWHOe7XWJcGSbWMKUBSKD1m262ecqKrjgHopnCZAFpGGjxyeP5KF5BEd0uN3QS7GE3s32gGz44Dcd1sw6v0nP5iqM69gwwC6qlpTLYUoXv9myt4mic2La0DGVu7NU3fiSP7KsVR38wadYPvdROIzMVYxRJD1NsZQvE4zRMrQQQFAqLP8jMrZS_HNlC8mDrIAw_uCkQ8vm3DVlEg8giVBP0VWUwh2LloPzdlB2GXh6tO1-ewLnyULOHZCcIQMCVlPjjhsIzq1IORaB02BEdlXgyhJN2mXQvS7W6Uq2gcMUS3XRIqUh_eyMNjFk6QOebxuwBtCS9I-kzNVPWPYWDqeCmiw9e5Yt8rhTgBBOXWZz2f0JU5P2ESLzVbkFguI1_v2O2ta16GmuRG2F7yaahNKGZLaQbhqbm0p9zMsgBXieH1kNP1DwDAB5HMgprELsVwiZ5td_J1yrQ3COfZEgcniDozAjB3i5WrchDtQqTfJi4p-JZEgzvpC5S1hYsyHtnmppyo46TwPI1ISiXZtuT_PEbMOJ6BDjVDgdHNzOE3Xsu-S3UBPZ6ZJ1woB1WSJqHB_KhafoN3tq78PlbhTR5Fi3bTfuO8CxBWzjBacfeSqt2OpdAix2A4HorUSIeeN4ImbwKbsSAcK7d6wb58oE-OJo9IMHPA0zQMkmBFf7iKvE6y1rOjgrjJIIwWYcmcY4aBLhLKSQIl1J9mhQ9dfdLY-zC22-hI7cFY38VYAoRQgjoGWIamCqJuXK4afW-afVIIaqG4_kVFNUgbrphuyPqnV38EaZqa4L15ndJgYMgcxdOC6yPwYRzVB-Nc8_ZphptQvDHez_mCGRGE4W8mmWkubFk54JmD_7Ksz08EiKA8DXAkNBNqB92mO3FUkObwS9jHlOd9ScDoqIloGnN_DfMeS38swBY8fJXQBAdIoyrgK0Ljt_okmqqEYh-BAaCYkUpDpcGaR1IgE3V7RcqOch4P0tXG7RK9jDtrsscMLuqvNv5K6Pu6vDiDEPNg4LfOKzFoiH1OBSRjlQNzbDFZFnde5zGw-zYhXuQ3N5tVRgBXMnUadp6I62vITaJGMsfEBF3mJGHvKIsKZgLjC-pimGhv3RoC5n8EsS47abfUfQnoGmxTGlQEQfIVAAA6i40kB5ReAcAXbEE154d1dDKoaI7be2_OrnE0KnGSx-yj29UTQ7v6i_RsZ48obsxk9XL4DfoVHMAJagqUER2VbhbiyuhSZbgamuvzExxZVFiZwkQB2382CIq9NgiBVNTZbraQDjEUwpGuZilSF9Zy0dP5EqyPs1ecMv2bR0OgdWGWTiYWmenNyglvY6lE1VBl_KOf33JXUU8qkl5S2rQHhJOY9GrekSaIklRzZfkS72YSM6nmOOcvqSC4YawlKsq_QRCiWqeKBXLVsCEiPbEgV6JOGNFPQkVLzWG0";

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

