/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import net.sourceforge.plantuml.dedication.BlumBlumShub;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.Noise;
import net.sourceforge.plantuml.dedication.PSystemDedication;
import net.sourceforge.plantuml.dedication.RBlocks;
import net.sourceforge.plantuml.utils.MTRandom;

public class DedicationCrypted
implements Dedication {
    private final String argon2;
    private final BigInteger pq;
    private final byte[] crypted;
    private final int tinyHash;
    private String solution;
    private long next = 0L;

    public DedicationCrypted(byte[] crypted, int tinyHash, String argon2, BigInteger pq) {
        this.crypted = crypted;
        this.pq = pq;
        this.argon2 = argon2;
        this.tinyHash = tinyHash;
    }

    @Override
    public synchronized BufferedImage getImage(String sentence) {
        if (sentence.length() < 40) {
            return null;
        }
        try {
            if (this.solution == null || !sentence.equals(this.solution)) {
                if (System.currentTimeMillis() < this.next) {
                    return null;
                }
                int tinyHash = Noise.shortHash(sentence.getBytes("UTF-8"), N.toByteArray());
                if (this.tinyHash != tinyHash) {
                    return null;
                }
                this.next = System.currentTimeMillis() + 5000L;
            }
            byte[] hash1 = Noise.computeArgon2bytes(sentence.getBytes("UTF-8"), (this.pq.toString(35) + sentence).getBytes("UTF-8"));
            byte[] hash2 = Noise.computeArgon2bytes(sentence.getBytes("UTF-8"), (this.pq.toString(36) + sentence).getBytes("UTF-8"));
            BlumBlumShub rndBBS = new BlumBlumShub(this.pq, hash1);
            MTRandom rndMT = new MTRandom(hash2);
            byte[] current = (byte[])this.crypted.clone();
            Noise.shuffle(current, rndMT);
            Noise.xor(current, rndBBS);
            Noise.xor(current, sentence.getBytes("UTF-8"));
            Noise.shuffle(current, rndMT);
            RBlocks init = RBlocks.readFrom(current, 513);
            RBlocks decoded = init.change(E, N);
            current = decoded.toByteArray(512);
            Noise.shuffle(current, rndMT);
            Noise.xor(current, rndBBS);
            String argon = Noise.computeArgon2String(current, (this.pq.toString(34) + sentence).getBytes("UTF-8"));
            if (!this.argon2.equals(argon)) {
                return null;
            }
            Noise.shuffle(current, rndMT);
            current = Noise.reverse(current, rndMT.nextInt());
            BufferedImage img = PSystemDedication.getBufferedImage(new ByteArrayInputStream(current));
            this.solution = sentence;
            return img;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

