/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2;

public class Util {
    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static long littleEndianBytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static byte[] intToLittleEndianBytes(int a) {
        byte[] result = new byte[]{(byte)(a & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 24 & 0xFF)};
        return result;
    }

    public static byte[] longToLittleEndianBytes(long a) {
        byte[] result = new byte[]{(byte)(a & 0xFFL), (byte)(a >> 8 & 0xFFL), (byte)(a >> 16 & 0xFFL), (byte)(a >> 24 & 0xFFL), (byte)(a >> 32 & 0xFFL), (byte)(a >> 40 & 0xFFL), (byte)(a >> 48 & 0xFFL), (byte)(a >> 56 & 0xFFL)};
        return result;
    }

    public static long intToLong(int x) {
        byte[] intBytes = Util.intToLittleEndianBytes(x);
        byte[] bytes = new byte[8];
        System.arraycopy(intBytes, 0, bytes, 0, 4);
        return Util.littleEndianBytesToLong(bytes);
    }
}

