"""

A Python library for implementing various historical ciphers.

This library provides functionalities to encrypt and decrypt messages using a variety of historical ciphers.

Currently supported ciphers include:

- Affine Cipher
- Atbash Cipher
- Baconian Cipher
- Bifid Cipher
- Caesar Cipher
- Columnar Transposition Cipher
- Morse Code
- Playfair Cipher
- Rail Fence Cipher
- ROT13 Cipher
- Vernam Cipher
- Vigenère Cipher (Standard, Beaufort, Gronsfeld, and Running Key variants)

## Important Notes:

- This library's implementations can handle non-English characters.
- **Security Disclaimer**: These ciphers are for educational purposes only and should never be used for serious encryption. They are easily breakable and offer no real security for sensitive information.
- **Future Enhancements**: There is a plan to add support for additional ciphers and potentially other languages in future releases.
- **Contributing**: I would gratefully appreciate any help in improving this package! Please report any errors, bugs, performance/efficiency issues you may encounter.
"""