Ciphergeard
====================

Ciphergeard is a small package which implements some famous ancient ciphers in Python.
The name '**Ciphergeard**' is made up of 2 words - '**Cipher**' and '**geard**'.
**Geard** is the old English word for '**garden**'. So **Ciphergeard** is basically '**Cipher Garden**'.

I just randomly thought about using the word 'garden' and stuck with it.

This library provides functionalities to encrypt and decrypt messages using a variety of historical ciphers.

Currently supported ciphers include:

- Affine Cipher
- Atbash Cipher
- Baconian Cipher
- Bifid Cipher
- Caesar Cipher
- Columnar Transposition Cipher
- Morse Code
- Playfair Cipher
- Rail Fence Cipher
- ROT13 Cipher
- Vernam Cipher
- Vigenère Cipher (Standard, Beaufort, Gronsfeld, and Running Key variants)

## Important Notes:

- This library's implementations can handle non-English characters.
- **Security Disclaimer**: These ciphers are for educational purposes only and should never be used for serious encryption. They are easily breakable and offer no real security for sensitive information.
- **Future Enhancements**: There is a plan to add support for additional ciphers and potentially other languages in future releases.
- **Contributing**: I would gratefully appreciate any help in improving this package! Please report any errors, bugs, performance/efficiency issues you may encounter.

## Documentation

You can check out the detailed documentation at [Ciphergeard Documentation](https://ciphergeard.readthedocs.io/en/latest/index.html)

## Contact

You can contact me on my email - ivoscev@gmail.com