"""
    PandaDoc Public API

    PandaDoc Public API documentation  # noqa: E501

    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pandadoc_client.api_client import ApiClient, Endpoint as _Endpoint
from pandadoc_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pandadoc_client.model.api_log_details_response import APILogDetailsResponse
from pandadoc_client.model.api_log_list_response import APILogListResponse


class APILogsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.details_log_endpoint = _Endpoint(
            settings={
                'response_type': (APILogDetailsResponse,),
                'auth': [
                    'apiKey',
                    'oauth2'
                ],
                'endpoint_path': '/public/v1/logs/{id}',
                'operation_id': 'details_log',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_logs_endpoint = _Endpoint(
            settings={
                'response_type': (APILogListResponse,),
                'auth': [
                    'apiKey',
                    'oauth2'
                ],
                'endpoint_path': '/public/v1/logs',
                'operation_id': 'list_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'since',
                    'to',
                    'count',
                    'page',
                    'statuses',
                    'methods',
                    'search',
                    'environment_type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'statuses',
                    'methods',
                    'environment_type',
                ],
                'validation': [
                    'count',
                    'page',
                ]
            },
            root_map={
                'validations': {
                    ('count',): {

                        'inclusive_minimum': 1,
                    },
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('statuses',): {

                        "100": 100,
                        "200": 200,
                        "300": 300,
                        "400": 400,
                        "500": 500
                    },
                    ('methods',): {

                        "GET": "GET",
                        "POST": "POST",
                        "PUT": "PUT",
                        "PATCH": "PATCH",
                        "DELETE": "DELETE"
                    },
                    ('environment_type',): {

                        "PRODUCTION": "PRODUCTION",
                        "SANDBOX": "SANDBOX"
                    },
                },
                'openapi_types': {
                    'since':
                        (str,),
                    'to':
                        (str,),
                    'count':
                        (int,),
                    'page':
                        (int,),
                    'statuses':
                        ([int],),
                    'methods':
                        ([str],),
                    'search':
                        (str,),
                    'environment_type':
                        (str,),
                },
                'attribute_map': {
                    'since': 'since',
                    'to': 'to',
                    'count': 'count',
                    'page': 'page',
                    'statuses': 'statuses',
                    'methods': 'methods',
                    'search': 'search',
                    'environment_type': 'environment_type',
                },
                'location_map': {
                    'since': 'query',
                    'to': 'query',
                    'count': 'query',
                    'page': 'query',
                    'statuses': 'query',
                    'methods': 'query',
                    'search': 'query',
                    'environment_type': 'query',
                },
                'collection_format_map': {
                    'statuses': 'multi',
                    'methods': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def details_log(
        self,
        id,
        **kwargs
    ):
        """Details API Log  # noqa: E501

        Returns details of the specific API log event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.details_log(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Log event id.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APILogDetailsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.details_log_endpoint.call_with_http_info(**kwargs)

    def list_logs(
        self,
        **kwargs
    ):
        """List API Log  # noqa: E501

        Get the list of all logs within the selected workspace. Optionally filter by date, page, and `#` of items per page.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_logs(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            since (str): Determines a point in time from which logs should be fetched. Either a specific ISO 8601 datetime or a relative identifier such as \"-90d\" (for past 90 days).. [optional]
            to (str): Determines a point in time from which logs should be fetched. Either a specific ISO 8601 datetime or a relative identifier such as \"-10d\" (for past 10 days) or a special \"now\" value.. [optional]
            count (int): The amount of items on each page.. [optional]
            page (int): Page number of the results returned.. [optional]
            statuses ([int]): Returns only the predefined status codes. Allows 1xx, 2xx, 3xx, 4xx, and 5xx.. [optional]
            methods ([str]): Returns only the predefined HTTP methods. Allows GET, POST, PUT, PATCH, and DELETE.. [optional]
            search (str): Returns the results containing a string.. [optional]
            environment_type (str): Returns logs for production/sandbox.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APILogListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_logs_endpoint.call_with_http_info(**kwargs)

