# coding: utf-8

# flake8: noqa
"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

# import models into model package
from hubspot.cms.hubdb.models.batch_input_hub_db_table_row_v3_request import BatchInputHubDbTableRowV3Request
from hubspot.cms.hubdb.models.batch_input_json_node import BatchInputJsonNode
from hubspot.cms.hubdb.models.batch_input_string import BatchInputString
from hubspot.cms.hubdb.models.batch_response_hub_db_table_row_v3_with_errors import BatchResponseHubDbTableRowV3WithErrors
from hubspot.cms.hubdb.models.collection_response_with_total_hub_db_table_row_v3_forward_paging import CollectionResponseWithTotalHubDbTableRowV3ForwardPaging
from hubspot.cms.hubdb.models.collection_response_with_total_hub_db_table_v3_forward_paging import CollectionResponseWithTotalHubDbTableV3ForwardPaging
from hubspot.cms.hubdb.models.column import Column
from hubspot.cms.hubdb.models.column_request import ColumnRequest
from hubspot.cms.hubdb.models.error import Error
from hubspot.cms.hubdb.models.error_detail import ErrorDetail
from hubspot.cms.hubdb.models.foreign_id import ForeignId
from hubspot.cms.hubdb.models.forward_paging import ForwardPaging
from hubspot.cms.hubdb.models.hub_db_table_clone_request import HubDbTableCloneRequest
from hubspot.cms.hubdb.models.hub_db_table_row_v3 import HubDbTableRowV3
from hubspot.cms.hubdb.models.hub_db_table_row_v3_request import HubDbTableRowV3Request
from hubspot.cms.hubdb.models.hub_db_table_v3 import HubDbTableV3
from hubspot.cms.hubdb.models.hub_db_table_v3_request import HubDbTableV3Request
from hubspot.cms.hubdb.models.import_result import ImportResult
from hubspot.cms.hubdb.models.next_page import NextPage
from hubspot.cms.hubdb.models.option import Option
from hubspot.cms.hubdb.models.simple_user import SimpleUser
from hubspot.cms.hubdb.models.standard_error import StandardError
