#pip install -U sentence-transformers   
import fire ,json, requests
from sentence_transformers import SentenceTransformer
model = SentenceTransformer('all-MiniLM-L6-v2')
from so import *

#	vec = model.encode(snt.strip())
#	return es.index(index=index, document={"snt":snt, "vec": vec.tolist()})

class util(object):
	def __init__(self, host='127.0.0.1', port=9200): 
		self.es = Elasticsearch([ f"http://{host}:{port}" ])  

	def init(idxname:str='testidx'):  
		''' '''
		if self.es.indices.exists(index = idxname): self.es.indices.delete(index = idxname) 
		return self.es.indices.create(index=idxname, body=config)

	def encode(self, snt="It is composed of a brave, a free, a virtuous, and an intelligent people."):
		''' --- dump index name,ie: pigai06 '''
		res = model.encode(snt.strip()).tolist()
		print (res) 

	def keys(self, idxname):
		''' --- dump index name,ie: pigai06 '''
		scanResp= helpers.scan(client=self.es, query={"query" : {"match_all" : {}}}, scroll= "10m", index= idxname , timeout="10m")
		for resp in scanResp:
			print(resp['_id'])


	def vec(self, idxname):
		''' add snt vec into snt '''
		print("started:", idxname, flush=True) 
		for doc in helpers.scan(client=self.es, query={"query" : {"match" : {"type":"snt"}} }, index= 'inau'):
			sid		= doc['_id']
			snt		= doc['_source']['snt']
			sntvec	= model.encode(snt.strip()).tolist()
			print (sid, snt, len(sntvec), flush=True)
			self.es.index(index=idxname, body={"_snt":snt,  "sntvec": sntvec, 'type':'sntvec'}, id = f"{sid}-sntvec")
		print("finished:", idxname) 

	def idsource(self, infile, idxname=None, batch=100000, refresh:bool=True): 
		''' {"_id": "140948871-9", "_source": {"rid": "10", "uid": "25110374", "sc": 14, "md5": "da891a7d81f7a5e43b571168cc483b6c dba0b4c99ef37cadfc4bacd61fcefa5b d6b199bfae35246564c598ac78d84c91 38a945eeff5b5a587a26dcc6560e0061 58605af6b50b01f15c0cc3ee2aa75e33"}}'''
		if not idxname : idxname = infile.split('.')[0] 
		print("idsource started:", infile, idxname, es, flush=True)
		if refresh and es.indices.exists(index=idxname): es.indices.delete(index=idxname)
		if not es.indices.exists(index=idxname): es.indices.create(index=idxname, body=config)
		actions=[]
		for line in readline(infile):  
			try:
				arr = json.loads(line) # 
				if not '_source' in arr : arr = {"_source": arr} # source only njson 
				arr.update({'_op_type':'index', '_index':idxname})
				actions.append(arr)
				if len(actions) > batch : 
					helpers.bulk(client=es,actions=actions, raise_on_error=False)
					actions=[]
					print(arr["_id"], flush=True) 
			except Exception as ex:
				print(">>callback ex:", ex, line)
		helpers.bulk(client=es,actions=actions, raise_on_error=False)
		print("idsource finished:", infile,idxname)

if __name__ == '__main__':
	fire.Fire(util)

'''
It is composed of a brave, a free, a virtuous, and an intelligent people.
[0.0428357757627964, 0.05443267896771431, 0.00915539637207985, 0.05365129932761192, -0.027242625132203102, 0.07376600056886673, 0.025431429967284203, -0.07986190915107727, -0.004683795850723982, 0.11686097830533981, 0.011845136061310768, -0.049156609922647476, 0.02621416561305523, -0.12482254207134247, 0.021477118134498596, -0.036006294190883636, 0.03164633363485336, -0.07035267353057861, -0.015617419965565205, -0.0251480620354414, -0.05691566318273544, 0.03965965285897255, 0.07718455046415329, 0.05157160386443138, -0.036925751715898514, 0.022809559479355812, 0.009927752427756786, -0.011286929249763489, 0.0804736465215683, -0.00862825382500887, 0.03605790063738823, 0.008435778319835663, 0.12083739787340164, -0.0012100827880203724, -0.09807085245847702, 0.05875802040100098, 0.06094479560852051, 0.031606752425432205, 0.07916507124900818, -0.0533309169113636, -0.07125987857580185, -0.023736588656902313, 0.006279368419200182, 0.06722331047058105, -0.03011314570903778, 0.018268946558237076, -0.0564887709915638, -0.03545906022191048, 0.0033093621022999287, -0.06389370560646057, -0.05912698805332184, -0.0034169619902968407, -0.09682748466730118, -0.058934811502695084, -0.012701459228992462, 0.03028280660510063, -0.020830471068620682, -0.07531171292066574, -0.007378367707133293, 0.007966084405779839, 0.060310110449790955, -0.01926361210644245, 0.009740964509546757, 0.06804020702838898, 0.060402244329452515, 0.012712701223790646, -0.03613364323973656, 0.03957419842481613, -0.010926240123808384, -0.07018435001373291, 0.05110388621687889, 0.016699573025107384, 0.08715121448040009, 0.03569783642888069, -0.09032725542783737, -0.10721048712730408, -0.0010328602511435747, -0.09454511851072311, -0.006544091738760471, 0.07378090918064117, -0.015524336136877537, 0.06195095181465149, -0.04998014494776726, 0.13463206589221954, 0.03768639639019966, -0.01872994191944599, -0.005484947469085455, -0.056297626346349716, -0.0005365527467802167, -0.06696172803640366, 0.002500163856893778, 0.04085199162364006, 0.042743030935525894, -0.0029208078049123287, 0.04098239913582802, 0.061843372881412506, 0.034093163907527924, 4.8404865083284676e-05, -0.04402797296643257, 0.043800484389066696, 0.0717908963561058, 0.05398555099964142, 0.050091251730918884, 0.03847528621554375, -0.035435259342193604, -0.08489809185266495, -0.03322705626487732, -0.03784790635108948, -0.011421581730246544, -0.011742479167878628, -0.07362999022006989, -0.013592945411801338, 4.856079976889305e-05, 0.03778395429253578, 0.02348092570900917, -0.027792615815997124, -0.0743875727057457, -0.02668868750333786, -0.018602533265948296, 0.07617324590682983, 0.08336534351110458, 0.02299579791724682, 0.05727553740143776, 0.05307682231068611, 0.023673614487051964, -0.06550507247447968, -0.029786409810185432, -7.4450808983253e-33, 0.005177424754947424, 0.06122492998838425, 0.035942476242780685, 0.03879624977707863, -0.05251248925924301, -0.011159037239849567, 0.025817563757300377, -0.08568833768367767, -0.04641033709049225, 0.07842880487442017, 0.00036876220838166773, -0.05445336923003197, -0.008269906044006348, 0.2169923186302185, -0.012084940448403358, -0.029878336936235428, -0.09820263087749481, -0.049184367060661316, -0.01986306719481945, -0.028212323784828186, -0.04325161129236221, 0.09400259703397751, -0.016914842650294304, -0.06565847247838974, -0.00449456088244915, -0.06552495807409286, 0.011000302620232105, -0.03859420493245125, -0.044905778020620346, 0.028531471267342567, 0.012483698315918446, 0.014671707525849342, -0.04905577376484871, -0.012791288085281849, 0.015510659664869308, -0.036384887993335724, -0.07253745943307877, -0.04178972169756889, 0.0020339153707027435, 0.039309896528720856, 0.016880279406905174, -0.018669554963707924, 0.04610669985413551, 0.0208165030926466, 0.033162835985422134, 0.04359227046370506, 0.04614507034420967, -0.08637172728776932, -0.025342006236314774, 0.020304391160607338, 0.01865881308913231, 0.013767066411674023, 0.01830768957734108, 0.02087445557117462, -0.00020969448087271303, 0.005129524040967226, -0.025177307426929474, 0.170959934592247, -0.04848337918519974, -0.048243723809719086, -0.025915546342730522, 0.018801512196660042, -0.044829729944467545, 0.03537586331367493, 0.02689943090081215, 0.05573836714029312, -0.12673988938331604, -0.007875530049204826, 0.06910271942615509, 0.03014916554093361, 0.06088650971651077, 0.010745923034846783, -0.04569118097424507, 0.02080988511443138, -0.0323166698217392, 0.050092097371816635, 0.058729737997055054, -0.08886995911598206, 0.03713382035493851, 0.03584371134638786, -0.08116984367370605, 0.01767166517674923, -0.04030698910355568, 0.0019875173456966877, 0.020139696076512337, -0.013345853425562382, 0.04032888635993004, -0.05901331454515457, 0.032467156648635864, -0.05726538598537445, 0.0507829524576664, -0.052432429045438766, -0.007654217071831226, -0.10159986466169357, -0.07683674991130829, 2.698690747068192e-33, -0.02369137480854988, -0.028252167627215385, -0.01126809325069189, 0.03010581061244011, 0.031674087047576904, 0.037199683487415314, -0.09947845339775085, 0.07819288223981857, -0.007185883820056915, 0.06695548444986343, -0.09184641391038895, -0.024660633876919746, 0.03532259538769722, -0.04773057997226715, 0.06933192163705826, -0.01029256172478199, 0.008005627430975437, 0.037340421229600906, 0.031414687633514404, 0.013755368068814278, 0.009317557327449322, 0.02593471109867096, -0.010720339603722095, -0.09344138950109482, -0.009222250431776047, 0.022682901471853256, -0.0703188106417656, -0.08769883960485458, -0.015435134060680866, -0.011578965932130814, 0.03869852423667908, -0.027496295049786568, -0.10900605469942093, -0.08062049746513367, -0.008280807174742222, 0.009317925199866295, 0.03151554614305496, -0.027834568172693253, -0.03166675195097923, 0.01356031559407711, -0.06213705986738205, 0.020120875909924507, 0.05502737686038017, 0.004822880495339632, -0.005114029627293348, 0.019620602950453758, 0.005284306593239307, -0.03323618695139885, -0.0345337800681591, 0.02551676146686077, 0.030519401654601097, -0.03388746827840805, -0.010301769711077213, -0.0020715503487735987, 0.05168486014008522, -0.050622329115867615, -0.06036059558391571, 0.00045969823258928955, 0.06519201397895813, 0.020748360082507133, -0.0057930718176066875, -0.009865649975836277, -0.04230857640504837, 0.048662248998880386, 0.06787441670894623, -0.021356122568249702, -0.08462399244308472, 0.09490738809108734, -0.02140025421977043, -0.02253628708422184, 0.050607845187187195, 0.04676709696650505, -0.078629270195961, -0.04314405843615532, 0.07840447127819061, -0.029016835615038872, 0.03233352676033974, -0.01883208006620407, 0.025250695645809174, 0.015490343794226646, 0.08770275861024857, -0.06634151190519333, -0.02027972973883152, -0.05892965942621231, -0.026952918618917465, -0.0036801069509238005, -0.030368747189641, -0.005115880630910397, 0.015142648480832577, 0.03273114189505577, -0.032234810292720795, 0.0009289890294894576, -0.04186989367008209, 0.04170401394367218, 0.029792672023177147, -2.859484737882667e-08, 0.025525398552417755, -0.04619242995977402, -0.022236935794353485, 0.035147055983543396, 0.022018110379576683, -0.0023096748627722263, 0.028695201501250267, -0.10518158972263336, -0.06518811732530594, 0.04892054945230484, 0.06034497916698456, -0.03993573039770126, -0.052166350185871124, 0.07595819234848022, -0.014662434346973896, 0.010239800438284874, -0.006345574278384447, -0.019703827798366547, -0.024572288617491722, 0.02539972774684429, 0.0951005220413208, 0.01985267549753189, -0.05225763097405434, -0.04866339638829231, -0.0898217186331749, 0.031853679567575455, -0.032434724271297455, -0.11471273005008698, -0.048502642661333084, 0.09474191069602966, -0.017921697348356247, 0.05622093752026558, -0.10884932428598404, -0.05299189314246178, -0.08260075002908707, 0.0749090164899826, -0.052077971398830414, -0.07453339546918869, 0.019807085394859314, -0.03193392604589462, 0.05698435753583908, 0.10865439474582672, -0.015311310067772865, 0.022389328107237816, 0.1015036329627037, -0.03436882421374321, -0.008720935322344303, -0.021233104169368744, -0.012241040356457233, 0.0029895047191530466, 0.0038197366520762444, 0.008592094294726849, 0.07161298394203186, 0.04050669074058533, -0.01724141091108322, -0.05167128145694733, 0.010219756513834, 0.04358546808362007, -0.0029138734098523855, -0.04334571212530136, 0.05517883226275444, -0.012233751825988293, 0.09113400429487228, -0.061766188591718674]


python sntvec.py idsource gzjc.source  gzjc1

GET gzjc/_knn_search
{
 "knn": {
   "field": "image-vector",
   "query_vector": [-0.5, 9.4, 1,2],
   "k": 10,
   "num_candidates": 100
 }
}

PUT gzjc
{
 "mappings": {
   "properties": {
     "snt":{"type":"text"},
     "vec": {
       "type": "dense_vector",
       "dims": 384,
       "index": true,
       "similarity": "l2_norm"
     }
   }
 }
}

@app.get('/sntvec/add_new_snt_with_ske')
def add_new_snt(index:str='testidx', snt:str='Justice delayed is justice denied.', ske:str="_NP delayed is _NP denied ."): 
	sntvec = model.encode(snt.strip())
	skevec = model.encode(ske.strip())
	return es.index(index=index, document={"snt":snt, "ske":ske,  "sntvec": sntvec.tolist(), "skevec": skevec.tolist()})

>>> es.get(index='twitter', id='wTxqC38BopRXpF5veeGm')
ObjectApiResponse({'_index': 'twitter', '_id': 'wTxqC38BopRXpF5veeGm', '_version': 1, '_seq_no': 0, '_primary_term': 1, 'found': True, '_source': {'one': 'wo'}})
>>>

>>> res.body
{'_index': 'twitter', '_id': 'wTxqC38BopRXpF5veeGm', '_version': 1, '_seq_no': 0, '_primary_term': 1, 'found': True, '_source': {'one': 'wo'}}

certificate_path = os.path.join(CERT_PATH, 'cacert.pem')
certificate_key_path = os.path.join(CERT_PATH, 'cacert.key')
response = requests.get(url, cert=(certificate_path, certificate_key_path))

GET /inau/_search
{
  "query": {
    "script_score": {
      "query": {
        "match_all": {}
      },
      "script": {
        "source": "cosineSimilarity(params.query_vector, 'sntvec') + 1.0",
        "params": {
          "query_vector": [0.0428357757627964, 0.05443267896771431, 0.00915539637207985, 0.05365129932761192, -0.027242625132203102, 0.07376600056886673, 0.025431429967284203, -0.07986190915107727, -0.004683795850723982, 0.11686097830533981, 0.011845136061310768, -0.049156609922647476, 0.02621416561305523, -0.12482254207134247, 0.021477118134498596, -0.036006294190883636, 0.03164633363485336, -0.07035267353057861, -0.015617419965565205, -0.0251480620354414, -0.05691566318273544, 0.03965965285897255, 0.07718455046415329, 0.05157160386443138, -0.036925751715898514, 0.022809559479355812, 0.009927752427756786, -0.011286929249763489, 0.0804736465215683, -0.00862825382500887, 0.03605790063738823, 0.008435778319835663, 0.12083739787340164, -0.0012100827880203724, -0.09807085245847702, 0.05875802040100098, 0.06094479560852051, 0.031606752425432205, 0.07916507124900818, -0.0533309169113636, -0.07125987857580185, -0.023736588656902313, 0.006279368419200182, 0.06722331047058105, -0.03011314570903778, 0.018268946558237076, -0.0564887709915638, -0.03545906022191048, 0.0033093621022999287, -0.06389370560646057, -0.05912698805332184, -0.0034169619902968407, -0.09682748466730118, -0.058934811502695084, -0.012701459228992462, 0.03028280660510063, -0.020830471068620682, -0.07531171292066574, -0.007378367707133293, 0.007966084405779839, 0.060310110449790955, -0.01926361210644245, 0.009740964509546757, 0.06804020702838898, 0.060402244329452515, 0.012712701223790646, -0.03613364323973656, 0.03957419842481613, -0.010926240123808384, -0.07018435001373291, 0.05110388621687889, 0.016699573025107384, 0.08715121448040009, 0.03569783642888069, -0.09032725542783737, -0.10721048712730408, -0.0010328602511435747, -0.09454511851072311, -0.006544091738760471, 0.07378090918064117, -0.015524336136877537, 0.06195095181465149, -0.04998014494776726, 0.13463206589221954, 0.03768639639019966, -0.01872994191944599, -0.005484947469085455, -0.056297626346349716, -0.0005365527467802167, -0.06696172803640366, 0.002500163856893778, 0.04085199162364006, 0.042743030935525894, -0.0029208078049123287, 0.04098239913582802, 0.061843372881412506, 0.034093163907527924, 4.8404865083284676e-05, -0.04402797296643257, 0.043800484389066696, 0.0717908963561058, 0.05398555099964142, 0.050091251730918884, 0.03847528621554375, -0.035435259342193604, -0.08489809185266495, -0.03322705626487732, -0.03784790635108948, -0.011421581730246544, -0.011742479167878628, -0.07362999022006989, -0.013592945411801338, 4.856079976889305e-05, 0.03778395429253578, 0.02348092570900917, -0.027792615815997124, -0.0743875727057457, -0.02668868750333786, -0.018602533265948296, 0.07617324590682983, 0.08336534351110458, 0.02299579791724682, 0.05727553740143776, 0.05307682231068611, 0.023673614487051964, -0.06550507247447968, -0.029786409810185432, -7.4450808983253e-33, 0.005177424754947424, 0.06122492998838425, 0.035942476242780685, 0.03879624977707863, -0.05251248925924301, -0.011159037239849567, 0.025817563757300377, -0.08568833768367767, -0.04641033709049225, 0.07842880487442017, 0.00036876220838166773, -0.05445336923003197, -0.008269906044006348, 0.2169923186302185, -0.012084940448403358, -0.029878336936235428, -0.09820263087749481, -0.049184367060661316, -0.01986306719481945, -0.028212323784828186, -0.04325161129236221, 0.09400259703397751, -0.016914842650294304, -0.06565847247838974, -0.00449456088244915, -0.06552495807409286, 0.011000302620232105, -0.03859420493245125, -0.044905778020620346, 0.028531471267342567, 0.012483698315918446, 0.014671707525849342, -0.04905577376484871, -0.012791288085281849, 0.015510659664869308, -0.036384887993335724, -0.07253745943307877, -0.04178972169756889, 0.0020339153707027435, 0.039309896528720856, 0.016880279406905174, -0.018669554963707924, 0.04610669985413551, 0.0208165030926466, 0.033162835985422134, 0.04359227046370506, 0.04614507034420967, -0.08637172728776932, -0.025342006236314774, 0.020304391160607338, 0.01865881308913231, 0.013767066411674023, 0.01830768957734108, 0.02087445557117462, -0.00020969448087271303, 0.005129524040967226, -0.025177307426929474, 0.170959934592247, -0.04848337918519974, -0.048243723809719086, -0.025915546342730522, 0.018801512196660042, -0.044829729944467545, 0.03537586331367493, 0.02689943090081215, 0.05573836714029312, -0.12673988938331604, -0.007875530049204826, 0.06910271942615509, 0.03014916554093361, 0.06088650971651077, 0.010745923034846783, -0.04569118097424507, 0.02080988511443138, -0.0323166698217392, 0.050092097371816635, 0.058729737997055054, -0.08886995911598206, 0.03713382035493851, 0.03584371134638786, -0.08116984367370605, 0.01767166517674923, -0.04030698910355568, 0.0019875173456966877, 0.020139696076512337, -0.013345853425562382, 0.04032888635993004, -0.05901331454515457, 0.032467156648635864, -0.05726538598537445, 0.0507829524576664, -0.052432429045438766, -0.007654217071831226, -0.10159986466169357, -0.07683674991130829, 2.698690747068192e-33, -0.02369137480854988, -0.028252167627215385, -0.01126809325069189, 0.03010581061244011, 0.031674087047576904, 0.037199683487415314, -0.09947845339775085, 0.07819288223981857, -0.007185883820056915, 0.06695548444986343, -0.09184641391038895, -0.024660633876919746, 0.03532259538769722, -0.04773057997226715, 0.06933192163705826, -0.01029256172478199, 0.008005627430975437, 0.037340421229600906, 0.031414687633514404, 0.013755368068814278, 0.009317557327449322, 0.02593471109867096, -0.010720339603722095, -0.09344138950109482, -0.009222250431776047, 0.022682901471853256, -0.0703188106417656, -0.08769883960485458, -0.015435134060680866, -0.011578965932130814, 0.03869852423667908, -0.027496295049786568, -0.10900605469942093, -0.08062049746513367, -0.008280807174742222, 0.009317925199866295, 0.03151554614305496, -0.027834568172693253, -0.03166675195097923, 0.01356031559407711, -0.06213705986738205, 0.020120875909924507, 0.05502737686038017, 0.004822880495339632, -0.005114029627293348, 0.019620602950453758, 0.005284306593239307, -0.03323618695139885, -0.0345337800681591, 0.02551676146686077, 0.030519401654601097, -0.03388746827840805, -0.010301769711077213, -0.0020715503487735987, 0.05168486014008522, -0.050622329115867615, -0.06036059558391571, 0.00045969823258928955, 0.06519201397895813, 0.020748360082507133, -0.0057930718176066875, -0.009865649975836277, -0.04230857640504837, 0.048662248998880386, 0.06787441670894623, -0.021356122568249702, -0.08462399244308472, 0.09490738809108734, -0.02140025421977043, -0.02253628708422184, 0.050607845187187195, 0.04676709696650505, -0.078629270195961, -0.04314405843615532, 0.07840447127819061, -0.029016835615038872, 0.03233352676033974, -0.01883208006620407, 0.025250695645809174, 0.015490343794226646, 0.08770275861024857, -0.06634151190519333, -0.02027972973883152, -0.05892965942621231, -0.026952918618917465, -0.0036801069509238005, -0.030368747189641, -0.005115880630910397, 0.015142648480832577, 0.03273114189505577, -0.032234810292720795, 0.0009289890294894576, -0.04186989367008209, 0.04170401394367218, 0.029792672023177147, -2.859484737882667e-08, 0.025525398552417755, -0.04619242995977402, -0.022236935794353485, 0.035147055983543396, 0.022018110379576683, -0.0023096748627722263, 0.028695201501250267, -0.10518158972263336, -0.06518811732530594, 0.04892054945230484, 0.06034497916698456, -0.03993573039770126, -0.052166350185871124, 0.07595819234848022, -0.014662434346973896, 0.010239800438284874, -0.006345574278384447, -0.019703827798366547, -0.024572288617491722, 0.02539972774684429, 0.0951005220413208, 0.01985267549753189, -0.05225763097405434, -0.04866339638829231, -0.0898217186331749, 0.031853679567575455, -0.032434724271297455, -0.11471273005008698, -0.048502642661333084, 0.09474191069602966, -0.017921697348356247, 0.05622093752026558, -0.10884932428598404, -0.05299189314246178, -0.08260075002908707, 0.0749090164899826, -0.052077971398830414, -0.07453339546918869, 0.019807085394859314, -0.03193392604589462, 0.05698435753583908, 0.10865439474582672, -0.015311310067772865, 0.022389328107237816, 0.1015036329627037, -0.03436882421374321, -0.008720935322344303, -0.021233104169368744, -0.012241040356457233, 0.0029895047191530466, 0.0038197366520762444, 0.008592094294726849, 0.07161298394203186, 0.04050669074058533, -0.01724141091108322, -0.05167128145694733, 0.010219756513834, 0.04358546808362007, -0.0029138734098523855, -0.04334571212530136, 0.05517883226275444, -0.012233751825988293, 0.09113400429487228, -0.061766188591718674]
        }
      }
    }
  }
}
'''