# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import date, datetime  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel  # noqa: F401
from pydantic import AnyUrl, Field

from telus_bulk.models.tmf_645.related_party import RelatedParty
from telus_bulk.models.tmf_645.service_qualification_item import (
    ServiceQualificationItem,
)


class QueryServiceQualificationCreate(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    QueryServiceQualificationCreate - a model defined in OpenAPI

        description: The description of this QueryServiceQualificationCreate [Optional].
        expected_qualification_date: The expected_qualification_date of this QueryServiceQualificationCreate [Optional].
        external_id: The external_id of this QueryServiceQualificationCreate [Optional].
        instant_sync_qualification: The instant_sync_qualification of this QueryServiceQualificationCreate [Optional].
        related_party: The related_party of this QueryServiceQualificationCreate [Optional].
        search_criteria: The search_criteria of this QueryServiceQualificationCreate.
        base_type: The base_type of this QueryServiceQualificationCreate [Optional].
        schema_location: The schema_location of this QueryServiceQualificationCreate [Optional].
        type: The type of this QueryServiceQualificationCreate [Optional].
    """

    description: Optional[str] = None
    expected_qualification_date: Optional[datetime] = None
    external_id: Optional[str] = None
    instant_sync_qualification: Optional[bool] = None
    related_party: Optional[List[RelatedParty]] = None
    search_criteria: ServiceQualificationItem
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


QueryServiceQualificationCreate.update_forward_refs()
