# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aio_odoorpc_base', 'aio_odoorpc_base.aio', 'aio_odoorpc_base.sync']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aio-odoorpc-base',
    'version': '3.0.2',
    'description': "Fast, simple Odoo RPC package with sync and async functions to pilot Odoo's jsonrpc API. Check aio-odoorpc for a higher-level, friendlier interface.",
    'long_description': "## Base functions to pilot Odoo's jsonrpc API (aio-odoorpc-base)\n\n### Description:\nThis python package implements a **complete** set of methods to access  \nOdoo's external API (using jsonrpc rather than xmlrpc).\n\nIt offers an almost-exact mirror of Odoo's external API, even parameter names are the same.\nIt is 'almost-exact' because 'execute' is skipped in favor of 'execute_kw' only and the \nIt is 'almost-exact' because 'execute' is skipped in favor of 'execute_kw' only and the \nAPI methods from the 'db' service: 'list', 'drop', 'dump', 'rename', 'restore' are here \nimplemented with names 'list_databases', 'drop_database', 'dump_database', 'rename_database'\nand 'restore_database' respectively.  \n\nThe 'documentation' offered by this package is mostly in the form of proper type \nannotations so that you have a better idea of what kind of data each API method expects. \nOther than that, developers are recommended to go study Odoo's external API by reading the\nsource code at (https://github.com/odoo/odoo/tree/master/odoo/service). The three API services\n'object', 'common' and 'db' are implemented there in files model.py, common.py and db.py \nrespectively. On each of these python files, a 'dispatch' method is implemented for the service\nin question. The methods available on the external service api are usually those prefixed with \n'exp_' in the method name, with the exception of the 'object' service which only exposes \n'execute' and 'execute_kw'.\n\nAll functions offered by this package are available in both async and sync versions.\n\nOdoo's API methods implemented:\n- about\n- authenticate\n- change_admin_password\n- create_database\n- db_exist\n- drop_database\n- dump_database\n- duplicate_database\n- execute_kw\n- list_countries\n- list_databases\n- list_lang\n- login\n- migrate_databases\n- rename_database\n- restore_database\n- server_version\n- version\n\nAll methods take as first 2 parameters:\n- **http_client**: a callable or an instance of a compatible http_client (it must implement a 'post'\n  method that accepts a 'url' and a 'json' parameter. Packages 'requests', 'httpx' and 'aiohttp' are \n  compatible).\n  If http_client is a callable, it will be called with a dict as the post payload and must return a \n  response object with a '.json()' method that may be synchronous or asynchronous (when using the async\n  functions). It must return a dict or dict-like object representing the reponse.\n\n- **url**: the complete URL of your Odoo's jsonrpc endpoint. Usually something like\n  'https://odoo.acme.com/jsonrpc' or 'https://odoo.acme.com:8443/jsonrpc'. \n\nRemaining parameters on each method are those expected by Odoo's external API, with identical names\nas you will find on Odoo's source code. The method 'jsonrpc' is the low-level method in this package that\nactually does all the HTTP calls for all implemented methods.\n\nBy default, when you issue 'from aio_odoorpc_base import ...' you will be importing the async methods.\nIf you want the sync methods you must import from 'aio_odoorpc_base.sync'. You may also use \n'aio_odoorpc_base.aio' if you prefer to be explicit on whether you are importing sync or async code.\n\n\n### aio-odoorpc: a higher-level API\n\nIn practice, you may notice that 99% of the time you will be calling the 'execute_kw' method\nwhich is what allows you to deal with Odoo's models, reading and writing actual business data \nvia the model methods 'search', 'read', 'search_read', 'search_count', 'write', 'create', etc.\nWhile this package only offers you a bare 'execute_kw' method and a helper 'build_execute_kw_kwargs', \nthe higher-level package 'aio-odoorpc' expands over this one adding higher-level objects and methods\n(such as 'search', 'read', 'search_read', 'search_count', 'write', 'create', etc) to consume those \nmodel methods through calls to 'execute_kw' external API method. \n\n\n### No dependencies:\nNo dependency is not a promise, just a preference. It may change in the future, but only if for very\ngood reason. Here, are free to use whatever HTTP Client library you want.\n\nI am willing to make modifications in the code in order to support other http client solutions, \njust get in touch (use the project's github repository for that).\n\nWhile it would be easier if this package shipped with a specific http client dependency, it should be\nnoted that having the possibility to reuse HTTP sessions is a great opportunity to improve the \nspeed of your running code. Also, it is possible that your project is already using some http client\nlibrary and here you have the opportunity to use it. \n\nRemember that you must use an async http client library if you are going to use the async functions,\nor use a synchronous http client library if you are going to use the sync function.\n\n### Python HTTP Client packages known to be compatible:\n- sync-only: 'requests'\n- async-only: 'aiohttp'\n- sync and async: 'httpx'\n\n### Motivation:\nThe package 'odoorpc' is the most used and better maintained package to let you easily consume Odoo's\nexternal API. It has lots of functionality, good documentation, a large user base and was developed\nby people that are very experienced with Odoo in general and big contributors to the Odoo Community.  \nIn other words, if you are taking your first steps and do not need an async interface now, start with\nodoorpc.\n\nHowever, for my needs, once I was developing Odoo integrations that needed to make hundreds of calls\nto the Odoo API to complete a single job, I began to sorely miss an async interface as well as more\ncontrol over the HTTP client used (I wished for HTTP2 support and connection polling/reuse).\n\nAlso, as I understood Odoo's external API, it started to sound like 'odoorpc' was too big for a task\ntoo simple. For instance, most of the time (like 99,99% of the time), you will be calling to a single\njsonrpc method called 'execute_kw'. It is the same call over and over just changing the payload which \nitself is a simple json. \n\nSo I decided to develop a new package myself, made it async-first and tryed to keep it as simple as\npossible. Also, I decided to split it in two, a very simple base package (this one) with only methods\nthat mirror those in Odoo's external API and another one 'aio-odoorpc' that adds another layer to\nimplement Odoo's model methods like 'search', 'search_read', 'read', etc. as well as an object model\nto instantiate a class once and then make simple method invocation with few parameters to access \nwhat you need.  \n\n\n### Useful tips about Odoo's external API:\n\n- The 'login' call is really only a lookup of the user_id (an int) of a user given a\n  database name, user/login name and password. If you are using this RPC client over and over in your \n  code, maybe even calling from a stateless cloud service, you should consider finding out the \n  user id (uid) of the user and pass the uid instead of the username to the constructor of AsyncOdooRPC.\n  This way, you do not need to call the login() RPC method to retrieve the uid, saving a RPC call;\n\n- The uid mentioned above is not a session-like id. It is really only the database id of the user\n  and it never expires. There is really no 'login' or 'session initiation' step required to access \n  Odoo's external API if you know the uid from the beginning;\n\n\n### Other things to know about this module:\n- It ships will a good suite of tests that run against an OCA runbot instance;\n\n- Asyncio is a python3 thing, so no python2 support;\n\n- Type hints are used everywhere;\n\n- This package uses jsonrpc only (no xmlrpc). There is a lack of async xmlrpc tooling and\n  jsonrpc is considered the best RPC protocol in Odoo (faster, more widely used);\n  \n- The synchronous version of the code is generated automatically from the asynchronous code, so at\n  least for now the effort to maintain both is minimal.\n\n- I am willing to take patches and to add other contributors to this project. Feel free to get in touch,\n  the github page is the best place to interact with the project and the project's author;\n\n- I only develop and run code in Linux environments, if you find a bug under other OS I am happy\n  to take patches but I will not myself spend time looking into these eventual bugs;\n\n\n### Usage\n\nOk, so let's start with some examples. I will omit the event_loop logic, I assume that if you want\nto use an async module you already have that sorted out yourself or through a framework like FastAPI.\n\nAll examples below could also be called using the synchronous OdooRPC object, but without the\n'await' syntax.\n\nI recommend that you check the tests folder for many more examples. Also, the codebase is very very short,\ndo refer to it as well.\n\n```\nfrom aio_odoorpc_base.aio import login, execute_kw \nfrom aio_odoorpc_base.helpers import build_execute_kw_kwargs\nimport httpx\n\nurl = 'https://odoo.acme.com/jsonrpc'\n\nasync with httpx.AsyncClient() as client:\n    uid = await login(http_client=client, url=url, db='acme', login='demo', password='demo')\n    kwargs = build_execute_kw_kwargs(fields=['partner_id', 'date_order', 'amount_total'],\n                                     limit=1000, offset=0, order='amount_total DESC')\n    data = await execute_kw(http_client=client,\n                            url=url,\n                            db='acme',\n                            uid=uid,\n                            password='demo',\n                            obj='sale.order',\n                            method='search_read',\n                            args=[],\n                            kw=kwargs)\n```\n",
    'author': 'mbello',
    'author_email': 'mbello@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mbello/aio-odoorpc-base',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
