"""EventSearch Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.event_search.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.event_search import EventSearchService


class TaegisSDKEventSearchQuery:
    """Teagis Event_search Query operations."""

    def __init__(self, service: EventSearchService):
        self.service = service

    def auxiliary_events_by_id(
        self, in_: Optional[GetEventByIDRequestInput] = None
    ) -> AuxiliaryEventsSearchResponse:
        """None."""
        endpoint = "auxiliaryEventsById"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AuxiliaryEventsSearchResponse),
        )
        if result.get(endpoint) is not None:
            return AuxiliaryEventsSearchResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query auxiliaryEventsById")

    def auxiliary_events_search(
        self, in_: AuxiliaryEventsSearchInput
    ) -> AuxiliaryEventsSearchResponse:
        """None."""
        endpoint = "auxiliaryEventsSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AuxiliaryEventsSearchResponse),
        )
        if result.get(endpoint) is not None:
            return AuxiliaryEventsSearchResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query auxiliaryEventsSearch")
