"""Clients Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.clients.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.clients import ClientsService


class TaegisSDKClientsQuery:
    """Teagis Clients Query operations."""

    def __init__(self, service: ClientsService):
        self.service = service

    def client(self, id_: str) -> Client:
        """Get Client by id. The ID can be either the ID of the client object or the client_id."""
        endpoint = "client"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Client),
        )
        if result.get(endpoint) is not None:
            return Client.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query client")

    def clients(
        self,
        name: Optional[str] = None,
        client_ids: Optional[List[str]] = None,
        tenant_id: Optional[str] = None,
        role_ids: Optional[List[str]] = None,
        tenant_ids: Optional[List[str]] = None,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> List[Client]:
        """Search Clients."""
        endpoint = "clients"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "name": prepare_input(name),
                "clientIDs": prepare_input(client_ids),
                "tenantID": prepare_input(tenant_id),
                "roleIDs": prepare_input(role_ids),
                "tenantIDs": prepare_input(tenant_ids),
                "page": prepare_input(page),
                "perPage": prepare_input(per_page),
            },
            output=build_output_string(Client),
        )
        if result.get(endpoint) is not None:
            return Client.schema().load(result.get(endpoint), many=True)
        raise GraphQLNoRowsInResultSetError("for query clients")
