"""Audits Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import build_output_string, prepare_input
from taegis_sdk_python.services.audits.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.audits import AuditsService


class TaegisSDKAuditsQuery:
    """Teagis Audits Query operations."""

    def __init__(self, service: AuditsService):
        self.service = service

    def audit(self, audit_id: str) -> Audit:
        """Get an audit by id."""
        endpoint = "audit"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "AuditID": prepare_input(audit_id),
            },
            output=build_output_string(Audit),
        )
        if result.get(endpoint) is not None:
            return Audit.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query audit")

    def all_audits(
        self, all_audits_input: Optional[AllAuditsInput] = None
    ) -> AuditResult:
        """Get all audits."""
        endpoint = "allAudits"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "allAuditsInput": prepare_input(all_audits_input),
            },
            output=build_output_string(AuditResult),
        )
        if result.get(endpoint) is not None:
            return AuditResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query allAudits")

    def search_audits(self, audit_search_input: AuditSearchInput) -> AuditResult:
        """Search audits."""
        endpoint = "searchAudits"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "auditSearchInput": prepare_input(audit_search_input),
            },
            output=build_output_string(AuditResult),
        )
        if result.get(endpoint) is not None:
            return AuditResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query searchAudits")

    def list_application_events(self, application: AuditEventEnum) -> AuditEventResult:
        """Get event name list."""
        endpoint = "ListApplicationEvents"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "application": prepare_input(application),
            },
            output=build_output_string(AuditEventResult),
        )
        if result.get(endpoint) is not None:
            return AuditEventResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query ListApplicationEvents")
