"""Agent Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class AgentArch(str, Enum):
    """AgentArch."""

    ARCH_UNKNOWN = "ARCH_UNKNOWN"
    ARCH_X86 = "ARCH_X86"
    ARCH_X64 = "ARCH_X64"
    ARCH_ARM64 = "ARCH_ARM64"


class AgentPlatform(str, Enum):
    """AgentPlatform."""

    WINDOWS = "WINDOWS"
    LINUX = "LINUX"
    MAC = "MAC"


class AgentPkgType(str, Enum):
    """AgentPkgType."""

    DEB = "DEB"
    RPM = "RPM"
    MSI = "MSI"
    PKG = "PKG"
    GPG = "GPG"


class AgentChannel(str, Enum):
    """AgentChannel."""

    BETA = "BETA"
    PREVIEW = "PREVIEW"
    STABLE = "STABLE"
    DEV = "DEV"
    CANARY = "CANARY"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MetaData:
    """MetaData."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageSignedUrl:
    """PackageSignedUrl."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    modified_time: Optional[str] = field(
        default=None, metadata=config(field_name="modifiedTime")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    signed_url: Optional[str] = field(
        default=None, metadata=config(field_name="signedUrl")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageDownloadInput:
    """PackageDownloadInput."""

    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    platform: Optional[AgentPlatform] = field(
        default=None, metadata=config(field_name="platform")
    )
    architecture: Optional[AgentArch] = field(
        default=None, metadata=config(field_name="architecture")
    )
    pkg_type: Optional[AgentPkgType] = field(
        default=None, metadata=config(field_name="pkgType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Package:
    """Package."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    modified_time: Optional[str] = field(
        default=None, metadata=config(field_name="modifiedTime")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    platform: Optional[AgentPlatform] = field(
        default=None, metadata=config(field_name="platform")
    )
    pkg_type: Optional[AgentPkgType] = field(
        default=None, metadata=config(field_name="pkgType")
    )
    architecture: Optional[AgentArch] = field(
        default=None, metadata=config(field_name="architecture")
    )
    meta_data: Optional[List[MetaData]] = field(
        default=None, metadata=config(field_name="metaData")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageSearchInput:
    """PackageSearchInput."""

    num_recent_versions: Optional[int] = field(
        default=None, metadata=config(field_name="numRecentVersions")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    platform: Optional[AgentPlatform] = field(
        default=None, metadata=config(field_name="platform")
    )
    architecture: Optional[AgentArch] = field(
        default=None, metadata=config(field_name="architecture")
    )
    pkg_type: Optional[AgentPkgType] = field(
        default=None, metadata=config(field_name="pkgType")
    )
    channel: Optional[AgentChannel] = field(
        default=None, metadata=config(field_name="channel")
    )
