import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a team membership for a user or project on Rollbar.
 *
 * @schema CfnMembershipProps
 */
export interface CfnMembershipProps {
    /**
     * The team ID for the membership.
     *
     * @schema CfnMembershipProps#TeamId
     */
    readonly teamId: number;
    /**
     * The ID of the user or project to associate to the team.
     *
     * @schema CfnMembershipProps#MemberId
     */
    readonly memberId: number;
    /**
     * The type of membership
     *
     * @schema CfnMembershipProps#MemberType
     */
    readonly memberType: CfnMembershipPropsMemberType;
}
/**
 * Converts an object of type 'CfnMembershipProps' to JSON representation.
 */
export declare function toJson_CfnMembershipProps(obj: CfnMembershipProps | undefined): Record<string, any> | undefined;
/**
 * The type of membership
 *
 * @schema CfnMembershipPropsMemberType
 */
export declare enum CfnMembershipPropsMemberType {
    /** user */
    USER = "user",
    /** project */
    PROJECT = "project"
}
/**
 * A CloudFormation `Rollbar::Teams::Membership`
 *
 * @cloudformationResource Rollbar::Teams::Membership
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
 */
export declare class CfnMembership extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Rollbar::Teams::Membership";
    /**
     * Resource props.
     */
    readonly props: CfnMembershipProps;
    /**
     * Create a new `Rollbar::Teams::Membership`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMembershipProps);
}
