# encoding: utf-8
# THIS FILE IS AUTOGENERATED!
from __future__ import unicode_literals
from setuptools import setup
setup(
    author='Kyle Lahnakoski',
    author_email='kyle@lahnakoski.com',
    classifiers=["Development Status :: 3 - Alpha","Topic :: Software Development :: Libraries","Topic :: Software Development :: Libraries :: Python Modules","Programming Language :: SQL","Programming Language :: Python :: 3.7","License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)"],
    description='Extract Parse Tree from SQL',
    include_package_data=True,
    install_requires=["mo-dots==4.19.21059","mo-future==3.147.20327","mo-logs==4.20.21059"],
    license='MPL 2.0',
    long_description='# Moz SQL Parser\n\nLet\'s make a SQL parser so we can provide a familiar interface to non-sql datastores!\n\n\n|Branch      |Status   |\n|------------|---------|\n|master      | [![Build Status](https://travis-ci.org/klahnakoski/moz-sql-parser.svg?branch=master)](https://travis-ci.org/klahnakoski/moz-sql-parser) |\n|dev         | [![Build Status](https://travis-ci.org/klahnakoski/moz-sql-parser.svg?branch=dev)](https://travis-ci.org/klahnakoski/moz-sql-parser)    |\n\n\n## Problem Statement\n\nSQL is a familiar language used to access databases. Although, each database vendor has its quirky implementation, there is enough standardization that the average developer does not need to know of those quirks. This familiar core SQL (lowest common denominator, if you will) is useful enough to explore data in primitive ways. It is hoped that, once programmers have reviewed a datastore with basic SQL queries, and they see the value of that data, and they will be motivated to use the datastore\'s native query format.\n\n## Objectives\n\nThe primary objective of this library is to convert SQL queries to JSON-izable parse trees. This originally targeted MySQL, but has grown to include other database vendors. *Please [paste some SQL into a new issue](https://github.com/klahnakoski/moz-sql-parser/issues) if it does not work for you*\n\n## Non-Objectives \n\n* No plans to provide update statements, like `update` or `insert`\n* No plans to provide data access tools \n\nIt is my sincere hope you can convert the JSON into queries for your particular backend datastore  \n\n## Project Status\n\nJan 2021 -There are [almost 500 tests](https://github.com/mozilla/moz-sql-parser/tree/dev/tests). This parser is good enough for basic usage, including inner queries, `with` clauses, and window functions.  There is still a lot missing to support BigQuery and Redshift queries.  \n\n## Install\n\n    pip install moz-sql-parser\n\n## Parsing SQL\n\n    >>> from moz_sql_parser import parse\n    >>> import json\n    >>> json.dumps(parse("select count(1) from jobs"))\n    \'{"select": {"value": {"count": 1}}, "from": "jobs"}\'\n    \nEach SQL query is parsed to an object: Each clause is assigned to an object property of the same name. \n\n    >>> json.dumps(parse("select a as hello, b as world from jobs"))\n    \'{"select": [{"value": "a", "name": "hello"}, {"value": "b", "name": "world"}], "from": "jobs"}\'\n\nThe `SELECT` clause is an array of objects containing `name` and `value` properties. \n\n### Recursion Limit \n\nPython\'s default recursion limit (1000) is not hit when parsing the test suite, but this may not be the case for large SQL. You can increase the recursion limit before you `parse`:\n\n    >>> from moz_sql_parser import parse\n    >>> sys.setrecursionlimit(3000)\n    >>> parse(complicated_sql)\n\n\n## Generating SQL\n\nYou may also generate SQL from the a given JSON document. This is done by the formatter, which is still incomplete (Jan2020).\n\n    >>> from moz_sql_parser import format\n    >>> format({"from":"test", "select":["a.b", "c"]})\n    \'SELECT a.b, c FROM test\'\n\n## Contributing\n\nIn the event that the parser is not working for you, you can help make this better but simply pasting your sql (or JSON) into a new issue. Extra points if you describe the problem. Even more points if you submit a PR with a test.  If you also submit a fix, then you also have my gratitude. \n\n\n## Run Tests\n\nSee [the tests directory](https://github.com/mozilla/moz-sql-parser/tree/dev/tests) for instructions running tests, or writing new ones.\n\n## More about implementation\n\nSQL queries are translated to JSON objects: Each clause is assigned to an object property of the same name.\n\n    \n    # SELECT * FROM dual WHERE a>b ORDER BY a+b\n    {\n        "select": "*", \n        "from": "dual", \n        "where": {"gt": ["a", "b"]}, \n        "orderby": {"value": {"add": ["a", "b"]}}\n    }\n        \nExpressions are also objects, but with only one property: The name of the operation, and the value holding (an array of) parameters for that operation. \n\n    {op: parameters}\n\nand you can see this pattern in the previous example:\n\n    {"gt": ["a","b"]}\n    \n## Array Programming\n\nThe `moz-sql-parser.scrub()` method is used liberally throughout the code, and it "simplifies" the JSON.  You may find this form a bit tedious to work with because the JSON property values can be values, lists of values, or missing.  Please consider converting everything to arrays: \n\n\n```\ndef listwrap(value):\n    if value is None:\n        return []\n    elif isinstance(value, list)\n        return value\n    else:\n        return [value]\n```  \n\nthen you may avoid all the is-it-a-list checks :\n\n```\nfor select in listwrap(parsed_result.get(\'select\')):\n    do_something(select)\n```\n\nyou may find it easier if all JSON expressions had a list of operands:\n\n```\ndef normalize(expression)\n    # ensure parameters are in a list\n    return {\n        op: params\n        for op, param = expression.items()\n        for params in [[normalize(p) for p in listwrap(param)]]\n    }\n```\n',
    long_description_content_type='text/markdown',
    name='moz-sql-parser',
    packages=["moz_sql_parser","mo_parsing"],
    url='https://github.com/klahnakoski/moz-sql-parser',
    version='4.21.21059',
    zip_safe=True
)