import java.lang
import java.util
import org.cogroo.entities
import org.cogroo.entities.impl
import org.cogroo.text
import org.cogroo.tools.checker.checkers
import org.cogroo.tools.checker.rules
import org.cogroo.tools.checker.rules.dictionary
import org.cogroo.tools.checker.rules.model
import typing



_GenericChecker__T = typing.TypeVar('_GenericChecker__T')  # <T>
class GenericChecker(typing.Generic[_GenericChecker__T]):
    def check(self, t: _GenericChecker__T) -> java.util.List[org.cogroo.entities.Mistake]: ...
    def getIdPrefix(self) -> str: ...
    def getPriority(self) -> int: ...
    def getRulesDefinition(self) -> java.util.Collection['RuleDefinition']: ...
    def ignore(self, string: str) -> None: ...
    def resetIgnored(self) -> None: ...

class Merger:
    def __init__(self): ...
    @staticmethod
    def generalizePOSTags(morphologicalTag: org.cogroo.entities.impl.MorphologicalTag, morphologicalTagArray: typing.List[org.cogroo.entities.impl.MorphologicalTag]) -> None: ...

class RuleDefinition:
    def getCategory(self) -> str: ...
    def getDescription(self) -> str: ...
    def getExamples(self) -> java.util.List[org.cogroo.tools.checker.rules.model.Example]: ...
    def getGroup(self) -> str: ...
    def getId(self) -> str: ...
    def getMessage(self) -> str: ...
    def getRuleType(self) -> 'RuleType': ...
    def getShortMessage(self) -> str: ...
    def isXMLBased(self) -> bool: ...

class RuleType(java.lang.Enum['RuleType']):
    JAVA: typing.ClassVar['RuleType'] = ...
    XML_GENERAL: typing.ClassVar['RuleType'] = ...
    XML_PHRASE_LOCAL: typing.ClassVar['RuleType'] = ...
    XML_SUBJECT_VERB: typing.ClassVar['RuleType'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'RuleType': ...
    @staticmethod
    def values() -> typing.List['RuleType']: ...

class SentenceAdapter:
    def __init__(self, tagDictionary: org.cogroo.tools.checker.rules.dictionary.TagDictionary): ...
    def asTypedSentence(self, sentence: org.cogroo.text.Sentence, string: str) -> org.cogroo.entities.Sentence: ...
    @staticmethod
    def setPrimitiveAndGeneralize(token: org.cogroo.entities.Token, cogrooTagDictionary: org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary) -> None: ...

_AbstractGenericChecker__T = typing.TypeVar('_AbstractGenericChecker__T')  # <T>
class AbstractGenericChecker(GenericChecker[_AbstractGenericChecker__T], typing.Generic[_AbstractGenericChecker__T]):
    def __init__(self): ...
    def add(self, ruleDefinition: RuleDefinition) -> 'AbstractGenericChecker': ...
    def getRuleDefinition(self, string: str) -> RuleDefinition: ...
    def getRulesDefinition(self) -> java.util.Collection[RuleDefinition]: ...
    def ignore(self, string: str) -> None: ...
    def resetIgnored(self) -> None: ...

class Checker(GenericChecker[org.cogroo.text.Sentence]): ...

_GenericCheckerComposite__T = typing.TypeVar('_GenericCheckerComposite__T')  # <T>
class GenericCheckerComposite(GenericChecker[_GenericCheckerComposite__T], typing.Generic[_GenericCheckerComposite__T]):
    @typing.overload
    def __init__(self, list: java.util.List[GenericChecker[_GenericCheckerComposite__T]]): ...
    @typing.overload
    def __init__(self, list: java.util.List[GenericChecker[_GenericCheckerComposite__T]], boolean: bool): ...
    def getIdPrefix(self) -> str: ...
    def getPriority(self) -> int: ...
    def getRulesDefinition(self) -> java.util.List[RuleDefinition]: ...
    def ignore(self, string: str) -> None: ...
    def resetIgnored(self) -> None: ...

class JavaRuleDefinition(RuleDefinition):
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str, string6: str, list: java.util.List[org.cogroo.tools.checker.rules.model.Example]): ...
    def getCategory(self) -> str: ...
    def getDescription(self) -> str: ...
    def getExamples(self) -> java.util.List[org.cogroo.tools.checker.rules.model.Example]: ...
    def getGroup(self) -> str: ...
    def getId(self) -> str: ...
    def getMessage(self) -> str: ...
    def getRuleType(self) -> RuleType: ...
    def getShortMessage(self) -> str: ...
    def isXMLBased(self) -> bool: ...

class TypedChecker(GenericChecker[org.cogroo.entities.Sentence]): ...

class AbstractChecker(AbstractGenericChecker[org.cogroo.text.Sentence], Checker):
    def __init__(self): ...

class AbstractTypedChecker(AbstractGenericChecker[org.cogroo.entities.Sentence], TypedChecker):
    def __init__(self): ...

class CheckerComposite(GenericCheckerComposite[org.cogroo.text.Sentence], Checker):
    def __init__(self, list: java.util.List[Checker], boolean: bool): ...
    def check(self, sentence: org.cogroo.text.Sentence) -> java.util.List[org.cogroo.entities.Mistake]: ...

class TypedCheckerComposite(GenericCheckerComposite[org.cogroo.entities.Sentence], TypedChecker):
    def __init__(self, list: java.util.List[TypedChecker], boolean: bool): ...
    def check(self, sentence: org.cogroo.entities.Sentence) -> java.util.List[org.cogroo.entities.Mistake]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.cogroo.tools.checker")``.

    AbstractChecker: typing.Type[AbstractChecker]
    AbstractGenericChecker: typing.Type[AbstractGenericChecker]
    AbstractTypedChecker: typing.Type[AbstractTypedChecker]
    Checker: typing.Type[Checker]
    CheckerComposite: typing.Type[CheckerComposite]
    GenericChecker: typing.Type[GenericChecker]
    GenericCheckerComposite: typing.Type[GenericCheckerComposite]
    JavaRuleDefinition: typing.Type[JavaRuleDefinition]
    Merger: typing.Type[Merger]
    RuleDefinition: typing.Type[RuleDefinition]
    RuleType: typing.Type[RuleType]
    SentenceAdapter: typing.Type[SentenceAdapter]
    TypedChecker: typing.Type[TypedChecker]
    TypedCheckerComposite: typing.Type[TypedCheckerComposite]
    checkers: org.cogroo.tools.checker.checkers.__module_protocol__
    rules: org.cogroo.tools.checker.rules.__module_protocol__
